/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowConnectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowConnectionConfiguration.Builder, FlowConnectionConfiguration> {
    private static final SdkField<FlowDataConnectionConfiguration> DATA_FIELD = SdkField
            .<FlowDataConnectionConfiguration> builder(MarshallingType.SDK_POJO).memberName("data")
            .getter(getter(FlowConnectionConfiguration::data)).setter(setter(Builder::data))
            .constructor(FlowDataConnectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<FlowConditionalConnectionConfiguration> CONDITIONAL_FIELD = SdkField
            .<FlowConditionalConnectionConfiguration> builder(MarshallingType.SDK_POJO).memberName("conditional")
            .getter(getter(FlowConnectionConfiguration::conditional)).setter(setter(Builder::conditional))
            .constructor(FlowConditionalConnectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditional").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DATA_FIELD, CONDITIONAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowDataConnectionConfiguration data;

    private final FlowConditionalConnectionConfiguration conditional;

    private final Type type;

    private FlowConnectionConfiguration(BuilderImpl builder) {
        this.data = builder.data;
        this.conditional = builder.conditional;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration of a connection originating from a node that isn't a Condition node.
     * </p>
     * 
     * @return The configuration of a connection originating from a node that isn't a Condition node.
     */
    public final FlowDataConnectionConfiguration data() {
        return data;
    }

    /**
     * <p>
     * The configuration of a connection originating from a Condition node.
     * </p>
     * 
     * @return The configuration of a connection originating from a Condition node.
     */
    public final FlowConditionalConnectionConfiguration conditional() {
        return conditional;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(conditional());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowConnectionConfiguration)) {
            return false;
        }
        FlowConnectionConfiguration other = (FlowConnectionConfiguration) obj;
        return Objects.equals(data(), other.data()) && Objects.equals(conditional(), other.conditional());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowConnectionConfiguration").add("Data", data()).add("Conditional", conditional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "conditional":
            return Optional.ofNullable(clazz.cast(conditional()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #data()} initialized to the given value.
     *
     * <p>
     * The configuration of a connection originating from a node that isn't a Condition node.
     * </p>
     * 
     * @param data
     *        The configuration of a connection originating from a node that isn't a Condition node.
     */
    public static FlowConnectionConfiguration fromData(FlowDataConnectionConfiguration data) {
        return builder().data(data).build();
    }

    /**
     * Create an instance of this class with {@link #data()} initialized to the given value.
     *
     * <p>
     * The configuration of a connection originating from a node that isn't a Condition node.
     * </p>
     * 
     * @param data
     *        The configuration of a connection originating from a node that isn't a Condition node.
     */
    public static FlowConnectionConfiguration fromData(Consumer<FlowDataConnectionConfiguration.Builder> data) {
        FlowDataConnectionConfiguration.Builder builder = FlowDataConnectionConfiguration.builder();
        data.accept(builder);
        return fromData(builder.build());
    }

    /**
     * Create an instance of this class with {@link #conditional()} initialized to the given value.
     *
     * <p>
     * The configuration of a connection originating from a Condition node.
     * </p>
     * 
     * @param conditional
     *        The configuration of a connection originating from a Condition node.
     */
    public static FlowConnectionConfiguration fromConditional(FlowConditionalConnectionConfiguration conditional) {
        return builder().conditional(conditional).build();
    }

    /**
     * Create an instance of this class with {@link #conditional()} initialized to the given value.
     *
     * <p>
     * The configuration of a connection originating from a Condition node.
     * </p>
     * 
     * @param conditional
     *        The configuration of a connection originating from a Condition node.
     */
    public static FlowConnectionConfiguration fromConditional(Consumer<FlowConditionalConnectionConfiguration.Builder> conditional) {
        FlowConditionalConnectionConfiguration.Builder builder = FlowConditionalConnectionConfiguration.builder();
        conditional.accept(builder);
        return fromConditional(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("data", DATA_FIELD);
        map.put("conditional", CONDITIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowConnectionConfiguration, T> g) {
        return obj -> g.apply((FlowConnectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowConnectionConfiguration> {
        /**
         * <p>
         * The configuration of a connection originating from a node that isn't a Condition node.
         * </p>
         * 
         * @param data
         *        The configuration of a connection originating from a node that isn't a Condition node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(FlowDataConnectionConfiguration data);

        /**
         * <p>
         * The configuration of a connection originating from a node that isn't a Condition node.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowDataConnectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link FlowDataConnectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowDataConnectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #data(FlowDataConnectionConfiguration)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link FlowDataConnectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(FlowDataConnectionConfiguration)
         */
        default Builder data(Consumer<FlowDataConnectionConfiguration.Builder> data) {
            return data(FlowDataConnectionConfiguration.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * The configuration of a connection originating from a Condition node.
         * </p>
         * 
         * @param conditional
         *        The configuration of a connection originating from a Condition node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditional(FlowConditionalConnectionConfiguration conditional);

        /**
         * <p>
         * The configuration of a connection originating from a Condition node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FlowConditionalConnectionConfiguration.Builder} avoiding the need to create one manually via
         * {@link FlowConditionalConnectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowConditionalConnectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #conditional(FlowConditionalConnectionConfiguration)}.
         * 
         * @param conditional
         *        a consumer that will call methods on {@link FlowConditionalConnectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditional(FlowConditionalConnectionConfiguration)
         */
        default Builder conditional(Consumer<FlowConditionalConnectionConfiguration.Builder> conditional) {
            return conditional(FlowConditionalConnectionConfiguration.builder().applyMutation(conditional).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FlowDataConnectionConfiguration data;

        private FlowConditionalConnectionConfiguration conditional;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowConnectionConfiguration model) {
            data(model.data);
            conditional(model.conditional);
        }

        public final FlowDataConnectionConfiguration.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(FlowDataConnectionConfiguration.BuilderImpl data) {
            Object oldValue = this.data;
            this.data = data != null ? data.build() : null;
            handleUnionValueChange(Type.DATA, oldValue, this.data);
        }

        @Override
        public final Builder data(FlowDataConnectionConfiguration data) {
            Object oldValue = this.data;
            this.data = data;
            handleUnionValueChange(Type.DATA, oldValue, this.data);
            return this;
        }

        public final FlowConditionalConnectionConfiguration.Builder getConditional() {
            return conditional != null ? conditional.toBuilder() : null;
        }

        public final void setConditional(FlowConditionalConnectionConfiguration.BuilderImpl conditional) {
            Object oldValue = this.conditional;
            this.conditional = conditional != null ? conditional.build() : null;
            handleUnionValueChange(Type.CONDITIONAL, oldValue, this.conditional);
        }

        @Override
        public final Builder conditional(FlowConditionalConnectionConfiguration conditional) {
            Object oldValue = this.conditional;
            this.conditional = conditional;
            handleUnionValueChange(Type.CONDITIONAL, oldValue, this.conditional);
            return this;
        }

        @Override
        public FlowConnectionConfiguration build() {
            return new FlowConnectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FlowConnectionConfiguration#type()
     */
    public enum Type {
        DATA,

        CONDITIONAL,

        UNKNOWN_TO_SDK_VERSION
    }
}
