/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a malformed input expression in a node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalformedNodeInputExpressionFlowValidationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<MalformedNodeInputExpressionFlowValidationDetails.Builder, MalformedNodeInputExpressionFlowValidationDetails> {
    private static final SdkField<String> NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("node")
            .getter(getter(MalformedNodeInputExpressionFlowValidationDetails::node)).setter(setter(Builder::node))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("node").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(MalformedNodeInputExpressionFlowValidationDetails::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cause")
            .getter(getter(MalformedNodeInputExpressionFlowValidationDetails::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_FIELD, INPUT_FIELD,
            CAUSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String node;

    private final String input;

    private final String causeValue;

    private MalformedNodeInputExpressionFlowValidationDetails(BuilderImpl builder) {
        this.node = builder.node;
        this.input = builder.input;
        this.causeValue = builder.causeValue;
    }

    /**
     * <p>
     * The name of the node containing the malformed input expression.
     * </p>
     * 
     * @return The name of the node containing the malformed input expression.
     */
    public final String node() {
        return node;
    }

    /**
     * <p>
     * The name of the input with the malformed expression.
     * </p>
     * 
     * @return The name of the input with the malformed expression.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * The error message describing why the input expression is malformed.
     * </p>
     * 
     * @return The error message describing why the input expression is malformed.
     */
    public final String cause() {
        return causeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(node());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalformedNodeInputExpressionFlowValidationDetails)) {
            return false;
        }
        MalformedNodeInputExpressionFlowValidationDetails other = (MalformedNodeInputExpressionFlowValidationDetails) obj;
        return Objects.equals(node(), other.node()) && Objects.equals(input(), other.input())
                && Objects.equals(cause(), other.cause());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalformedNodeInputExpressionFlowValidationDetails").add("Node", node()).add("Input", input())
                .add("Cause", cause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "node":
            return Optional.ofNullable(clazz.cast(node()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("node", NODE_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("cause", CAUSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalformedNodeInputExpressionFlowValidationDetails, T> g) {
        return obj -> g.apply((MalformedNodeInputExpressionFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalformedNodeInputExpressionFlowValidationDetails> {
        /**
         * <p>
         * The name of the node containing the malformed input expression.
         * </p>
         * 
         * @param node
         *        The name of the node containing the malformed input expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder node(String node);

        /**
         * <p>
         * The name of the input with the malformed expression.
         * </p>
         * 
         * @param input
         *        The name of the input with the malformed expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The error message describing why the input expression is malformed.
         * </p>
         * 
         * @param causeValue
         *        The error message describing why the input expression is malformed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String causeValue);
    }

    static final class BuilderImpl implements Builder {
        private String node;

        private String input;

        private String causeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MalformedNodeInputExpressionFlowValidationDetails model) {
            node(model.node);
            input(model.input);
            cause(model.causeValue);
        }

        public final String getNode() {
            return node;
        }

        public final void setNode(String node) {
            this.node = node;
        }

        @Override
        public final Builder node(String node) {
            this.node = node;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getCause() {
            return causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        @Override
        public MalformedNodeInputExpressionFlowValidationDetails build() {
            return new MalformedNodeInputExpressionFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
