/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher;

/**
 * Service client for accessing Agents for Amazon Bedrock Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Contains APIs related to model invocation and querying of knowledge bases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agent-runtime";

    /**
     * <p>
     * Sends a prompt for the agent to process and respond to.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support <code>InvokeAgent</code>.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you
     * follow the agent's reasoning process that led it to the information it processed, the actions it took, and the
     * final result it yielded. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * End a conversation by setting <code>endSession</code> to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Include attributes for the session or prompt in the <code>sessionState</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The response is returned in the <code>bytes</code> field of the <code>chunk</code> object.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>attribution</code> object contains citations for parts of the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent's steps and
     * reasoning process that led it to the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors are also surfaced in the response.
     * </p>
     * </li>
     * </ul>
     *
     * @param invokeAgentRequest
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(InvokeAgentRequest invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a prompt for the agent to process and respond to.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support <code>InvokeAgent</code>.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you
     * follow the agent's reasoning process that led it to the information it processed, the actions it took, and the
     * final result it yielded. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * End a conversation by setting <code>endSession</code> to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Include attributes for the session or prompt in the <code>sessionState</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The response is returned in the <code>bytes</code> field of the <code>chunk</code> object.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>attribution</code> object contains citations for parts of the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent's steps and
     * reasoning process that led it to the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors are also surfaced in the response.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeAgentRequest#builder()}
     * </p>
     *
     * @param invokeAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(Consumer<InvokeAgentRequest.Builder> invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        return invokeAgent(InvokeAgentRequest.builder().applyMutation(invokeAgentRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     *
     * @param retrieveRequest
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(RetrieveRequest retrieveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrieve(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results. The response only cites sources
     * that are relevant to the query.
     * </p>
     *
     * @param retrieveAndGenerateRequest
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            RetrieveAndGenerateRequest retrieveAndGenerateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results. The response only cites sources
     * that are relevant to the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveAndGenerateRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            Consumer<RetrieveAndGenerateRequest.Builder> retrieveAndGenerateRequest) {
        return retrieveAndGenerate(RetrieveAndGenerateRequest.builder().applyMutation(retrieveAndGenerateRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     *
     * @param retrieveRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(RetrieveRequest retrieveRequest) {
        return new RetrievePublisher(this, retrieveRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrievePaginator(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    @Override
    default BedrockAgentRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentRuntimeAsyncClient}.
     */
    static BedrockAgentRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockAgentRuntimeAsyncClientBuilder();
    }
}
