/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeAgentVisitorBuilder implements InvokeAgentResponseHandler.Visitor.Builder {
    private Consumer<ResponseStream> onDefault;

    private Consumer<PayloadPart> onChunk;

    private Consumer<TracePart> onTrace;

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onDefault(Consumer<ResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeAgentResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onChunk(Consumer<PayloadPart> c) {
        this.onChunk = c;
        return this;
    }

    @Override
    public InvokeAgentResponseHandler.Visitor.Builder onTrace(Consumer<TracePart> c) {
        this.onTrace = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeAgentResponseHandler.Visitor {
        private final Consumer<ResponseStream> onDefault;

        private final Consumer<PayloadPart> onChunk;

        private final Consumer<TracePart> onTrace;

        VisitorFromBuilder(DefaultInvokeAgentVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeAgentResponseHandler.Visitor.super::visitDefault;
            this.onChunk = builder.onChunk != null ? builder.onChunk : InvokeAgentResponseHandler.Visitor.super::visitChunk;
            this.onTrace = builder.onTrace != null ? builder.onTrace : InvokeAgentResponseHandler.Visitor.super::visitTrace;
        }

        @Override
        public void visitDefault(ResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitChunk(PayloadPart event) {
            onChunk.accept(event);
        }

        @Override
        public void visitTrace(TracePart event) {
            onTrace.accept(event);
        }
    }
}
