/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for response generation based on the knowledge base query results.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax"
 * >RetrieveAndGenerate request</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerationConfiguration.Builder, GenerationConfiguration> {
    private static final SdkField<PromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField
            .<PromptTemplate> builder(MarshallingType.SDK_POJO).memberName("promptTemplate")
            .getter(getter(GenerationConfiguration::promptTemplate)).setter(setter(Builder::promptTemplate))
            .constructor(PromptTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final PromptTemplate promptTemplate;

    private GenerationConfiguration(BuilderImpl builder) {
        this.promptTemplate = builder.promptTemplate;
    }

    /**
     * <p>
     * Contains the template for the prompt that's sent to the model for response generation.
     * </p>
     * 
     * @return Contains the template for the prompt that's sent to the model for response generation.
     */
    public final PromptTemplate promptTemplate() {
        return promptTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationConfiguration)) {
            return false;
        }
        GenerationConfiguration other = (GenerationConfiguration) obj;
        return Objects.equals(promptTemplate(), other.promptTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerationConfiguration").add("PromptTemplate", promptTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptTemplate":
            return Optional.ofNullable(clazz.cast(promptTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerationConfiguration, T> g) {
        return obj -> g.apply((GenerationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerationConfiguration> {
        /**
         * <p>
         * Contains the template for the prompt that's sent to the model for response generation.
         * </p>
         * 
         * @param promptTemplate
         *        Contains the template for the prompt that's sent to the model for response generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptTemplate(PromptTemplate promptTemplate);

        /**
         * <p>
         * Contains the template for the prompt that's sent to the model for response generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptTemplate.Builder} avoiding the need
         * to create one manually via {@link PromptTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #promptTemplate(PromptTemplate)}.
         * 
         * @param promptTemplate
         *        a consumer that will call methods on {@link PromptTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptTemplate(PromptTemplate)
         */
        default Builder promptTemplate(Consumer<PromptTemplate.Builder> promptTemplate) {
            return promptTemplate(PromptTemplate.builder().applyMutation(promptTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PromptTemplate promptTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationConfiguration model) {
            promptTemplate(model.promptTemplate);
        }

        public final PromptTemplate.Builder getPromptTemplate() {
            return promptTemplate != null ? promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(PromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        @Override
        public GenerationConfiguration build() {
            return new GenerationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
