/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an input into the flow and what to do with it.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_RequestSyntax"
 * >InvokeFlow request</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowInput implements SdkPojo, Serializable, ToCopyableBuilder<FlowInput.Builder, FlowInput> {
    private static final SdkField<FlowInputContent> CONTENT_FIELD = SdkField.<FlowInputContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(FlowInput::content)).setter(setter(Builder::content))
            .constructor(FlowInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowInput::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<String> NODE_OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeOutputName").getter(getter(FlowInput::nodeOutputName)).setter(setter(Builder::nodeOutputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            NODE_NAME_FIELD, NODE_OUTPUT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final FlowInputContent content;

    private final String nodeName;

    private final String nodeOutputName;

    private FlowInput(BuilderImpl builder) {
        this.content = builder.content;
        this.nodeName = builder.nodeName;
        this.nodeOutputName = builder.nodeOutputName;
    }

    /**
     * <p>
     * Contains information about an input into the flow.
     * </p>
     * 
     * @return Contains information about an input into the flow.
     */
    public final FlowInputContent content() {
        return content;
    }

    /**
     * <p>
     * A name for the input of the flow input node.
     * </p>
     * 
     * @return A name for the input of the flow input node.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * A name for the output of the flow input node.
     * </p>
     * 
     * @return A name for the output of the flow input node.
     */
    public final String nodeOutputName() {
        return nodeOutputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOutputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowInput)) {
            return false;
        }
        FlowInput other = (FlowInput) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(nodeName(), other.nodeName())
                && Objects.equals(nodeOutputName(), other.nodeOutputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowInput").add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeName", nodeName()).add("NodeOutputName", nodeOutputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "nodeOutputName":
            return Optional.ofNullable(clazz.cast(nodeOutputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowInput, T> g) {
        return obj -> g.apply((FlowInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowInput> {
        /**
         * <p>
         * Contains information about an input into the flow.
         * </p>
         * 
         * @param content
         *        Contains information about an input into the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowInputContent content);

        /**
         * <p>
         * Contains information about an input into the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowInputContent.Builder} avoiding the
         * need to create one manually via {@link FlowInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowInputContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(FlowInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowInputContent)
         */
        default Builder content(Consumer<FlowInputContent.Builder> content) {
            return content(FlowInputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * A name for the input of the flow input node.
         * </p>
         * 
         * @param nodeName
         *        A name for the input of the flow input node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * A name for the output of the flow input node.
         * </p>
         * 
         * @param nodeOutputName
         *        A name for the output of the flow input node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOutputName(String nodeOutputName);
    }

    static final class BuilderImpl implements Builder {
        private FlowInputContent content;

        private String nodeName;

        private String nodeOutputName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowInput model) {
            content(model.content);
            nodeName(model.nodeName);
            nodeOutputName(model.nodeOutputName);
        }

        public final FlowInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowInputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeOutputName() {
            return nodeOutputName;
        }

        public final void setNodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
        }

        @Override
        public final Builder nodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
            return this;
        }

        @Override
        public FlowInput build() {
            return new FlowInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
