/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations of the external source wrapper object in the <code>retrieveAndGenerate</code> function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalSourcesRetrieveAndGenerateConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ExternalSourcesRetrieveAndGenerateConfiguration.Builder, ExternalSourcesRetrieveAndGenerateConfiguration> {
    private static final SdkField<ExternalSourcesGenerationConfiguration> GENERATION_CONFIGURATION_FIELD = SdkField
            .<ExternalSourcesGenerationConfiguration> builder(MarshallingType.SDK_POJO).memberName("generationConfiguration")
            .getter(getter(ExternalSourcesRetrieveAndGenerateConfiguration::generationConfiguration))
            .setter(setter(Builder::generationConfiguration)).constructor(ExternalSourcesGenerationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationConfiguration").build())
            .build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(ExternalSourcesRetrieveAndGenerateConfiguration::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<List<ExternalSource>> SOURCES_FIELD = SdkField
            .<List<ExternalSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(ExternalSourcesRetrieveAndGenerateConfiguration::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExternalSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExternalSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GENERATION_CONFIGURATION_FIELD, MODEL_ARN_FIELD, SOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExternalSourcesGenerationConfiguration generationConfiguration;

    private final String modelArn;

    private final List<ExternalSource> sources;

    private ExternalSourcesRetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.generationConfiguration = builder.generationConfiguration;
        this.modelArn = builder.modelArn;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * The prompt used with the external source wrapper object with the <code>retrieveAndGenerate</code> function.
     * </p>
     * 
     * @return The prompt used with the external source wrapper object with the <code>retrieveAndGenerate</code>
     *         function.
     */
    public final ExternalSourcesGenerationConfiguration generationConfiguration() {
        return generationConfiguration;
    }

    /**
     * <p>
     * The model Amazon Resource Name (ARN) for the external source wrapper object in the
     * <code>retrieveAndGenerate</code> function.
     * </p>
     * 
     * @return The model Amazon Resource Name (ARN) for the external source wrapper object in the
     *         <code>retrieveAndGenerate</code> function.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
     */
    public final List<ExternalSource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSourcesRetrieveAndGenerateConfiguration)) {
            return false;
        }
        ExternalSourcesRetrieveAndGenerateConfiguration other = (ExternalSourcesRetrieveAndGenerateConfiguration) obj;
        return Objects.equals(generationConfiguration(), other.generationConfiguration())
                && Objects.equals(modelArn(), other.modelArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalSourcesRetrieveAndGenerateConfiguration")
                .add("GenerationConfiguration", generationConfiguration()).add("ModelArn", modelArn())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generationConfiguration":
            return Optional.ofNullable(clazz.cast(generationConfiguration()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalSourcesRetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((ExternalSourcesRetrieveAndGenerateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalSourcesRetrieveAndGenerateConfiguration> {
        /**
         * <p>
         * The prompt used with the external source wrapper object with the <code>retrieveAndGenerate</code> function.
         * </p>
         * 
         * @param generationConfiguration
         *        The prompt used with the external source wrapper object with the <code>retrieveAndGenerate</code>
         *        function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationConfiguration(ExternalSourcesGenerationConfiguration generationConfiguration);

        /**
         * <p>
         * The prompt used with the external source wrapper object with the <code>retrieveAndGenerate</code> function.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExternalSourcesGenerationConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExternalSourcesGenerationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalSourcesGenerationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #generationConfiguration(ExternalSourcesGenerationConfiguration)}.
         * 
         * @param generationConfiguration
         *        a consumer that will call methods on {@link ExternalSourcesGenerationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationConfiguration(ExternalSourcesGenerationConfiguration)
         */
        default Builder generationConfiguration(Consumer<ExternalSourcesGenerationConfiguration.Builder> generationConfiguration) {
            return generationConfiguration(ExternalSourcesGenerationConfiguration.builder()
                    .applyMutation(generationConfiguration).build());
        }

        /**
         * <p>
         * The model Amazon Resource Name (ARN) for the external source wrapper object in the
         * <code>retrieveAndGenerate</code> function.
         * </p>
         * 
         * @param modelArn
         *        The model Amazon Resource Name (ARN) for the external source wrapper object in the
         *        <code>retrieveAndGenerate</code> function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
         * </p>
         * 
         * @param sources
         *        The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<ExternalSource> sources);

        /**
         * <p>
         * The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
         * </p>
         * 
         * @param sources
         *        The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(ExternalSource... sources);

        /**
         * <p>
         * The document for the external source wrapper object in the <code>retrieveAndGenerate</code> function.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<ExternalSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<ExternalSource>)
         */
        Builder sources(Consumer<ExternalSource.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private ExternalSourcesGenerationConfiguration generationConfiguration;

        private String modelArn;

        private List<ExternalSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSourcesRetrieveAndGenerateConfiguration model) {
            generationConfiguration(model.generationConfiguration);
            modelArn(model.modelArn);
            sources(model.sources);
        }

        public final ExternalSourcesGenerationConfiguration.Builder getGenerationConfiguration() {
            return generationConfiguration != null ? generationConfiguration.toBuilder() : null;
        }

        public final void setGenerationConfiguration(ExternalSourcesGenerationConfiguration.BuilderImpl generationConfiguration) {
            this.generationConfiguration = generationConfiguration != null ? generationConfiguration.build() : null;
        }

        @Override
        public final Builder generationConfiguration(ExternalSourcesGenerationConfiguration generationConfiguration) {
            this.generationConfiguration = generationConfiguration;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final List<ExternalSource.Builder> getSources() {
            List<ExternalSource.Builder> result = ExternalSourcesCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ExternalSource.BuilderImpl> sources) {
            this.sources = ExternalSourcesCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ExternalSource> sources) {
            this.sources = ExternalSourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ExternalSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ExternalSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> ExternalSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExternalSourcesRetrieveAndGenerateConfiguration build() {
            return new ExternalSourcesRetrieveAndGenerateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
