/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source file of the content contained in the wrapper object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSource implements SdkPojo, Serializable, ToCopyableBuilder<FileSource.Builder, FileSource> {
    private static final SdkField<ByteContentFile> BYTE_CONTENT_FIELD = SdkField
            .<ByteContentFile> builder(MarshallingType.SDK_POJO).memberName("byteContent")
            .getter(getter(FileSource::byteContent)).setter(setter(Builder::byteContent)).constructor(ByteContentFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()).build();

    private static final SdkField<S3ObjectFile> S3_LOCATION_FIELD = SdkField.<S3ObjectFile> builder(MarshallingType.SDK_POJO)
            .memberName("s3Location").getter(getter(FileSource::s3Location)).setter(setter(Builder::s3Location))
            .constructor(S3ObjectFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(FileSource::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_CONTENT_FIELD,
            S3_LOCATION_FIELD, SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("byteContent", BYTE_CONTENT_FIELD);
                    put("s3Location", S3_LOCATION_FIELD);
                    put("sourceType", SOURCE_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ByteContentFile byteContent;

    private final S3ObjectFile s3Location;

    private final String sourceType;

    private FileSource(BuilderImpl builder) {
        this.byteContent = builder.byteContent;
        this.s3Location = builder.s3Location;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The data and the text of the attached files.
     * </p>
     * 
     * @return The data and the text of the attached files.
     */
    public final ByteContentFile byteContent() {
        return byteContent;
    }

    /**
     * <p>
     * The s3 location of the files to attach.
     * </p>
     * 
     * @return The s3 location of the files to attach.
     */
    public final S3ObjectFile s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The source type of the files to attach.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link FileSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the files to attach.
     * @see FileSourceType
     */
    public final FileSourceType sourceType() {
        return FileSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source type of the files to attach.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link FileSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the files to attach.
     * @see FileSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSource)) {
            return false;
        }
        FileSource other = (FileSource) obj;
        return Objects.equals(byteContent(), other.byteContent()) && Objects.equals(s3Location(), other.s3Location())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSource").add("ByteContent", byteContent()).add("S3Location", s3Location())
                .add("SourceType", sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "byteContent":
            return Optional.ofNullable(clazz.cast(byteContent()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileSource, T> g) {
        return obj -> g.apply((FileSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSource> {
        /**
         * <p>
         * The data and the text of the attached files.
         * </p>
         * 
         * @param byteContent
         *        The data and the text of the attached files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteContent(ByteContentFile byteContent);

        /**
         * <p>
         * The data and the text of the attached files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByteContentFile.Builder} avoiding the
         * need to create one manually via {@link ByteContentFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByteContentFile.Builder#build()} is called immediately and its
         * result is passed to {@link #byteContent(ByteContentFile)}.
         * 
         * @param byteContent
         *        a consumer that will call methods on {@link ByteContentFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteContent(ByteContentFile)
         */
        default Builder byteContent(Consumer<ByteContentFile.Builder> byteContent) {
            return byteContent(ByteContentFile.builder().applyMutation(byteContent).build());
        }

        /**
         * <p>
         * The s3 location of the files to attach.
         * </p>
         * 
         * @param s3Location
         *        The s3 location of the files to attach.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3ObjectFile s3Location);

        /**
         * <p>
         * The s3 location of the files to attach.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ObjectFile.Builder} avoiding the need
         * to create one manually via {@link S3ObjectFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ObjectFile.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Location(S3ObjectFile)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3ObjectFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3ObjectFile)
         */
        default Builder s3Location(Consumer<S3ObjectFile.Builder> s3Location) {
            return s3Location(S3ObjectFile.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The source type of the files to attach.
         * </p>
         * 
         * @param sourceType
         *        The source type of the files to attach.
         * @see FileSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source type of the files to attach.
         * </p>
         * 
         * @param sourceType
         *        The source type of the files to attach.
         * @see FileSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceType
         */
        Builder sourceType(FileSourceType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private ByteContentFile byteContent;

        private S3ObjectFile s3Location;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSource model) {
            byteContent(model.byteContent);
            s3Location(model.s3Location);
            sourceType(model.sourceType);
        }

        public final ByteContentFile.Builder getByteContent() {
            return byteContent != null ? byteContent.toBuilder() : null;
        }

        public final void setByteContent(ByteContentFile.BuilderImpl byteContent) {
            this.byteContent = byteContent != null ? byteContent.build() : null;
        }

        @Override
        public final Builder byteContent(ByteContentFile byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final S3ObjectFile.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3ObjectFile.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3ObjectFile s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(FileSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        @Override
        public FileSource build() {
            return new FileSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
