/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an output from prompt flow invoction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FlowOutputEvent implements SdkPojo, Serializable, ToCopyableBuilder<FlowOutputEvent.Builder, FlowOutputEvent>,
        FlowResponseStream {
    private static final SdkField<FlowOutputContent> CONTENT_FIELD = SdkField
            .<FlowOutputContent> builder(MarshallingType.SDK_POJO).memberName("content").getter(getter(FlowOutputEvent::content))
            .setter(setter(Builder::content)).constructor(FlowOutputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowOutputEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeType").getter(getter(FlowOutputEvent::nodeTypeAsString)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            NODE_NAME_FIELD, NODE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("content", CONTENT_FIELD);
                    put("nodeName", NODE_NAME_FIELD);
                    put("nodeType", NODE_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final FlowOutputContent content;

    private final String nodeName;

    private final String nodeType;

    protected FlowOutputEvent(BuilderImpl builder) {
        this.content = builder.content;
        this.nodeName = builder.nodeName;
        this.nodeType = builder.nodeType;
    }

    /**
     * <p>
     * The content in the output.
     * </p>
     * 
     * @return The content in the output.
     */
    public final FlowOutputContent content() {
        return content;
    }

    /**
     * <p>
     * The name of the flow output node that the output is from.
     * </p>
     * 
     * @return The name of the flow output node that the output is from.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The type of the node that the output is from.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return The type of the node that the output is from.
     * @see NodeType
     */
    public final NodeType nodeType() {
        return NodeType.fromValue(nodeType);
    }

    /**
     * <p>
     * The type of the node that the output is from.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return The type of the node that the output is from.
     * @see NodeType
     */
    public final String nodeTypeAsString() {
        return nodeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowOutputEvent)) {
            return false;
        }
        FlowOutputEvent other = (FlowOutputEvent) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(nodeName(), other.nodeName())
                && Objects.equals(nodeTypeAsString(), other.nodeTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowOutputEvent").add("Content", content()).add("NodeName", nodeName())
                .add("NodeType", nodeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "nodeType":
            return Optional.ofNullable(clazz.cast(nodeTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final FlowOutputEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FlowOutputEvent, T> g) {
        return obj -> g.apply((FlowOutputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link FlowOutputEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeFlowResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowOutputEvent> {
        /**
         * <p>
         * The content in the output.
         * </p>
         * 
         * @param content
         *        The content in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowOutputContent content);

        /**
         * <p>
         * The content in the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowOutputContent.Builder} avoiding the
         * need to create one manually via {@link FlowOutputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowOutputContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(FlowOutputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowOutputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowOutputContent)
         */
        default Builder content(Consumer<FlowOutputContent.Builder> content) {
            return content(FlowOutputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The name of the flow output node that the output is from.
         * </p>
         * 
         * @param nodeName
         *        The name of the flow output node that the output is from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The type of the node that the output is from.
         * </p>
         * 
         * @param nodeType
         *        The type of the node that the output is from.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The type of the node that the output is from.
         * </p>
         * 
         * @param nodeType
         *        The type of the node that the output is from.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(NodeType nodeType);
    }

    protected static class BuilderImpl implements Builder {
        private FlowOutputContent content;

        private String nodeName;

        private String nodeType;

        protected BuilderImpl() {
        }

        protected BuilderImpl(FlowOutputEvent model) {
            content(model.content);
            nodeName(model.nodeName);
            nodeType(model.nodeType);
        }

        public final FlowOutputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowOutputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowOutputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        @Override
        public FlowOutputEvent build() {
            return new FlowOutputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
