/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the output from a node. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeOutputEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeOutputEvent.Builder, FlowTraceNodeOutputEvent> {
    private static final SdkField<List<FlowTraceNodeOutputField>> FIELDS_FIELD = SdkField
            .<List<FlowTraceNodeOutputField>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(FlowTraceNodeOutputEvent::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowTraceNodeOutputField> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowTraceNodeOutputField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowTraceNodeOutputEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(FlowTraceNodeOutputEvent::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, NODE_NAME_FIELD,
            TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("fields", FIELDS_FIELD);
                    put("nodeName", NODE_NAME_FIELD);
                    put("timestamp", TIMESTAMP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<FlowTraceNodeOutputField> fields;

    private final String nodeName;

    private final Instant timestamp;

    private FlowTraceNodeOutputEvent(BuilderImpl builder) {
        this.fields = builder.fields;
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects containing information about each field in the output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return An array of objects containing information about each field in the output.
     */
    public final List<FlowTraceNodeOutputField> fields() {
        return fields;
    }

    /**
     * <p>
     * The name of the node that yielded the output.
     * </p>
     * 
     * @return The name of the node that yielded the output.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The date and time that the trace was returned.
     * </p>
     * 
     * @return The date and time that the trace was returned.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeOutputEvent)) {
            return false;
        }
        FlowTraceNodeOutputEvent other = (FlowTraceNodeOutputEvent) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(nodeName(), other.nodeName()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeOutputEvent")
                .add("Fields", fields() == null ? null : "*** Sensitive Data Redacted ***").add("NodeName", nodeName())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeOutputEvent, T> g) {
        return obj -> g.apply((FlowTraceNodeOutputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeOutputEvent> {
        /**
         * <p>
         * An array of objects containing information about each field in the output.
         * </p>
         * 
         * @param fields
         *        An array of objects containing information about each field in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<FlowTraceNodeOutputField> fields);

        /**
         * <p>
         * An array of objects containing information about each field in the output.
         * </p>
         * 
         * @param fields
         *        An array of objects containing information about each field in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(FlowTraceNodeOutputField... fields);

        /**
         * <p>
         * An array of objects containing information about each field in the output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputField.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputField.Builder#build()} is
         * called immediately and its result is passed to {@link #fields(List<FlowTraceNodeOutputField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<FlowTraceNodeOutputField>)
         */
        Builder fields(Consumer<FlowTraceNodeOutputField.Builder>... fields);

        /**
         * <p>
         * The name of the node that yielded the output.
         * </p>
         * 
         * @param nodeName
         *        The name of the node that yielded the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The date and time that the trace was returned.
         * </p>
         * 
         * @param timestamp
         *        The date and time that the trace was returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private List<FlowTraceNodeOutputField> fields = DefaultSdkAutoConstructList.getInstance();

        private String nodeName;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeOutputEvent model) {
            fields(model.fields);
            nodeName(model.nodeName);
            timestamp(model.timestamp);
        }

        public final List<FlowTraceNodeOutputField.Builder> getFields() {
            List<FlowTraceNodeOutputField.Builder> result = FlowTraceNodeOutputFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FlowTraceNodeOutputField.BuilderImpl> fields) {
            this.fields = FlowTraceNodeOutputFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FlowTraceNodeOutputField> fields) {
            this.fields = FlowTraceNodeOutputFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FlowTraceNodeOutputField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FlowTraceNodeOutputField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> FlowTraceNodeOutputField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public FlowTraceNodeOutputEvent build() {
            return new FlowTraceNodeOutputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
