/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentMemoryResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<GetAgentMemoryResponse.Builder, GetAgentMemoryResponse> {
    private static final SdkField<List<Memory>> MEMORY_CONTENTS_FIELD = SdkField
            .<List<Memory>> builder(MarshallingType.LIST)
            .memberName("memoryContents")
            .getter(getter(GetAgentMemoryResponse::memoryContents))
            .setter(setter(Builder::memoryContents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryContents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Memory> builder(MarshallingType.SDK_POJO)
                                            .constructor(Memory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetAgentMemoryResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_CONTENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("memoryContents", MEMORY_CONTENTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<Memory> memoryContents;

    private final String nextToken;

    private GetAgentMemoryResponse(BuilderImpl builder) {
        super(builder);
        this.memoryContents = builder.memoryContents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemoryContents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemoryContents() {
        return memoryContents != null && !(memoryContents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details of the sessions stored in the memory
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemoryContents} method.
     * </p>
     * 
     * @return Contains details of the sessions stored in the memory
     */
    public final List<Memory> memoryContents() {
        return memoryContents;
    }

    /**
     * <p>
     * If the total number of results is greater than the maxItems value provided in the request, use this token when
     * making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the maxItems value provided in the request, use this token
     *         when making another request in the <code>nextToken</code> field to return the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemoryContents() ? memoryContents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentMemoryResponse)) {
            return false;
        }
        GetAgentMemoryResponse other = (GetAgentMemoryResponse) obj;
        return hasMemoryContents() == other.hasMemoryContents() && Objects.equals(memoryContents(), other.memoryContents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentMemoryResponse").add("MemoryContents", hasMemoryContents() ? memoryContents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memoryContents":
            return Optional.ofNullable(clazz.cast(memoryContents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAgentMemoryResponse, T> g) {
        return obj -> g.apply((GetAgentMemoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgentMemoryResponse> {
        /**
         * <p>
         * Contains details of the sessions stored in the memory
         * </p>
         * 
         * @param memoryContents
         *        Contains details of the sessions stored in the memory
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryContents(Collection<Memory> memoryContents);

        /**
         * <p>
         * Contains details of the sessions stored in the memory
         * </p>
         * 
         * @param memoryContents
         *        Contains details of the sessions stored in the memory
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryContents(Memory... memoryContents);

        /**
         * <p>
         * Contains details of the sessions stored in the memory
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Memory.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagentruntime.model.Memory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Memory.Builder#build()} is called
         * immediately and its result is passed to {@link #memoryContents(List<Memory>)}.
         * 
         * @param memoryContents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.Memory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryContents(java.util.Collection<Memory>)
         */
        Builder memoryContents(Consumer<Memory.Builder>... memoryContents);

        /**
         * <p>
         * If the total number of results is greater than the maxItems value provided in the request, use this token
         * when making another request in the <code>nextToken</code> field to return the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the maxItems value provided in the request, use this
         *        token when making another request in the <code>nextToken</code> field to return the next batch of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private List<Memory> memoryContents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentMemoryResponse model) {
            super(model);
            memoryContents(model.memoryContents);
            nextToken(model.nextToken);
        }

        public final List<Memory.Builder> getMemoryContents() {
            List<Memory.Builder> result = MemoriesCopier.copyToBuilder(this.memoryContents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemoryContents(Collection<Memory.BuilderImpl> memoryContents) {
            this.memoryContents = MemoriesCopier.copyFromBuilder(memoryContents);
        }

        @Override
        public final Builder memoryContents(Collection<Memory> memoryContents) {
            this.memoryContents = MemoriesCopier.copy(memoryContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryContents(Memory... memoryContents) {
            memoryContents(Arrays.asList(memoryContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memoryContents(Consumer<Memory.Builder>... memoryContents) {
            memoryContents(Stream.of(memoryContents).map(c -> Memory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAgentMemoryResponse build() {
            return new GetAgentMemoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
