/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailConfiguration.Builder, GuardrailConfiguration> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailId").getter(getter(GuardrailConfiguration::guardrailId)).setter(setter(Builder::guardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()).build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(GuardrailConfiguration::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD,
            GUARDRAIL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("guardrailId", GUARDRAIL_ID_FIELD);
                    put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String guardrailId;

    private final String guardrailVersion;

    private GuardrailConfiguration(BuilderImpl builder) {
        this.guardrailId = builder.guardrailId;
        this.guardrailVersion = builder.guardrailVersion;
    }

    /**
     * <p>
     * The unique identifier for the guardrail.
     * </p>
     * 
     * @return The unique identifier for the guardrail.
     */
    public final String guardrailId() {
        return guardrailId;
    }

    /**
     * <p>
     * The version of the guardrail.
     * </p>
     * 
     * @return The version of the guardrail.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConfiguration)) {
            return false;
        }
        GuardrailConfiguration other = (GuardrailConfiguration) obj;
        return Objects.equals(guardrailId(), other.guardrailId()) && Objects.equals(guardrailVersion(), other.guardrailVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailConfiguration").add("GuardrailId", guardrailId())
                .add("GuardrailVersion", guardrailVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailId":
            return Optional.ofNullable(clazz.cast(guardrailId()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConfiguration, T> g) {
        return obj -> g.apply((GuardrailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailConfiguration> {
        /**
         * <p>
         * The unique identifier for the guardrail.
         * </p>
         * 
         * @param guardrailId
         *        The unique identifier for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailId(String guardrailId);

        /**
         * <p>
         * The version of the guardrail.
         * </p>
         * 
         * @param guardrailVersion
         *        The version of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailId;

        private String guardrailVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConfiguration model) {
            guardrailId(model.guardrailId);
            guardrailVersion(model.guardrailVersion);
        }

        public final String getGuardrailId() {
            return guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        @Override
        public GuardrailConfiguration build() {
            return new GuardrailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
