/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom word details for the filter in the Guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailCustomWord implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailCustomWord.Builder, GuardrailCustomWord> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailCustomWord::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("match")
            .getter(getter(GuardrailCustomWord::match)).setter(setter(Builder::match))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("action", ACTION_FIELD);
                    put("match", MATCH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String match;

    private GuardrailCustomWord(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
    }

    /**
     * <p>
     * The action details for the custom word filter in the Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailWordPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action details for the custom word filter in the Guardrail.
     * @see GuardrailWordPolicyAction
     */
    public final GuardrailWordPolicyAction action() {
        return GuardrailWordPolicyAction.fromValue(action);
    }

    /**
     * <p>
     * The action details for the custom word filter in the Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailWordPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action details for the custom word filter in the Guardrail.
     * @see GuardrailWordPolicyAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The match details for the custom word filter in the Guardrail.
     * </p>
     * 
     * @return The match details for the custom word filter in the Guardrail.
     */
    public final String match() {
        return match;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailCustomWord)) {
            return false;
        }
        GuardrailCustomWord other = (GuardrailCustomWord) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(match(), other.match());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailCustomWord").add("Action", actionAsString()).add("Match", match()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailCustomWord, T> g) {
        return obj -> g.apply((GuardrailCustomWord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailCustomWord> {
        /**
         * <p>
         * The action details for the custom word filter in the Guardrail.
         * </p>
         * 
         * @param action
         *        The action details for the custom word filter in the Guardrail.
         * @see GuardrailWordPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordPolicyAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action details for the custom word filter in the Guardrail.
         * </p>
         * 
         * @param action
         *        The action details for the custom word filter in the Guardrail.
         * @see GuardrailWordPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordPolicyAction
         */
        Builder action(GuardrailWordPolicyAction action);

        /**
         * <p>
         * The match details for the custom word filter in the Guardrail.
         * </p>
         * 
         * @param match
         *        The match details for the custom word filter in the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(String match);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String match;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailCustomWord model) {
            action(model.action);
            match(model.match);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailWordPolicyAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getMatch() {
            return match;
        }

        public final void setMatch(String match) {
            this.match = match;
        }

        @Override
        public final Builder match(String match) {
            this.match = match;
            return this;
        }

        @Override
        public GuardrailCustomWord build() {
            return new GuardrailCustomWord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
