/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the sensitive policy assessment used in the Guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailSensitiveInformationPolicyAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailSensitiveInformationPolicyAssessment.Builder, GuardrailSensitiveInformationPolicyAssessment> {
    private static final SdkField<List<GuardrailPiiEntityFilter>> PII_ENTITIES_FIELD = SdkField
            .<List<GuardrailPiiEntityFilter>> builder(MarshallingType.LIST)
            .memberName("piiEntities")
            .getter(getter(GuardrailSensitiveInformationPolicyAssessment::piiEntities))
            .setter(setter(Builder::piiEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailPiiEntityFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailPiiEntityFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailRegexFilter>> REGEXES_FIELD = SdkField
            .<List<GuardrailRegexFilter>> builder(MarshallingType.LIST)
            .memberName("regexes")
            .getter(getter(GuardrailSensitiveInformationPolicyAssessment::regexes))
            .setter(setter(Builder::regexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailRegexFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailRegexFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_FIELD,
            REGEXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("piiEntities", PII_ENTITIES_FIELD);
                    put("regexes", REGEXES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<GuardrailPiiEntityFilter> piiEntities;

    private final List<GuardrailRegexFilter> regexes;

    private GuardrailSensitiveInformationPolicyAssessment(BuilderImpl builder) {
        this.piiEntities = builder.piiEntities;
        this.regexes = builder.regexes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PiiEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPiiEntities() {
        return piiEntities != null && !(piiEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the PII entities used in the sensitive policy assessment for the Guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPiiEntities} method.
     * </p>
     * 
     * @return The details of the PII entities used in the sensitive policy assessment for the Guardrail.
     */
    public final List<GuardrailPiiEntityFilter> piiEntities() {
        return piiEntities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regexes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegexes() {
        return regexes != null && !(regexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the regexes used in the sensitive policy assessment for the Guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexes} method.
     * </p>
     * 
     * @return The details of the regexes used in the sensitive policy assessment for the Guardrail.
     */
    public final List<GuardrailRegexFilter> regexes() {
        return regexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPiiEntities() ? piiEntities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexes() ? regexes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicyAssessment)) {
            return false;
        }
        GuardrailSensitiveInformationPolicyAssessment other = (GuardrailSensitiveInformationPolicyAssessment) obj;
        return hasPiiEntities() == other.hasPiiEntities() && Objects.equals(piiEntities(), other.piiEntities())
                && hasRegexes() == other.hasRegexes() && Objects.equals(regexes(), other.regexes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailSensitiveInformationPolicyAssessment")
                .add("PiiEntities", piiEntities() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Regexes", regexes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "piiEntities":
            return Optional.ofNullable(clazz.cast(piiEntities()));
        case "regexes":
            return Optional.ofNullable(clazz.cast(regexes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSensitiveInformationPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailSensitiveInformationPolicyAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailSensitiveInformationPolicyAssessment> {
        /**
         * <p>
         * The details of the PII entities used in the sensitive policy assessment for the Guardrail.
         * </p>
         * 
         * @param piiEntities
         *        The details of the PII entities used in the sensitive policy assessment for the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntities(Collection<GuardrailPiiEntityFilter> piiEntities);

        /**
         * <p>
         * The details of the PII entities used in the sensitive policy assessment for the Guardrail.
         * </p>
         * 
         * @param piiEntities
         *        The details of the PII entities used in the sensitive policy assessment for the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntities(GuardrailPiiEntityFilter... piiEntities);

        /**
         * <p>
         * The details of the PII entities used in the sensitive policy assessment for the Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailPiiEntityFilter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailPiiEntityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailPiiEntityFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #piiEntities(List<GuardrailPiiEntityFilter>)}.
         * 
         * @param piiEntities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailPiiEntityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #piiEntities(java.util.Collection<GuardrailPiiEntityFilter>)
         */
        Builder piiEntities(Consumer<GuardrailPiiEntityFilter.Builder>... piiEntities);

        /**
         * <p>
         * The details of the regexes used in the sensitive policy assessment for the Guardrail.
         * </p>
         * 
         * @param regexes
         *        The details of the regexes used in the sensitive policy assessment for the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexes(Collection<GuardrailRegexFilter> regexes);

        /**
         * <p>
         * The details of the regexes used in the sensitive policy assessment for the Guardrail.
         * </p>
         * 
         * @param regexes
         *        The details of the regexes used in the sensitive policy assessment for the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexes(GuardrailRegexFilter... regexes);

        /**
         * <p>
         * The details of the regexes used in the sensitive policy assessment for the Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailRegexFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailRegexFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailRegexFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #regexes(List<GuardrailRegexFilter>)}.
         * 
         * @param regexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailRegexFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexes(java.util.Collection<GuardrailRegexFilter>)
         */
        Builder regexes(Consumer<GuardrailRegexFilter.Builder>... regexes);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailPiiEntityFilter> piiEntities = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailRegexFilter> regexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSensitiveInformationPolicyAssessment model) {
            piiEntities(model.piiEntities);
            regexes(model.regexes);
        }

        public final List<GuardrailPiiEntityFilter.Builder> getPiiEntities() {
            List<GuardrailPiiEntityFilter.Builder> result = GuardrailPiiEntityFilterListCopier.copyToBuilder(this.piiEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntities(Collection<GuardrailPiiEntityFilter.BuilderImpl> piiEntities) {
            this.piiEntities = GuardrailPiiEntityFilterListCopier.copyFromBuilder(piiEntities);
        }

        @Override
        public final Builder piiEntities(Collection<GuardrailPiiEntityFilter> piiEntities) {
            this.piiEntities = GuardrailPiiEntityFilterListCopier.copy(piiEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(GuardrailPiiEntityFilter... piiEntities) {
            piiEntities(Arrays.asList(piiEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(Consumer<GuardrailPiiEntityFilter.Builder>... piiEntities) {
            piiEntities(Stream.of(piiEntities).map(c -> GuardrailPiiEntityFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailRegexFilter.Builder> getRegexes() {
            List<GuardrailRegexFilter.Builder> result = GuardrailRegexFilterListCopier.copyToBuilder(this.regexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexes(Collection<GuardrailRegexFilter.BuilderImpl> regexes) {
            this.regexes = GuardrailRegexFilterListCopier.copyFromBuilder(regexes);
        }

        @Override
        public final Builder regexes(Collection<GuardrailRegexFilter> regexes) {
            this.regexes = GuardrailRegexFilterListCopier.copy(regexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(GuardrailRegexFilter... regexes) {
            regexes(Arrays.asList(regexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(Consumer<GuardrailRegexFilter.Builder>... regexes) {
            regexes(Stream.of(regexes).map(c -> GuardrailRegexFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailSensitiveInformationPolicyAssessment build() {
            return new GuardrailSensitiveInformationPolicyAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
