/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The trace details used in the Guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailTrace implements SdkPojo, Serializable, ToCopyableBuilder<GuardrailTrace.Builder, GuardrailTrace> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailTrace::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<List<GuardrailAssessment>> INPUT_ASSESSMENTS_FIELD = SdkField
            .<List<GuardrailAssessment>> builder(MarshallingType.LIST)
            .memberName("inputAssessments")
            .getter(getter(GuardrailTrace::inputAssessments))
            .setter(setter(Builder::inputAssessments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAssessments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAssessment> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAssessment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailAssessment>> OUTPUT_ASSESSMENTS_FIELD = SdkField
            .<List<GuardrailAssessment>> builder(MarshallingType.LIST)
            .memberName("outputAssessments")
            .getter(getter(GuardrailTrace::outputAssessments))
            .setter(setter(Builder::outputAssessments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAssessments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAssessment> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAssessment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(GuardrailTrace::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            INPUT_ASSESSMENTS_FIELD, OUTPUT_ASSESSMENTS_FIELD, TRACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("action", ACTION_FIELD);
                    put("inputAssessments", INPUT_ASSESSMENTS_FIELD);
                    put("outputAssessments", OUTPUT_ASSESSMENTS_FIELD);
                    put("traceId", TRACE_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String action;

    private final List<GuardrailAssessment> inputAssessments;

    private final List<GuardrailAssessment> outputAssessments;

    private final String traceId;

    private GuardrailTrace(BuilderImpl builder) {
        this.action = builder.action;
        this.inputAssessments = builder.inputAssessments;
        this.outputAssessments = builder.outputAssessments;
        this.traceId = builder.traceId;
    }

    /**
     * <p>
     * The trace action details used with the Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The trace action details used with the Guardrail.
     * @see GuardrailAction
     */
    public final GuardrailAction action() {
        return GuardrailAction.fromValue(action);
    }

    /**
     * <p>
     * The trace action details used with the Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The trace action details used with the Guardrail.
     * @see GuardrailAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputAssessments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputAssessments() {
        return inputAssessments != null && !(inputAssessments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the input assessments used in the Guardrail Trace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputAssessments} method.
     * </p>
     * 
     * @return The details of the input assessments used in the Guardrail Trace.
     */
    public final List<GuardrailAssessment> inputAssessments() {
        return inputAssessments;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputAssessments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputAssessments() {
        return outputAssessments != null && !(outputAssessments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the output assessments used in the Guardrail Trace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputAssessments} method.
     * </p>
     * 
     * @return The details of the output assessments used in the Guardrail Trace.
     */
    public final List<GuardrailAssessment> outputAssessments() {
        return outputAssessments;
    }

    /**
     * <p>
     * The details of the trace Id used in the Guardrail Trace.
     * </p>
     * 
     * @return The details of the trace Id used in the Guardrail Trace.
     */
    public final String traceId() {
        return traceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAssessments() ? inputAssessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputAssessments() ? outputAssessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTrace)) {
            return false;
        }
        GuardrailTrace other = (GuardrailTrace) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && hasInputAssessments() == other.hasInputAssessments()
                && Objects.equals(inputAssessments(), other.inputAssessments())
                && hasOutputAssessments() == other.hasOutputAssessments()
                && Objects.equals(outputAssessments(), other.outputAssessments()) && Objects.equals(traceId(), other.traceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailTrace").add("Action", actionAsString())
                .add("InputAssessments", inputAssessments() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OutputAssessments", outputAssessments() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TraceId", traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "inputAssessments":
            return Optional.ofNullable(clazz.cast(inputAssessments()));
        case "outputAssessments":
            return Optional.ofNullable(clazz.cast(outputAssessments()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTrace, T> g) {
        return obj -> g.apply((GuardrailTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailTrace> {
        /**
         * <p>
         * The trace action details used with the Guardrail.
         * </p>
         * 
         * @param action
         *        The trace action details used with the Guardrail.
         * @see GuardrailAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailAction
         */
        Builder action(String action);

        /**
         * <p>
         * The trace action details used with the Guardrail.
         * </p>
         * 
         * @param action
         *        The trace action details used with the Guardrail.
         * @see GuardrailAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailAction
         */
        Builder action(GuardrailAction action);

        /**
         * <p>
         * The details of the input assessments used in the Guardrail Trace.
         * </p>
         * 
         * @param inputAssessments
         *        The details of the input assessments used in the Guardrail Trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAssessments(Collection<GuardrailAssessment> inputAssessments);

        /**
         * <p>
         * The details of the input assessments used in the Guardrail Trace.
         * </p>
         * 
         * @param inputAssessments
         *        The details of the input assessments used in the Guardrail Trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAssessments(GuardrailAssessment... inputAssessments);

        /**
         * <p>
         * The details of the input assessments used in the Guardrail Trace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment.Builder#build()} is
         * called immediately and its result is passed to {@link #inputAssessments(List<GuardrailAssessment>)}.
         * 
         * @param inputAssessments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputAssessments(java.util.Collection<GuardrailAssessment>)
         */
        Builder inputAssessments(Consumer<GuardrailAssessment.Builder>... inputAssessments);

        /**
         * <p>
         * The details of the output assessments used in the Guardrail Trace.
         * </p>
         * 
         * @param outputAssessments
         *        The details of the output assessments used in the Guardrail Trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputAssessments(Collection<GuardrailAssessment> outputAssessments);

        /**
         * <p>
         * The details of the output assessments used in the Guardrail Trace.
         * </p>
         * 
         * @param outputAssessments
         *        The details of the output assessments used in the Guardrail Trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputAssessments(GuardrailAssessment... outputAssessments);

        /**
         * <p>
         * The details of the output assessments used in the Guardrail Trace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment.Builder#build()} is
         * called immediately and its result is passed to {@link #outputAssessments(List<GuardrailAssessment>)}.
         * 
         * @param outputAssessments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputAssessments(java.util.Collection<GuardrailAssessment>)
         */
        Builder outputAssessments(Consumer<GuardrailAssessment.Builder>... outputAssessments);

        /**
         * <p>
         * The details of the trace Id used in the Guardrail Trace.
         * </p>
         * 
         * @param traceId
         *        The details of the trace Id used in the Guardrail Trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private List<GuardrailAssessment> inputAssessments = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailAssessment> outputAssessments = DefaultSdkAutoConstructList.getInstance();

        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTrace model) {
            action(model.action);
            inputAssessments(model.inputAssessments);
            outputAssessments(model.outputAssessments);
            traceId(model.traceId);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<GuardrailAssessment.Builder> getInputAssessments() {
            List<GuardrailAssessment.Builder> result = GuardrailAssessmentListCopier.copyToBuilder(this.inputAssessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAssessments(Collection<GuardrailAssessment.BuilderImpl> inputAssessments) {
            this.inputAssessments = GuardrailAssessmentListCopier.copyFromBuilder(inputAssessments);
        }

        @Override
        public final Builder inputAssessments(Collection<GuardrailAssessment> inputAssessments) {
            this.inputAssessments = GuardrailAssessmentListCopier.copy(inputAssessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAssessments(GuardrailAssessment... inputAssessments) {
            inputAssessments(Arrays.asList(inputAssessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAssessments(Consumer<GuardrailAssessment.Builder>... inputAssessments) {
            inputAssessments(Stream.of(inputAssessments).map(c -> GuardrailAssessment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAssessment.Builder> getOutputAssessments() {
            List<GuardrailAssessment.Builder> result = GuardrailAssessmentListCopier.copyToBuilder(this.outputAssessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputAssessments(Collection<GuardrailAssessment.BuilderImpl> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListCopier.copyFromBuilder(outputAssessments);
        }

        @Override
        public final Builder outputAssessments(Collection<GuardrailAssessment> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListCopier.copy(outputAssessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputAssessments(GuardrailAssessment... outputAssessments) {
            outputAssessments(Arrays.asList(outputAssessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputAssessments(Consumer<GuardrailAssessment.Builder>... outputAssessments) {
            outputAssessments(Stream.of(outputAssessments).map(c -> GuardrailAssessment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public GuardrailTrace build() {
            return new GuardrailTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
