/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for inference settings when generating responses using RetrieveAndGenerate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceConfig implements SdkPojo, Serializable, ToCopyableBuilder<InferenceConfig.Builder, InferenceConfig> {
    private static final SdkField<TextInferenceConfig> TEXT_INFERENCE_CONFIG_FIELD = SdkField
            .<TextInferenceConfig> builder(MarshallingType.SDK_POJO).memberName("textInferenceConfig")
            .getter(getter(InferenceConfig::textInferenceConfig)).setter(setter(Builder::textInferenceConfig))
            .constructor(TextInferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInferenceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_INFERENCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("textInferenceConfig", TEXT_INFERENCE_CONFIG_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final TextInferenceConfig textInferenceConfig;

    private InferenceConfig(BuilderImpl builder) {
        this.textInferenceConfig = builder.textInferenceConfig;
    }

    /**
     * <p>
     * Configuration settings specific to text generation while generating responses using RetrieveAndGenerate.
     * </p>
     * 
     * @return Configuration settings specific to text generation while generating responses using RetrieveAndGenerate.
     */
    public final TextInferenceConfig textInferenceConfig() {
        return textInferenceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textInferenceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceConfig)) {
            return false;
        }
        InferenceConfig other = (InferenceConfig) obj;
        return Objects.equals(textInferenceConfig(), other.textInferenceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceConfig").add("TextInferenceConfig", textInferenceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textInferenceConfig":
            return Optional.ofNullable(clazz.cast(textInferenceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InferenceConfig, T> g) {
        return obj -> g.apply((InferenceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceConfig> {
        /**
         * <p>
         * Configuration settings specific to text generation while generating responses using RetrieveAndGenerate.
         * </p>
         * 
         * @param textInferenceConfig
         *        Configuration settings specific to text generation while generating responses using
         *        RetrieveAndGenerate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textInferenceConfig(TextInferenceConfig textInferenceConfig);

        /**
         * <p>
         * Configuration settings specific to text generation while generating responses using RetrieveAndGenerate.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextInferenceConfig.Builder} avoiding the
         * need to create one manually via {@link TextInferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextInferenceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #textInferenceConfig(TextInferenceConfig)}.
         * 
         * @param textInferenceConfig
         *        a consumer that will call methods on {@link TextInferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textInferenceConfig(TextInferenceConfig)
         */
        default Builder textInferenceConfig(Consumer<TextInferenceConfig.Builder> textInferenceConfig) {
            return textInferenceConfig(TextInferenceConfig.builder().applyMutation(textInferenceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextInferenceConfig textInferenceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceConfig model) {
            textInferenceConfig(model.textInferenceConfig);
        }

        public final TextInferenceConfig.Builder getTextInferenceConfig() {
            return textInferenceConfig != null ? textInferenceConfig.toBuilder() : null;
        }

        public final void setTextInferenceConfig(TextInferenceConfig.BuilderImpl textInferenceConfig) {
            this.textInferenceConfig = textInferenceConfig != null ? textInferenceConfig.build() : null;
        }

        @Override
        public final Builder textInferenceConfig(TextInferenceConfig textInferenceConfig) {
            this.textInferenceConfig = textInferenceConfig;
            return this;
        }

        @Override
        public InferenceConfig build() {
            return new InferenceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
