/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a part of an agent response and citations for it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InlineAgentPayloadPart implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineAgentPayloadPart.Builder, InlineAgentPayloadPart>, InlineAgentResponseStream {
    private static final SdkField<Attribution> ATTRIBUTION_FIELD = SdkField.<Attribution> builder(MarshallingType.SDK_POJO)
            .memberName("attribution").getter(getter(InlineAgentPayloadPart::attribution)).setter(setter(Builder::attribution))
            .constructor(Attribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribution").build()).build();

    private static final SdkField<SdkBytes> BYTES_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("bytes").getter(getter(InlineAgentPayloadPart::bytes)).setter(setter(Builder::bytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTRIBUTION_FIELD, BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("attribution", ATTRIBUTION_FIELD);
                    put("bytes", BYTES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Attribution attribution;

    private final SdkBytes bytes;

    protected InlineAgentPayloadPart(BuilderImpl builder) {
        this.attribution = builder.attribution;
        this.bytes = builder.bytes;
    }

    /**
     * <p>
     * Contains citations for a part of an agent response.
     * </p>
     * 
     * @return Contains citations for a part of an agent response.
     */
    public final Attribution attribution() {
        return attribution;
    }

    /**
     * <p>
     * A part of the agent response in bytes.
     * </p>
     * 
     * @return A part of the agent response in bytes.
     */
    public final SdkBytes bytes() {
        return bytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attribution());
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineAgentPayloadPart)) {
            return false;
        }
        InlineAgentPayloadPart other = (InlineAgentPayloadPart) obj;
        return Objects.equals(attribution(), other.attribution()) && Objects.equals(bytes(), other.bytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineAgentPayloadPart").add("Attribution", attribution())
                .add("Bytes", bytes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribution":
            return Optional.ofNullable(clazz.cast(attribution()));
        case "bytes":
            return Optional.ofNullable(clazz.cast(bytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final InlineAgentPayloadPart copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InlineAgentPayloadPart, T> g) {
        return obj -> g.apply((InlineAgentPayloadPart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link InlineAgentPayloadPart}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineAgentPayloadPart> {
        /**
         * <p>
         * Contains citations for a part of an agent response.
         * </p>
         * 
         * @param attribution
         *        Contains citations for a part of an agent response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribution(Attribution attribution);

        /**
         * <p>
         * Contains citations for a part of an agent response.
         * </p>
         * This is a convenience method that creates an instance of the {@link Attribution.Builder} avoiding the need to
         * create one manually via {@link Attribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attribution.Builder#build()} is called immediately and its result
         * is passed to {@link #attribution(Attribution)}.
         * 
         * @param attribution
         *        a consumer that will call methods on {@link Attribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribution(Attribution)
         */
        default Builder attribution(Consumer<Attribution.Builder> attribution) {
            return attribution(Attribution.builder().applyMutation(attribution).build());
        }

        /**
         * <p>
         * A part of the agent response in bytes.
         * </p>
         * 
         * @param bytes
         *        A part of the agent response in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(SdkBytes bytes);
    }

    protected static class BuilderImpl implements Builder {
        private Attribution attribution;

        private SdkBytes bytes;

        protected BuilderImpl() {
        }

        protected BuilderImpl(InlineAgentPayloadPart model) {
            attribution(model.attribution);
            bytes(model.bytes);
        }

        public final Attribution.Builder getAttribution() {
            return attribution != null ? attribution.toBuilder() : null;
        }

        public final void setAttribution(Attribution.BuilderImpl attribution) {
            this.attribution = attribution != null ? attribution.build() : null;
        }

        @Override
        public final Builder attribution(Attribution attribution) {
            this.attribution = attribution;
            return this;
        }

        public final ByteBuffer getBytes() {
            return bytes == null ? null : bytes.asByteBuffer();
        }

        public final void setBytes(ByteBuffer bytes) {
            bytes(bytes == null ? null : SdkBytes.fromByteBuffer(bytes));
        }

        @Override
        public final Builder bytes(SdkBytes bytes) {
            this.bytes = bytes;
            return this;
        }

        @Override
        public InlineAgentPayloadPart build() {
            return new InlineAgentPayloadPart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
