/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the agent and session, alongside the agent's reasoning process and results from calling
 * API actions and querying knowledge bases and metadata about the trace. You can use the trace to understand how the
 * agent arrived at the response it provided the customer. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace enablement</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InlineAgentTracePart implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineAgentTracePart.Builder, InlineAgentTracePart>, InlineAgentResponseStream {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(InlineAgentTracePart::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Trace> TRACE_FIELD = SdkField.<Trace> builder(MarshallingType.SDK_POJO).memberName("trace")
            .getter(getter(InlineAgentTracePart::trace)).setter(setter(Builder::trace)).constructor(Trace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SESSION_ID_FIELD, TRACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("sessionId", SESSION_ID_FIELD);
                    put("trace", TRACE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final Trace trace;

    protected InlineAgentTracePart(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.trace = builder.trace;
    }

    /**
     * <p>
     * The unique identifier of the session with the agent.
     * </p>
     * 
     * @return The unique identifier of the session with the agent.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Contains one part of the agent's reasoning process and results from calling API actions and querying knowledge
     * bases. You can use the trace to understand how the agent arrived at the response it provided the customer. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
     * enablement</a>.
     * </p>
     * 
     * @return Contains one part of the agent's reasoning process and results from calling API actions and querying
     *         knowledge bases. You can use the trace to understand how the agent arrived at the response it provided
     *         the customer. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
     *         enablement</a>.
     */
    public final Trace trace() {
        return trace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(trace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineAgentTracePart)) {
            return false;
        }
        InlineAgentTracePart other = (InlineAgentTracePart) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(trace(), other.trace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineAgentTracePart").add("SessionId", sessionId())
                .add("Trace", trace() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "trace":
            return Optional.ofNullable(clazz.cast(trace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final InlineAgentTracePart copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InlineAgentTracePart, T> g) {
        return obj -> g.apply((InlineAgentTracePart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link InlineAgentTracePart}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineAgentTracePart> {
        /**
         * <p>
         * The unique identifier of the session with the agent.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session with the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Contains one part of the agent's reasoning process and results from calling API actions and querying
         * knowledge bases. You can use the trace to understand how the agent arrived at the response it provided the
         * customer. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
         * enablement</a>.
         * </p>
         * 
         * @param trace
         *        Contains one part of the agent's reasoning process and results from calling API actions and querying
         *        knowledge bases. You can use the trace to understand how the agent arrived at the response it provided
         *        the customer. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
         *        enablement</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trace(Trace trace);

        /**
         * <p>
         * Contains one part of the agent's reasoning process and results from calling API actions and querying
         * knowledge bases. You can use the trace to understand how the agent arrived at the response it provided the
         * customer. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
         * enablement</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Trace.Builder} avoiding the need to
         * create one manually via {@link Trace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Trace.Builder#build()} is called immediately and its result is
         * passed to {@link #trace(Trace)}.
         * 
         * @param trace
         *        a consumer that will call methods on {@link Trace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trace(Trace)
         */
        default Builder trace(Consumer<Trace.Builder> trace) {
            return trace(Trace.builder().applyMutation(trace).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String sessionId;

        private Trace trace;

        protected BuilderImpl() {
        }

        protected BuilderImpl(InlineAgentTracePart model) {
            sessionId(model.sessionId);
            trace(model.trace);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Trace.Builder getTrace() {
            return trace != null ? trace.toBuilder() : null;
        }

        public final void setTrace(Trace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public InlineAgentTracePart build() {
            return new InlineAgentTracePart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
