/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A result from the invocation of an action. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the agent
 * developer</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control
 * session context</a>.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax"
 * >InvokeAgent request</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvocationResultMember implements SdkPojo, Serializable,
        ToCopyableBuilder<InvocationResultMember.Builder, InvocationResultMember> {
    private static final SdkField<ApiResult> API_RESULT_FIELD = SdkField.<ApiResult> builder(MarshallingType.SDK_POJO)
            .memberName("apiResult").getter(getter(InvocationResultMember::apiResult)).setter(setter(Builder::apiResult))
            .constructor(ApiResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiResult").build()).build();

    private static final SdkField<FunctionResult> FUNCTION_RESULT_FIELD = SdkField
            .<FunctionResult> builder(MarshallingType.SDK_POJO).memberName("functionResult")
            .getter(getter(InvocationResultMember::functionResult)).setter(setter(Builder::functionResult))
            .constructor(FunctionResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_RESULT_FIELD,
            FUNCTION_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("apiResult", API_RESULT_FIELD);
                    put("functionResult", FUNCTION_RESULT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ApiResult apiResult;

    private final FunctionResult functionResult;

    private final Type type;

    private InvocationResultMember(BuilderImpl builder) {
        this.apiResult = builder.apiResult;
        this.functionResult = builder.functionResult;
        this.type = builder.type;
    }

    /**
     * <p>
     * The result from the API response from the action group invocation.
     * </p>
     * 
     * @return The result from the API response from the action group invocation.
     */
    public final ApiResult apiResult() {
        return apiResult;
    }

    /**
     * <p>
     * The result from the function from the action group invocation.
     * </p>
     * 
     * @return The result from the function from the action group invocation.
     */
    public final FunctionResult functionResult() {
        return functionResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiResult());
        hashCode = 31 * hashCode + Objects.hashCode(functionResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationResultMember)) {
            return false;
        }
        InvocationResultMember other = (InvocationResultMember) obj;
        return Objects.equals(apiResult(), other.apiResult()) && Objects.equals(functionResult(), other.functionResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationResultMember").add("ApiResult", apiResult()).add("FunctionResult", functionResult())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiResult":
            return Optional.ofNullable(clazz.cast(apiResult()));
        case "functionResult":
            return Optional.ofNullable(clazz.cast(functionResult()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #apiResult()} initialized to the given value.
     *
     * <p>
     * The result from the API response from the action group invocation.
     * </p>
     * 
     * @param apiResult
     *        The result from the API response from the action group invocation.
     */
    public static InvocationResultMember fromApiResult(ApiResult apiResult) {
        return builder().apiResult(apiResult).build();
    }

    /**
     * Create an instance of this class with {@link #apiResult()} initialized to the given value.
     *
     * <p>
     * The result from the API response from the action group invocation.
     * </p>
     * 
     * @param apiResult
     *        The result from the API response from the action group invocation.
     */
    public static InvocationResultMember fromApiResult(Consumer<ApiResult.Builder> apiResult) {
        ApiResult.Builder builder = ApiResult.builder();
        apiResult.accept(builder);
        return fromApiResult(builder.build());
    }

    /**
     * Create an instance of this class with {@link #functionResult()} initialized to the given value.
     *
     * <p>
     * The result from the function from the action group invocation.
     * </p>
     * 
     * @param functionResult
     *        The result from the function from the action group invocation.
     */
    public static InvocationResultMember fromFunctionResult(FunctionResult functionResult) {
        return builder().functionResult(functionResult).build();
    }

    /**
     * Create an instance of this class with {@link #functionResult()} initialized to the given value.
     *
     * <p>
     * The result from the function from the action group invocation.
     * </p>
     * 
     * @param functionResult
     *        The result from the function from the action group invocation.
     */
    public static InvocationResultMember fromFunctionResult(Consumer<FunctionResult.Builder> functionResult) {
        FunctionResult.Builder builder = FunctionResult.builder();
        functionResult.accept(builder);
        return fromFunctionResult(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvocationResultMember, T> g) {
        return obj -> g.apply((InvocationResultMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationResultMember> {
        /**
         * <p>
         * The result from the API response from the action group invocation.
         * </p>
         * 
         * @param apiResult
         *        The result from the API response from the action group invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiResult(ApiResult apiResult);

        /**
         * <p>
         * The result from the API response from the action group invocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiResult.Builder} avoiding the need to
         * create one manually via {@link ApiResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiResult.Builder#build()} is called immediately and its result
         * is passed to {@link #apiResult(ApiResult)}.
         * 
         * @param apiResult
         *        a consumer that will call methods on {@link ApiResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiResult(ApiResult)
         */
        default Builder apiResult(Consumer<ApiResult.Builder> apiResult) {
            return apiResult(ApiResult.builder().applyMutation(apiResult).build());
        }

        /**
         * <p>
         * The result from the function from the action group invocation.
         * </p>
         * 
         * @param functionResult
         *        The result from the function from the action group invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResult(FunctionResult functionResult);

        /**
         * <p>
         * The result from the function from the action group invocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionResult.Builder} avoiding the need
         * to create one manually via {@link FunctionResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionResult.Builder#build()} is called immediately and its
         * result is passed to {@link #functionResult(FunctionResult)}.
         * 
         * @param functionResult
         *        a consumer that will call methods on {@link FunctionResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionResult(FunctionResult)
         */
        default Builder functionResult(Consumer<FunctionResult.Builder> functionResult) {
            return functionResult(FunctionResult.builder().applyMutation(functionResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApiResult apiResult;

        private FunctionResult functionResult;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationResultMember model) {
            apiResult(model.apiResult);
            functionResult(model.functionResult);
        }

        public final ApiResult.Builder getApiResult() {
            return apiResult != null ? apiResult.toBuilder() : null;
        }

        public final void setApiResult(ApiResult.BuilderImpl apiResult) {
            Object oldValue = this.apiResult;
            this.apiResult = apiResult != null ? apiResult.build() : null;
            handleUnionValueChange(Type.API_RESULT, oldValue, this.apiResult);
        }

        @Override
        public final Builder apiResult(ApiResult apiResult) {
            Object oldValue = this.apiResult;
            this.apiResult = apiResult;
            handleUnionValueChange(Type.API_RESULT, oldValue, this.apiResult);
            return this;
        }

        public final FunctionResult.Builder getFunctionResult() {
            return functionResult != null ? functionResult.toBuilder() : null;
        }

        public final void setFunctionResult(FunctionResult.BuilderImpl functionResult) {
            Object oldValue = this.functionResult;
            this.functionResult = functionResult != null ? functionResult.build() : null;
            handleUnionValueChange(Type.FUNCTION_RESULT, oldValue, this.functionResult);
        }

        @Override
        public final Builder functionResult(FunctionResult functionResult) {
            Object oldValue = this.functionResult;
            this.functionResult = functionResult;
            handleUnionValueChange(Type.FUNCTION_RESULT, oldValue, this.functionResult);
            return this;
        }

        @Override
        public InvocationResultMember build() {
            return new InvocationResultMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see InvocationResultMember#type()
     */
    public enum Type {
        API_RESULT,

        FUNCTION_RESULT,

        UNKNOWN_TO_SDK_VERSION
    }
}
