/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for knowledge base query. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax"
 * >Retrieve request</a> – in the <code>retrievalConfiguration</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax"
 * >RetrieveAndGenerate request</a> – in the <code>retrievalConfiguration</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseRetrievalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseRetrievalConfiguration.Builder, KnowledgeBaseRetrievalConfiguration> {
    private static final SdkField<KnowledgeBaseVectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField
            .<KnowledgeBaseVectorSearchConfiguration> builder(MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration")
            .getter(getter(KnowledgeBaseRetrievalConfiguration::vectorSearchConfiguration))
            .setter(setter(Builder::vectorSearchConfiguration)).constructor(KnowledgeBaseVectorSearchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VECTOR_SEARCH_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseVectorSearchConfiguration vectorSearchConfiguration;

    private KnowledgeBaseRetrievalConfiguration(BuilderImpl builder) {
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
    }

    /**
     * <p>
     * Contains details about how the results from the vector search should be returned. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
     * </p>
     * 
     * @return Contains details about how the results from the vector search should be returned. For more information,
     *         see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query
     *         configurations</a>.
     */
    public final KnowledgeBaseVectorSearchConfiguration vectorSearchConfiguration() {
        return vectorSearchConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vectorSearchConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseRetrievalConfiguration)) {
            return false;
        }
        KnowledgeBaseRetrievalConfiguration other = (KnowledgeBaseRetrievalConfiguration) obj;
        return Objects.equals(vectorSearchConfiguration(), other.vectorSearchConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseRetrievalConfiguration")
                .add("VectorSearchConfiguration", vectorSearchConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorSearchConfiguration":
            return Optional.ofNullable(clazz.cast(vectorSearchConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseRetrievalConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseRetrievalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseRetrievalConfiguration> {
        /**
         * <p>
         * Contains details about how the results from the vector search should be returned. For more information, see
         * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
         * </p>
         * 
         * @param vectorSearchConfiguration
         *        Contains details about how the results from the vector search should be returned. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query
         *        configurations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorSearchConfiguration(KnowledgeBaseVectorSearchConfiguration vectorSearchConfiguration);

        /**
         * <p>
         * Contains details about how the results from the vector search should be returned. For more information, see
         * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html">Query configurations</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseVectorSearchConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseVectorSearchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseVectorSearchConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #vectorSearchConfiguration(KnowledgeBaseVectorSearchConfiguration)}.
         * 
         * @param vectorSearchConfiguration
         *        a consumer that will call methods on {@link KnowledgeBaseVectorSearchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorSearchConfiguration(KnowledgeBaseVectorSearchConfiguration)
         */
        default Builder vectorSearchConfiguration(
                Consumer<KnowledgeBaseVectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return vectorSearchConfiguration(KnowledgeBaseVectorSearchConfiguration.builder()
                    .applyMutation(vectorSearchConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseVectorSearchConfiguration vectorSearchConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseRetrievalConfiguration model) {
            vectorSearchConfiguration(model.vectorSearchConfiguration);
        }

        public final KnowledgeBaseVectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return vectorSearchConfiguration != null ? vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(
                KnowledgeBaseVectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(KnowledgeBaseVectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        @Override
        public KnowledgeBaseRetrievalConfiguration build() {
            return new KnowledgeBaseRetrievalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
