/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the pre-processing step.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The <code>type</code> matches the agent step.
 * </p>
 * </li>
 * <li>
 * <p>
 * The <code>text</code> contains the prompt.
 * </p>
 * </li>
 * <li>
 * <p>
 * The <code>inferenceConfiguration</code>, <code>parserMode</code>, and <code>overrideLambda</code> values are set in
 * the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">
 * PromptOverrideConfiguration</a> object that was set when the agent was created or updated.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInvocationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInvocationInput.Builder, ModelInvocationInput> {
    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<InferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(ModelInvocationInput::inferenceConfiguration)).setter(setter(Builder::inferenceConfiguration))
            .constructor(InferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final SdkField<String> OVERRIDE_LAMBDA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overrideLambda").getter(getter(ModelInvocationInput::overrideLambda))
            .setter(setter(Builder::overrideLambda))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLambda").build()).build();

    private static final SdkField<String> PARSER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parserMode").getter(getter(ModelInvocationInput::parserModeAsString))
            .setter(setter(Builder::parserMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserMode").build()).build();

    private static final SdkField<String> PROMPT_CREATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptCreationMode").getter(getter(ModelInvocationInput::promptCreationModeAsString))
            .setter(setter(Builder::promptCreationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationMode").build())
            .build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ModelInvocationInput::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(ModelInvocationInput::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ModelInvocationInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_CONFIGURATION_FIELD,
            OVERRIDE_LAMBDA_FIELD, PARSER_MODE_FIELD, PROMPT_CREATION_MODE_FIELD, TEXT_FIELD, TRACE_ID_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
                    put("overrideLambda", OVERRIDE_LAMBDA_FIELD);
                    put("parserMode", PARSER_MODE_FIELD);
                    put("promptCreationMode", PROMPT_CREATION_MODE_FIELD);
                    put("text", TEXT_FIELD);
                    put("traceId", TRACE_ID_FIELD);
                    put("type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final InferenceConfiguration inferenceConfiguration;

    private final String overrideLambda;

    private final String parserMode;

    private final String promptCreationMode;

    private final String text;

    private final String traceId;

    private final String type;

    private ModelInvocationInput(BuilderImpl builder) {
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.overrideLambda = builder.overrideLambda;
        this.parserMode = builder.parserMode;
        this.promptCreationMode = builder.promptCreationMode;
        this.text = builder.text;
        this.traceId = builder.traceId;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifications about the inference parameters that were provided alongside the prompt. These are specified in the
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">
     * PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more information,
     * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for
     * foundation models</a>.
     * </p>
     * 
     * @return Specifications about the inference parameters that were provided alongside the prompt. These are
     *         specified in the <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     *         >PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters
     *         for foundation models</a>.
     */
    public final InferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    /**
     * <p>
     * The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent
     * sequence.
     * </p>
     * 
     * @return The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent
     *         sequence.
     */
    public final String overrideLambda() {
        return overrideLambda;
    }

    /**
     * <p>
     * Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in
     * the part of the agent sequence defined by the <code>promptType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parserMode} will
     * return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parserModeAsString}.
     * </p>
     * 
     * @return Specifies whether to override the default parser Lambda function when parsing the raw foundation model
     *         output in the part of the agent sequence defined by the <code>promptType</code>.
     * @see CreationMode
     */
    public final CreationMode parserMode() {
        return CreationMode.fromValue(parserMode);
    }

    /**
     * <p>
     * Specifies whether to override the default parser Lambda function when parsing the raw foundation model output in
     * the part of the agent sequence defined by the <code>promptType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parserMode} will
     * return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parserModeAsString}.
     * </p>
     * 
     * @return Specifies whether to override the default parser Lambda function when parsing the raw foundation model
     *         output in the part of the agent sequence defined by the <code>promptType</code>.
     * @see CreationMode
     */
    public final String parserModeAsString() {
        return parserMode;
    }

    /**
     * <p>
     * Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
     * <code>basePromptTemplate</code> that was set in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     * >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #promptCreationMode} will return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #promptCreationModeAsString}.
     * </p>
     * 
     * @return Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
     *         <code>basePromptTemplate</code> that was set in the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     *         >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
     * @see CreationMode
     */
    public final CreationMode promptCreationMode() {
        return CreationMode.fromValue(promptCreationMode);
    }

    /**
     * <p>
     * Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
     * <code>basePromptTemplate</code> that was set in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     * >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #promptCreationMode} will return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #promptCreationModeAsString}.
     * </p>
     * 
     * @return Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
     *         <code>basePromptTemplate</code> that was set in the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
     *         >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
     * @see CreationMode
     */
    public final String promptCreationModeAsString() {
        return promptCreationMode;
    }

    /**
     * <p>
     * The text that prompted the agent at this step.
     * </p>
     * 
     * @return The text that prompted the agent at this step.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The unique identifier of the trace.
     * </p>
     * 
     * @return The unique identifier of the trace.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * <p>
     * The step in the agent sequence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The step in the agent sequence.
     * @see PromptType
     */
    public final PromptType type() {
        return PromptType.fromValue(type);
    }

    /**
     * <p>
     * The step in the agent sequence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The step in the agent sequence.
     * @see PromptType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(overrideLambda());
        hashCode = 31 * hashCode + Objects.hashCode(parserModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promptCreationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationInput)) {
            return false;
        }
        ModelInvocationInput other = (ModelInvocationInput) obj;
        return Objects.equals(inferenceConfiguration(), other.inferenceConfiguration())
                && Objects.equals(overrideLambda(), other.overrideLambda())
                && Objects.equals(parserModeAsString(), other.parserModeAsString())
                && Objects.equals(promptCreationModeAsString(), other.promptCreationModeAsString())
                && Objects.equals(text(), other.text()) && Objects.equals(traceId(), other.traceId())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInvocationInput").add("InferenceConfiguration", inferenceConfiguration())
                .add("OverrideLambda", overrideLambda()).add("ParserMode", parserModeAsString())
                .add("PromptCreationMode", promptCreationModeAsString())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").add("TraceId", traceId())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        case "overrideLambda":
            return Optional.ofNullable(clazz.cast(overrideLambda()));
        case "parserMode":
            return Optional.ofNullable(clazz.cast(parserModeAsString()));
        case "promptCreationMode":
            return Optional.ofNullable(clazz.cast(promptCreationModeAsString()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationInput, T> g) {
        return obj -> g.apply((ModelInvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInvocationInput> {
        /**
         * <p>
         * Specifications about the inference parameters that were provided alongside the prompt. These are specified in
         * the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for
         * foundation models</a>.
         * </p>
         * 
         * @param inferenceConfiguration
         *        Specifications about the inference parameters that were provided alongside the prompt. These are
         *        specified in the <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         *        >PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters
         *        for foundation models</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration);

        /**
         * <p>
         * Specifications about the inference parameters that were provided alongside the prompt. These are specified in
         * the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         * >PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for
         * foundation models</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceConfiguration(InferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link InferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(InferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<InferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(InferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the agent
         * sequence.
         * </p>
         * 
         * @param overrideLambda
         *        The ARN of the Lambda function to use when parsing the raw foundation model output in parts of the
         *        agent sequence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideLambda(String overrideLambda);

        /**
         * <p>
         * Specifies whether to override the default parser Lambda function when parsing the raw foundation model output
         * in the part of the agent sequence defined by the <code>promptType</code>.
         * </p>
         * 
         * @param parserMode
         *        Specifies whether to override the default parser Lambda function when parsing the raw foundation model
         *        output in the part of the agent sequence defined by the <code>promptType</code>.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder parserMode(String parserMode);

        /**
         * <p>
         * Specifies whether to override the default parser Lambda function when parsing the raw foundation model output
         * in the part of the agent sequence defined by the <code>promptType</code>.
         * </p>
         * 
         * @param parserMode
         *        Specifies whether to override the default parser Lambda function when parsing the raw foundation model
         *        output in the part of the agent sequence defined by the <code>promptType</code>.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder parserMode(CreationMode parserMode);

        /**
         * <p>
         * Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
         * <code>basePromptTemplate</code> that was set in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         * >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
         * </p>
         * 
         * @param promptCreationMode
         *        Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
         *        <code>basePromptTemplate</code> that was set in the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         *        >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder promptCreationMode(String promptCreationMode);

        /**
         * <p>
         * Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
         * <code>basePromptTemplate</code> that was set in the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         * >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
         * </p>
         * 
         * @param promptCreationMode
         *        Specifies whether the default prompt template was <code>OVERRIDDEN</code>. If it was, the
         *        <code>basePromptTemplate</code> that was set in the <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html"
         *        >PromptOverrideConfiguration</a> object when the agent was created or updated is used instead.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder promptCreationMode(CreationMode promptCreationMode);

        /**
         * <p>
         * The text that prompted the agent at this step.
         * </p>
         * 
         * @param text
         *        The text that prompted the agent at this step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The unique identifier of the trace.
         * </p>
         * 
         * @param traceId
         *        The unique identifier of the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * <p>
         * The step in the agent sequence.
         * </p>
         * 
         * @param type
         *        The step in the agent sequence.
         * @see PromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptType
         */
        Builder type(String type);

        /**
         * <p>
         * The step in the agent sequence.
         * </p>
         * 
         * @param type
         *        The step in the agent sequence.
         * @see PromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptType
         */
        Builder type(PromptType type);
    }

    static final class BuilderImpl implements Builder {
        private InferenceConfiguration inferenceConfiguration;

        private String overrideLambda;

        private String parserMode;

        private String promptCreationMode;

        private String text;

        private String traceId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationInput model) {
            inferenceConfiguration(model.inferenceConfiguration);
            overrideLambda(model.overrideLambda);
            parserMode(model.parserMode);
            promptCreationMode(model.promptCreationMode);
            text(model.text);
            traceId(model.traceId);
            type(model.type);
        }

        public final InferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(InferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getOverrideLambda() {
            return overrideLambda;
        }

        public final void setOverrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
        }

        @Override
        public final Builder overrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
            return this;
        }

        public final String getParserMode() {
            return parserMode;
        }

        public final void setParserMode(String parserMode) {
            this.parserMode = parserMode;
        }

        @Override
        public final Builder parserMode(String parserMode) {
            this.parserMode = parserMode;
            return this;
        }

        @Override
        public final Builder parserMode(CreationMode parserMode) {
            this.parserMode(parserMode == null ? null : parserMode.toString());
            return this;
        }

        public final String getPromptCreationMode() {
            return promptCreationMode;
        }

        public final void setPromptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
        }

        @Override
        public final Builder promptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
            return this;
        }

        @Override
        public final Builder promptCreationMode(CreationMode promptCreationMode) {
            this.promptCreationMode(promptCreationMode == null ? null : promptCreationMode.toString());
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ModelInvocationInput build() {
            return new ModelInvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
