/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event in which the prompt was optimized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OptimizedPromptEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<OptimizedPromptEvent.Builder, OptimizedPromptEvent>, OptimizedPromptStream {
    private static final SdkField<OptimizedPrompt> OPTIMIZED_PROMPT_FIELD = SdkField
            .<OptimizedPrompt> builder(MarshallingType.SDK_POJO).memberName("optimizedPrompt")
            .getter(getter(OptimizedPromptEvent::optimizedPrompt)).setter(setter(Builder::optimizedPrompt))
            .constructor(OptimizedPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optimizedPrompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIMIZED_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("optimizedPrompt", OPTIMIZED_PROMPT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final OptimizedPrompt optimizedPrompt;

    protected OptimizedPromptEvent(BuilderImpl builder) {
        this.optimizedPrompt = builder.optimizedPrompt;
    }

    /**
     * <p>
     * Contains information about the optimized prompt.
     * </p>
     * 
     * @return Contains information about the optimized prompt.
     */
    public final OptimizedPrompt optimizedPrompt() {
        return optimizedPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optimizedPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizedPromptEvent)) {
            return false;
        }
        OptimizedPromptEvent other = (OptimizedPromptEvent) obj;
        return Objects.equals(optimizedPrompt(), other.optimizedPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizedPromptEvent").add("OptimizedPrompt", optimizedPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "optimizedPrompt":
            return Optional.ofNullable(clazz.cast(optimizedPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final OptimizedPromptEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OptimizedPromptEvent, T> g) {
        return obj -> g.apply((OptimizedPromptEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link OptimizedPromptEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(OptimizePromptResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptimizedPromptEvent> {
        /**
         * <p>
         * Contains information about the optimized prompt.
         * </p>
         * 
         * @param optimizedPrompt
         *        Contains information about the optimized prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizedPrompt(OptimizedPrompt optimizedPrompt);

        /**
         * <p>
         * Contains information about the optimized prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link OptimizedPrompt.Builder} avoiding the
         * need to create one manually via {@link OptimizedPrompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OptimizedPrompt.Builder#build()} is called immediately and its
         * result is passed to {@link #optimizedPrompt(OptimizedPrompt)}.
         * 
         * @param optimizedPrompt
         *        a consumer that will call methods on {@link OptimizedPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optimizedPrompt(OptimizedPrompt)
         */
        default Builder optimizedPrompt(Consumer<OptimizedPrompt.Builder> optimizedPrompt) {
            return optimizedPrompt(OptimizedPrompt.builder().applyMutation(optimizedPrompt).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private OptimizedPrompt optimizedPrompt;

        protected BuilderImpl() {
        }

        protected BuilderImpl(OptimizedPromptEvent model) {
            optimizedPrompt(model.optimizedPrompt);
        }

        public final OptimizedPrompt.Builder getOptimizedPrompt() {
            return optimizedPrompt != null ? optimizedPrompt.toBuilder() : null;
        }

        public final void setOptimizedPrompt(OptimizedPrompt.BuilderImpl optimizedPrompt) {
            this.optimizedPrompt = optimizedPrompt != null ? optimizedPrompt.build() : null;
        }

        @Override
        public final Builder optimizedPrompt(OptimizedPrompt optimizedPrompt) {
            this.optimizedPrompt = optimizedPrompt;
            return this;
        }

        @Override
        public OptimizedPromptEvent build() {
            return new OptimizedPromptEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
