/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the data source location.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_ResponseSyntax"
 * >Retrieve response</a> – in the <code>location</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax"
 * >RetrieveAndGenerate response</a> – in the <code>location</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a> – in the <code>locatino</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalResultLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalResultLocation.Builder, RetrievalResultLocation> {
    private static final SdkField<RetrievalResultConfluenceLocation> CONFLUENCE_LOCATION_FIELD = SdkField
            .<RetrievalResultConfluenceLocation> builder(MarshallingType.SDK_POJO).memberName("confluenceLocation")
            .getter(getter(RetrievalResultLocation::confluenceLocation)).setter(setter(Builder::confluenceLocation))
            .constructor(RetrievalResultConfluenceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confluenceLocation").build())
            .build();

    private static final SdkField<RetrievalResultS3Location> S3_LOCATION_FIELD = SdkField
            .<RetrievalResultS3Location> builder(MarshallingType.SDK_POJO).memberName("s3Location")
            .getter(getter(RetrievalResultLocation::s3Location)).setter(setter(Builder::s3Location))
            .constructor(RetrievalResultS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<RetrievalResultSalesforceLocation> SALESFORCE_LOCATION_FIELD = SdkField
            .<RetrievalResultSalesforceLocation> builder(MarshallingType.SDK_POJO).memberName("salesforceLocation")
            .getter(getter(RetrievalResultLocation::salesforceLocation)).setter(setter(Builder::salesforceLocation))
            .constructor(RetrievalResultSalesforceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforceLocation").build())
            .build();

    private static final SdkField<RetrievalResultSharePointLocation> SHARE_POINT_LOCATION_FIELD = SdkField
            .<RetrievalResultSharePointLocation> builder(MarshallingType.SDK_POJO).memberName("sharePointLocation")
            .getter(getter(RetrievalResultLocation::sharePointLocation)).setter(setter(Builder::sharePointLocation))
            .constructor(RetrievalResultSharePointLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharePointLocation").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RetrievalResultLocation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<RetrievalResultWebLocation> WEB_LOCATION_FIELD = SdkField
            .<RetrievalResultWebLocation> builder(MarshallingType.SDK_POJO).memberName("webLocation")
            .getter(getter(RetrievalResultLocation::webLocation)).setter(setter(Builder::webLocation))
            .constructor(RetrievalResultWebLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLUENCE_LOCATION_FIELD,
            S3_LOCATION_FIELD, SALESFORCE_LOCATION_FIELD, SHARE_POINT_LOCATION_FIELD, TYPE_FIELD, WEB_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("confluenceLocation", CONFLUENCE_LOCATION_FIELD);
                    put("s3Location", S3_LOCATION_FIELD);
                    put("salesforceLocation", SALESFORCE_LOCATION_FIELD);
                    put("sharePointLocation", SHARE_POINT_LOCATION_FIELD);
                    put("type", TYPE_FIELD);
                    put("webLocation", WEB_LOCATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final RetrievalResultConfluenceLocation confluenceLocation;

    private final RetrievalResultS3Location s3Location;

    private final RetrievalResultSalesforceLocation salesforceLocation;

    private final RetrievalResultSharePointLocation sharePointLocation;

    private final String type;

    private final RetrievalResultWebLocation webLocation;

    private RetrievalResultLocation(BuilderImpl builder) {
        this.confluenceLocation = builder.confluenceLocation;
        this.s3Location = builder.s3Location;
        this.salesforceLocation = builder.salesforceLocation;
        this.sharePointLocation = builder.sharePointLocation;
        this.type = builder.type;
        this.webLocation = builder.webLocation;
    }

    /**
     * <p>
     * The Confluence data source location.
     * </p>
     * 
     * @return The Confluence data source location.
     */
    public final RetrievalResultConfluenceLocation confluenceLocation() {
        return confluenceLocation;
    }

    /**
     * <p>
     * The S3 data source location.
     * </p>
     * 
     * @return The S3 data source location.
     */
    public final RetrievalResultS3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The Salesforce data source location.
     * </p>
     * 
     * @return The Salesforce data source location.
     */
    public final RetrievalResultSalesforceLocation salesforceLocation() {
        return salesforceLocation;
    }

    /**
     * <p>
     * The SharePoint data source location.
     * </p>
     * 
     * @return The SharePoint data source location.
     */
    public final RetrievalResultSharePointLocation sharePointLocation() {
        return sharePointLocation;
    }

    /**
     * <p>
     * The type of data source location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source location.
     * @see RetrievalResultLocationType
     */
    public final RetrievalResultLocationType type() {
        return RetrievalResultLocationType.fromValue(type);
    }

    /**
     * <p>
     * The type of data source location.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultLocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source location.
     * @see RetrievalResultLocationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The web URL/URLs data source location.
     * </p>
     * 
     * @return The web URL/URLs data source location.
     */
    public final RetrievalResultWebLocation webLocation() {
        return webLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confluenceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(sharePointLocation());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultLocation)) {
            return false;
        }
        RetrievalResultLocation other = (RetrievalResultLocation) obj;
        return Objects.equals(confluenceLocation(), other.confluenceLocation())
                && Objects.equals(s3Location(), other.s3Location())
                && Objects.equals(salesforceLocation(), other.salesforceLocation())
                && Objects.equals(sharePointLocation(), other.sharePointLocation())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(webLocation(), other.webLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalResultLocation").add("ConfluenceLocation", confluenceLocation())
                .add("S3Location", s3Location()).add("SalesforceLocation", salesforceLocation())
                .add("SharePointLocation", sharePointLocation()).add("Type", typeAsString()).add("WebLocation", webLocation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "confluenceLocation":
            return Optional.ofNullable(clazz.cast(confluenceLocation()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "salesforceLocation":
            return Optional.ofNullable(clazz.cast(salesforceLocation()));
        case "sharePointLocation":
            return Optional.ofNullable(clazz.cast(sharePointLocation()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "webLocation":
            return Optional.ofNullable(clazz.cast(webLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultLocation, T> g) {
        return obj -> g.apply((RetrievalResultLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalResultLocation> {
        /**
         * <p>
         * The Confluence data source location.
         * </p>
         * 
         * @param confluenceLocation
         *        The Confluence data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confluenceLocation(RetrievalResultConfluenceLocation confluenceLocation);

        /**
         * <p>
         * The Confluence data source location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultConfluenceLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultConfluenceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultConfluenceLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #confluenceLocation(RetrievalResultConfluenceLocation)}.
         * 
         * @param confluenceLocation
         *        a consumer that will call methods on {@link RetrievalResultConfluenceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confluenceLocation(RetrievalResultConfluenceLocation)
         */
        default Builder confluenceLocation(Consumer<RetrievalResultConfluenceLocation.Builder> confluenceLocation) {
            return confluenceLocation(RetrievalResultConfluenceLocation.builder().applyMutation(confluenceLocation).build());
        }

        /**
         * <p>
         * The S3 data source location.
         * </p>
         * 
         * @param s3Location
         *        The S3 data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(RetrievalResultS3Location s3Location);

        /**
         * <p>
         * The S3 data source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultS3Location.Builder}
         * avoiding the need to create one manually via {@link RetrievalResultS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultS3Location.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Location(RetrievalResultS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link RetrievalResultS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(RetrievalResultS3Location)
         */
        default Builder s3Location(Consumer<RetrievalResultS3Location.Builder> s3Location) {
            return s3Location(RetrievalResultS3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The Salesforce data source location.
         * </p>
         * 
         * @param salesforceLocation
         *        The Salesforce data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforceLocation(RetrievalResultSalesforceLocation salesforceLocation);

        /**
         * <p>
         * The Salesforce data source location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultSalesforceLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultSalesforceLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultSalesforceLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #salesforceLocation(RetrievalResultSalesforceLocation)}.
         * 
         * @param salesforceLocation
         *        a consumer that will call methods on {@link RetrievalResultSalesforceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforceLocation(RetrievalResultSalesforceLocation)
         */
        default Builder salesforceLocation(Consumer<RetrievalResultSalesforceLocation.Builder> salesforceLocation) {
            return salesforceLocation(RetrievalResultSalesforceLocation.builder().applyMutation(salesforceLocation).build());
        }

        /**
         * <p>
         * The SharePoint data source location.
         * </p>
         * 
         * @param sharePointLocation
         *        The SharePoint data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePointLocation(RetrievalResultSharePointLocation sharePointLocation);

        /**
         * <p>
         * The SharePoint data source location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalResultSharePointLocation.Builder} avoiding the need to create one manually via
         * {@link RetrievalResultSharePointLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultSharePointLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #sharePointLocation(RetrievalResultSharePointLocation)}.
         * 
         * @param sharePointLocation
         *        a consumer that will call methods on {@link RetrievalResultSharePointLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharePointLocation(RetrievalResultSharePointLocation)
         */
        default Builder sharePointLocation(Consumer<RetrievalResultSharePointLocation.Builder> sharePointLocation) {
            return sharePointLocation(RetrievalResultSharePointLocation.builder().applyMutation(sharePointLocation).build());
        }

        /**
         * <p>
         * The type of data source location.
         * </p>
         * 
         * @param type
         *        The type of data source location.
         * @see RetrievalResultLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultLocationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of data source location.
         * </p>
         * 
         * @param type
         *        The type of data source location.
         * @see RetrievalResultLocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultLocationType
         */
        Builder type(RetrievalResultLocationType type);

        /**
         * <p>
         * The web URL/URLs data source location.
         * </p>
         * 
         * @param webLocation
         *        The web URL/URLs data source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webLocation(RetrievalResultWebLocation webLocation);

        /**
         * <p>
         * The web URL/URLs data source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultWebLocation.Builder}
         * avoiding the need to create one manually via {@link RetrievalResultWebLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultWebLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #webLocation(RetrievalResultWebLocation)}.
         * 
         * @param webLocation
         *        a consumer that will call methods on {@link RetrievalResultWebLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webLocation(RetrievalResultWebLocation)
         */
        default Builder webLocation(Consumer<RetrievalResultWebLocation.Builder> webLocation) {
            return webLocation(RetrievalResultWebLocation.builder().applyMutation(webLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RetrievalResultConfluenceLocation confluenceLocation;

        private RetrievalResultS3Location s3Location;

        private RetrievalResultSalesforceLocation salesforceLocation;

        private RetrievalResultSharePointLocation sharePointLocation;

        private String type;

        private RetrievalResultWebLocation webLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultLocation model) {
            confluenceLocation(model.confluenceLocation);
            s3Location(model.s3Location);
            salesforceLocation(model.salesforceLocation);
            sharePointLocation(model.sharePointLocation);
            type(model.type);
            webLocation(model.webLocation);
        }

        public final RetrievalResultConfluenceLocation.Builder getConfluenceLocation() {
            return confluenceLocation != null ? confluenceLocation.toBuilder() : null;
        }

        public final void setConfluenceLocation(RetrievalResultConfluenceLocation.BuilderImpl confluenceLocation) {
            this.confluenceLocation = confluenceLocation != null ? confluenceLocation.build() : null;
        }

        @Override
        public final Builder confluenceLocation(RetrievalResultConfluenceLocation confluenceLocation) {
            this.confluenceLocation = confluenceLocation;
            return this;
        }

        public final RetrievalResultS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(RetrievalResultS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(RetrievalResultS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final RetrievalResultSalesforceLocation.Builder getSalesforceLocation() {
            return salesforceLocation != null ? salesforceLocation.toBuilder() : null;
        }

        public final void setSalesforceLocation(RetrievalResultSalesforceLocation.BuilderImpl salesforceLocation) {
            this.salesforceLocation = salesforceLocation != null ? salesforceLocation.build() : null;
        }

        @Override
        public final Builder salesforceLocation(RetrievalResultSalesforceLocation salesforceLocation) {
            this.salesforceLocation = salesforceLocation;
            return this;
        }

        public final RetrievalResultSharePointLocation.Builder getSharePointLocation() {
            return sharePointLocation != null ? sharePointLocation.toBuilder() : null;
        }

        public final void setSharePointLocation(RetrievalResultSharePointLocation.BuilderImpl sharePointLocation) {
            this.sharePointLocation = sharePointLocation != null ? sharePointLocation.build() : null;
        }

        @Override
        public final Builder sharePointLocation(RetrievalResultSharePointLocation sharePointLocation) {
            this.sharePointLocation = sharePointLocation;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultLocationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RetrievalResultWebLocation.Builder getWebLocation() {
            return webLocation != null ? webLocation.toBuilder() : null;
        }

        public final void setWebLocation(RetrievalResultWebLocation.BuilderImpl webLocation) {
            this.webLocation = webLocation != null ? webLocation.build() : null;
        }

        @Override
        public final Builder webLocation(RetrievalResultWebLocation webLocation) {
            this.webLocation = webLocation;
            return this;
        }

        @Override
        public RetrievalResultLocation build() {
            return new RetrievalResultLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
