/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about why a flow completed.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeFlow.html#API_agent_InvokeFlow_ResponseSyntax"
 * >InvokeFlow response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class FlowCompletionEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowCompletionEvent.Builder, FlowCompletionEvent>, FlowResponseStream {
    private static final SdkField<String> COMPLETION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completionReason").getter(getter(FlowCompletionEvent::completionReasonAsString))
            .setter(setter(Builder::completionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String completionReason;

    protected FlowCompletionEvent(BuilderImpl builder) {
        this.completionReason = builder.completionReason;
    }

    /**
     * <p>
     * The reason that the flow completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completionReason}
     * will return {@link FlowCompletionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #completionReasonAsString}.
     * </p>
     * 
     * @return The reason that the flow completed.
     * @see FlowCompletionReason
     */
    public final FlowCompletionReason completionReason() {
        return FlowCompletionReason.fromValue(completionReason);
    }

    /**
     * <p>
     * The reason that the flow completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completionReason}
     * will return {@link FlowCompletionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #completionReasonAsString}.
     * </p>
     * 
     * @return The reason that the flow completed.
     * @see FlowCompletionReason
     */
    public final String completionReasonAsString() {
        return completionReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowCompletionEvent)) {
            return false;
        }
        FlowCompletionEvent other = (FlowCompletionEvent) obj;
        return Objects.equals(completionReasonAsString(), other.completionReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowCompletionEvent").add("CompletionReason", completionReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completionReason":
            return Optional.ofNullable(clazz.cast(completionReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final FlowCompletionEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowCompletionEvent, T> g) {
        return obj -> g.apply((FlowCompletionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link FlowCompletionEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeFlowResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowCompletionEvent> {
        /**
         * <p>
         * The reason that the flow completed.
         * </p>
         * 
         * @param completionReason
         *        The reason that the flow completed.
         * @see FlowCompletionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowCompletionReason
         */
        Builder completionReason(String completionReason);

        /**
         * <p>
         * The reason that the flow completed.
         * </p>
         * 
         * @param completionReason
         *        The reason that the flow completed.
         * @see FlowCompletionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowCompletionReason
         */
        Builder completionReason(FlowCompletionReason completionReason);
    }

    protected static class BuilderImpl implements Builder {
        private String completionReason;

        protected BuilderImpl() {
        }

        protected BuilderImpl(FlowCompletionEvent model) {
            completionReason(model.completionReason);
        }

        public final String getCompletionReason() {
            return completionReason;
        }

        public final void setCompletionReason(String completionReason) {
            this.completionReason = completionReason;
        }

        @Override
        public final Builder completionReason(String completionReason) {
            this.completionReason = completionReason;
            return this;
        }

        @Override
        public final Builder completionReason(FlowCompletionReason completionReason) {
            this.completionReason(completionReason == null ? null : completionReason.toString());
            return this;
        }

        @Override
        public FlowCompletionEvent build() {
            return new FlowCompletionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
