/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher;

/**
 * Service client for accessing Agents for Amazon Bedrock Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Contains APIs related to model invocation and querying of knowledge bases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agent-runtime";

    /**
     * <p>
     * Deletes memory from the specified memory identifier.
     * </p>
     *
     * @param deleteAgentMemoryRequest
     * @return A Java Future containing the result of the DeleteAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.DeleteAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentMemoryResponse> deleteAgentMemory(DeleteAgentMemoryRequest deleteAgentMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes memory from the specified memory identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentMemoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAgentMemoryRequest#builder()}
     * </p>
     *
     * @param deleteAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.DeleteAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentMemoryResponse> deleteAgentMemory(
            Consumer<DeleteAgentMemoryRequest.Builder> deleteAgentMemoryRequest) {
        return deleteAgentMemory(DeleteAgentMemoryRequest.builder().applyMutation(deleteAgentMemoryRequest).build());
    }

    /**
     * <p>
     * Generates an SQL query from a natural language query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html">Generate a query
     * for structured data</a> in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param generateQueryRequest
     * @return A Java Future containing the result of the GenerateQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GenerateQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateQueryResponse> generateQuery(GenerateQueryRequest generateQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an SQL query from a natural language query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html">Generate a query
     * for structured data</a> in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GenerateQueryRequest#builder()}
     * </p>
     *
     * @param generateQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GenerateQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GenerateQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateQueryResponse> generateQuery(Consumer<GenerateQueryRequest.Builder> generateQueryRequest) {
        return generateQuery(GenerateQueryRequest.builder().applyMutation(generateQueryRequest).build());
    }

    /**
     * <p>
     * Gets the sessions stored in the memory of the agent.
     * </p>
     *
     * @param getAgentMemoryRequest
     * @return A Java Future containing the result of the GetAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentMemoryResponse> getAgentMemory(GetAgentMemoryRequest getAgentMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the sessions stored in the memory of the agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentMemoryRequest#builder()}
     * </p>
     *
     * @param getAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentMemoryResponse> getAgentMemory(Consumer<GetAgentMemoryRequest.Builder> getAgentMemoryRequest) {
        return getAgentMemory(GetAgentMemoryRequest.builder().applyMutation(getAgentMemoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAgentMemoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryPublisher getAgentMemoryPaginator(GetAgentMemoryRequest getAgentMemoryRequest) {
        return new GetAgentMemoryPublisher(this, getAgentMemoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentMemoryRequest#builder()}
     * </p>
     *
     * @param getAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryPublisher getAgentMemoryPaginator(Consumer<GetAgentMemoryRequest.Builder> getAgentMemoryRequest) {
        return getAgentMemoryPaginator(GetAgentMemoryRequest.builder().applyMutation(getAgentMemoryRequest).build());
    }

    /**
     * <note> </note>
     * <p>
     * Sends a prompt for the agent to process and respond to. Note the following fields for the request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you
     * follow the agent's reasoning process that led it to the information it processed, the actions it took, and the
     * final result it yielded. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To stream agent responses, make sure that only orchestration prompt is enabled. Agent streaming is not supported
     * for the following steps:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Pre-processing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Post-processing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Agent with 1 Knowledge base and <code>User Input</code> not enabled
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * End a conversation by setting <code>endSession</code> to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the <code>sessionState</code> object, you can include attributes for the session or prompt or, if you
     * configured an action group to return control, results from invocation of the action group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The response contains both <b>chunk</b> and <b>trace</b> attributes.
     * </p>
     * <p>
     * The final response is returned in the <code>bytes</code> field of the <code>chunk</code> object. The
     * <code>InvokeAgent</code> returns one chunk for the entire interaction.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>attribution</code> object contains citations for parts of the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent's steps and
     * reasoning process that led it to the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the action predicted was configured to return control, the response returns parameters for the action,
     * elicited from the user, in the <code>returnControl</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors are also surfaced in the response.
     * </p>
     * </li>
     * </ul>
     *
     * @param invokeAgentRequest
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(InvokeAgentRequest invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note> </note>
     * <p>
     * Sends a prompt for the agent to process and respond to. Note the following fields for the request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you
     * follow the agent's reasoning process that led it to the information it processed, the actions it took, and the
     * final result it yielded. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To stream agent responses, make sure that only orchestration prompt is enabled. Agent streaming is not supported
     * for the following steps:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Pre-processing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Post-processing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Agent with 1 Knowledge base and <code>User Input</code> not enabled
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * End a conversation by setting <code>endSession</code> to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the <code>sessionState</code> object, you can include attributes for the session or prompt or, if you
     * configured an action group to return control, results from invocation of the action group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The response contains both <b>chunk</b> and <b>trace</b> attributes.
     * </p>
     * <p>
     * The final response is returned in the <code>bytes</code> field of the <code>chunk</code> object. The
     * <code>InvokeAgent</code> returns one chunk for the entire interaction.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>attribution</code> object contains citations for parts of the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent's steps and
     * reasoning process that led it to the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the action predicted was configured to return control, the response returns parameters for the action,
     * elicited from the user, in the <code>returnControl</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors are also surfaced in the response.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeAgentRequest#builder()}
     * </p>
     *
     * @param invokeAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(Consumer<InvokeAgentRequest.Builder> invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        return invokeAgent(InvokeAgentRequest.builder().applyMutation(invokeAgentRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If
     * there's an error, the error is returned. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html">Test a flow in Amazon Bedrock</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including <code>InvokeFlow</code>.
     * </p>
     * </note>
     *
     * @param invokeFlowRequest
     * @return A Java Future containing the result of the InvokeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeFlow(InvokeFlowRequest invokeFlowRequest, InvokeFlowResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If
     * there's an error, the error is returned. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html">Test a flow in Amazon Bedrock</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including <code>InvokeFlow</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeFlowRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeFlowRequest#builder()}
     * </p>
     *
     * @param invokeFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeFlow(Consumer<InvokeFlowRequest.Builder> invokeFlowRequest,
            InvokeFlowResponseHandler asyncResponseHandler) {
        return invokeFlow(InvokeFlowRequest.builder().applyMutation(invokeFlowRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Invokes an inline Amazon Bedrock agent using the configurations you provide with the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the following fields for security purposes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * (Optional) <code>customerEncryptionKeyArn</code> – The Amazon Resource Name (ARN) of a KMS key to encrypt the
     * creation of the agent.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <code>idleSessionTTLinSeconds</code> – Specify the number of seconds for which the agent should
     * maintain session information. After this time expires, the subsequent <code>InvokeInlineAgent</code> request
     * begins a new session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To override the default prompt behavior for agent orchestration and to use advanced prompts, include a
     * <code>promptOverrideConfiguration</code> object. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The agent instructions will not be honored if your agent has only one knowledge base, uses default prompts, has
     * no action group, and user input is disabled.
     * </p>
     * </li>
     * </ul>
     * <note> </note>
     *
     * @param invokeInlineAgentRequest
     * @return A Java Future containing the result of the InvokeInlineAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeInlineAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeInlineAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeInlineAgent(InvokeInlineAgentRequest invokeInlineAgentRequest,
            InvokeInlineAgentResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes an inline Amazon Bedrock agent using the configurations you provide with the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the following fields for security purposes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * (Optional) <code>customerEncryptionKeyArn</code> – The Amazon Resource Name (ARN) of a KMS key to encrypt the
     * creation of the agent.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <code>idleSessionTTLinSeconds</code> – Specify the number of seconds for which the agent should
     * maintain session information. After this time expires, the subsequent <code>InvokeInlineAgent</code> request
     * begins a new session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To override the default prompt behavior for agent orchestration and to use advanced prompts, include a
     * <code>promptOverrideConfiguration</code> object. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The agent instructions will not be honored if your agent has only one knowledge base, uses default prompts, has
     * no action group, and user input is disabled.
     * </p>
     * </li>
     * </ul>
     * <note> </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeInlineAgentRequest.Builder} avoiding the need
     * to create one manually via {@link InvokeInlineAgentRequest#builder()}
     * </p>
     *
     * @param invokeInlineAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the InvokeInlineAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeInlineAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeInlineAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeInlineAgent(Consumer<InvokeInlineAgentRequest.Builder> invokeInlineAgentRequest,
            InvokeInlineAgentResponseHandler asyncResponseHandler) {
        return invokeInlineAgent(InvokeInlineAgentRequest.builder().applyMutation(invokeInlineAgentRequest).build(),
                asyncResponseHandler);
    }

    /**
     * <p>
     * Optimizes a prompt for the task that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-optimize.html">Optimize a prompt</a>
     * in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param optimizePromptRequest
     * @return A Java Future containing the result of the OptimizePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.OptimizePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/OptimizePrompt"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> optimizePrompt(OptimizePromptRequest optimizePromptRequest,
            OptimizePromptResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Optimizes a prompt for the task that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-optimize.html">Optimize a prompt</a>
     * in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OptimizePromptRequest.Builder} avoiding the need to
     * create one manually via {@link OptimizePromptRequest#builder()}
     * </p>
     *
     * @param optimizePromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the OptimizePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.OptimizePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/OptimizePrompt"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> optimizePrompt(Consumer<OptimizePromptRequest.Builder> optimizePromptRequest,
            OptimizePromptResponseHandler asyncResponseHandler) {
        return optimizePrompt(OptimizePromptRequest.builder().applyMutation(optimizePromptRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Reranks the relevance of sources based on queries. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html">Improve the relevance of query responses
     * with a reranker model</a>.
     * </p>
     *
     * @param rerankRequest
     * @return A Java Future containing the result of the Rerank operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RerankResponse> rerank(RerankRequest rerankRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reranks the relevance of sources based on queries. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html">Improve the relevance of query responses
     * with a reranker model</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RerankRequest.Builder} avoiding the need to create
     * one manually via {@link RerankRequest#builder()}
     * </p>
     *
     * @param rerankRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the Rerank operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RerankResponse> rerank(Consumer<RerankRequest.Builder> rerankRequest) {
        return rerank(RerankRequest.builder().applyMutation(rerankRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)} operation.</b>
     * </p>
     *
     * @param rerankRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankPublisher rerankPaginator(RerankRequest rerankRequest) {
        return new RerankPublisher(this, rerankRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RerankRequest.Builder} avoiding the need to create
     * one manually via {@link RerankRequest#builder()}
     * </p>
     *
     * @param rerankRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankPublisher rerankPaginator(Consumer<RerankRequest.Builder> rerankRequest) {
        return rerankPaginator(RerankRequest.builder().applyMutation(rerankRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     *
     * @param retrieveRequest
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(RetrieveRequest retrieveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrieve(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results and using the specified
     * foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>.
     * The response only cites sources that are relevant to the query.
     * </p>
     *
     * @param retrieveAndGenerateRequest
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            RetrieveAndGenerateRequest retrieveAndGenerateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results and using the specified
     * foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>.
     * The response only cites sources that are relevant to the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveAndGenerateRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            Consumer<RetrieveAndGenerateRequest.Builder> retrieveAndGenerateRequest) {
        return retrieveAndGenerate(RetrieveAndGenerateRequest.builder().applyMutation(retrieveAndGenerateRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results, with output in streaming format.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including
     * <code>InvokeModelWithResponseStream</code>.
     * </p>
     * </note>
     *
     * @param retrieveAndGenerateStreamRequest
     * @return A Java Future containing the result of the RetrieveAndGenerateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> retrieveAndGenerateStream(RetrieveAndGenerateStreamRequest retrieveAndGenerateStreamRequest,
            RetrieveAndGenerateStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results, with output in streaming format.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including
     * <code>InvokeModelWithResponseStream</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateStreamRequest.Builder} avoiding
     * the need to create one manually via {@link RetrieveAndGenerateStreamRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RetrieveAndGenerateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> retrieveAndGenerateStream(
            Consumer<RetrieveAndGenerateStreamRequest.Builder> retrieveAndGenerateStreamRequest,
            RetrieveAndGenerateStreamResponseHandler asyncResponseHandler) {
        return retrieveAndGenerateStream(
                RetrieveAndGenerateStreamRequest.builder().applyMutation(retrieveAndGenerateStreamRequest).build(),
                asyncResponseHandler);
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     *
     * @param retrieveRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(RetrieveRequest retrieveRequest) {
        return new RetrievePublisher(this, retrieveRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrievePaginator(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    @Override
    default BedrockAgentRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentRuntimeAsyncClient}.
     */
    static BedrockAgentRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockAgentRuntimeAsyncClientBuilder();
    }
}
