/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of the inline agent's action group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentActionGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentActionGroup.Builder, AgentActionGroup> {
    private static final SdkField<ActionGroupExecutor> ACTION_GROUP_EXECUTOR_FIELD = SdkField
            .<ActionGroupExecutor> builder(MarshallingType.SDK_POJO).memberName("actionGroupExecutor")
            .getter(getter(AgentActionGroup::actionGroupExecutor)).setter(setter(Builder::actionGroupExecutor))
            .constructor(ActionGroupExecutor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupExecutor").build())
            .build();

    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupName").getter(getter(AgentActionGroup::actionGroupName))
            .setter(setter(Builder::actionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()).build();

    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.<APISchema> builder(MarshallingType.SDK_POJO)
            .memberName("apiSchema").getter(getter(AgentActionGroup::apiSchema)).setter(setter(Builder::apiSchema))
            .constructor(APISchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentActionGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<FunctionSchema> FUNCTION_SCHEMA_FIELD = SdkField
            .<FunctionSchema> builder(MarshallingType.SDK_POJO).memberName("functionSchema")
            .getter(getter(AgentActionGroup::functionSchema)).setter(setter(Builder::functionSchema))
            .constructor(FunctionSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionSchema").build()).build();

    private static final SdkField<String> PARENT_ACTION_GROUP_SIGNATURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("parentActionGroupSignature")
            .getter(getter(AgentActionGroup::parentActionGroupSignatureAsString))
            .setter(setter(Builder::parentActionGroupSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionGroupSignature").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_EXECUTOR_FIELD,
            ACTION_GROUP_NAME_FIELD, API_SCHEMA_FIELD, DESCRIPTION_FIELD, FUNCTION_SCHEMA_FIELD,
            PARENT_ACTION_GROUP_SIGNATURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ActionGroupExecutor actionGroupExecutor;

    private final String actionGroupName;

    private final APISchema apiSchema;

    private final String description;

    private final FunctionSchema functionSchema;

    private final String parentActionGroupSignature;

    private AgentActionGroup(BuilderImpl builder) {
        this.actionGroupExecutor = builder.actionGroupExecutor;
        this.actionGroupName = builder.actionGroupName;
        this.apiSchema = builder.apiSchema;
        this.description = builder.description;
        this.functionSchema = builder.functionSchema;
        this.parentActionGroupSignature = builder.parentActionGroupSignature;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
     * invoking the action or the custom control method for handling the information elicited from the user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out
     *         upon invoking the action or the custom control method for handling the information elicited from the
     *         user.
     */
    public final ActionGroupExecutor actionGroupExecutor() {
        return actionGroupExecutor;
    }

    /**
     * <p>
     * The name of the action group.
     * </p>
     * 
     * @return The name of the action group.
     */
    public final String actionGroupName() {
        return actionGroupName;
    }

    /**
     * <p>
     * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
     * YAML-formatted payload defining the schema. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
     * schemas</a>.
     * </p>
     * 
     * @return Contains either details about the S3 object containing the OpenAPI schema for the action group or the
     *         JSON or YAML-formatted payload defining the schema. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
     *         schemas</a>.
     */
    public final APISchema apiSchema() {
        return apiSchema;
    }

    /**
     * <p>
     * A description of the action group.
     * </p>
     * 
     * @return A description of the action group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Contains details about the function schema for the action group or the JSON or YAML-formatted payload defining
     * the schema.
     * </p>
     * 
     * @return Contains details about the function schema for the action group or the JSON or YAML-formatted payload
     *         defining the schema.
     */
    public final FunctionSchema functionSchema() {
        return functionSchema;
    }

    /**
     * <p>
     * To allow your agent to request the user for additional information when trying to complete a task, set this field
     * to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and
     * <code>actionGroupExecutor</code> fields blank for this action group.
     * </p>
     * <p>
     * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
     * <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and
     * <code>actionGroupExecutor</code> fields blank for this action group.
     * </p>
     * <p>
     * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
     * have enough information to complete the API request, it will invoke this action group instead and return an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a>
     * reprompting the user for more information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parentActionGroupSignature} will return {@link ActionGroupSignature#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #parentActionGroupSignatureAsString}.
     * </p>
     * 
     * @return To allow your agent to request the user for additional information when trying to complete a task, set
     *         this field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>,
     *         <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group. </p>
     *         <p>
     *         To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
     *         field to <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>,
     *         <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.
     *         </p>
     *         <p>
     *         During orchestration, if your agent determines that it needs to invoke an API in an action group, but
     *         doesn't have enough information to complete the API request, it will invoke this action group instead and
     *         return an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
     *         >Observation</a> reprompting the user for more information.
     * @see ActionGroupSignature
     */
    public final ActionGroupSignature parentActionGroupSignature() {
        return ActionGroupSignature.fromValue(parentActionGroupSignature);
    }

    /**
     * <p>
     * To allow your agent to request the user for additional information when trying to complete a task, set this field
     * to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and
     * <code>actionGroupExecutor</code> fields blank for this action group.
     * </p>
     * <p>
     * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
     * <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and
     * <code>actionGroupExecutor</code> fields blank for this action group.
     * </p>
     * <p>
     * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
     * have enough information to complete the API request, it will invoke this action group instead and return an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a>
     * reprompting the user for more information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parentActionGroupSignature} will return {@link ActionGroupSignature#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #parentActionGroupSignatureAsString}.
     * </p>
     * 
     * @return To allow your agent to request the user for additional information when trying to complete a task, set
     *         this field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>,
     *         <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group. </p>
     *         <p>
     *         To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
     *         field to <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>,
     *         <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.
     *         </p>
     *         <p>
     *         During orchestration, if your agent determines that it needs to invoke an API in an action group, but
     *         doesn't have enough information to complete the API request, it will invoke this action group instead and
     *         return an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
     *         >Observation</a> reprompting the user for more information.
     * @see ActionGroupSignature
     */
    public final String parentActionGroupSignatureAsString() {
        return parentActionGroupSignature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupExecutor());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(apiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(functionSchema());
        hashCode = 31 * hashCode + Objects.hashCode(parentActionGroupSignatureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentActionGroup)) {
            return false;
        }
        AgentActionGroup other = (AgentActionGroup) obj;
        return Objects.equals(actionGroupExecutor(), other.actionGroupExecutor())
                && Objects.equals(actionGroupName(), other.actionGroupName()) && Objects.equals(apiSchema(), other.apiSchema())
                && Objects.equals(description(), other.description()) && Objects.equals(functionSchema(), other.functionSchema())
                && Objects.equals(parentActionGroupSignatureAsString(), other.parentActionGroupSignatureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentActionGroup").add("ActionGroupExecutor", actionGroupExecutor())
                .add("ActionGroupName", actionGroupName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApiSchema", apiSchema())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FunctionSchema", functionSchema()).add("ParentActionGroupSignature", parentActionGroupSignatureAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroupExecutor":
            return Optional.ofNullable(clazz.cast(actionGroupExecutor()));
        case "actionGroupName":
            return Optional.ofNullable(clazz.cast(actionGroupName()));
        case "apiSchema":
            return Optional.ofNullable(clazz.cast(apiSchema()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "functionSchema":
            return Optional.ofNullable(clazz.cast(functionSchema()));
        case "parentActionGroupSignature":
            return Optional.ofNullable(clazz.cast(parentActionGroupSignatureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionGroupExecutor", ACTION_GROUP_EXECUTOR_FIELD);
        map.put("actionGroupName", ACTION_GROUP_NAME_FIELD);
        map.put("apiSchema", API_SCHEMA_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("functionSchema", FUNCTION_SCHEMA_FIELD);
        map.put("parentActionGroupSignature", PARENT_ACTION_GROUP_SIGNATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentActionGroup, T> g) {
        return obj -> g.apply((AgentActionGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentActionGroup> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
         * invoking the action or the custom control method for handling the information elicited from the user.
         * </p>
         * 
         * @param actionGroupExecutor
         *        The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried
         *        out upon invoking the action or the custom control method for handling the information elicited from
         *        the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
         * invoking the action or the custom control method for handling the information elicited from the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionGroupExecutor.Builder} avoiding the
         * need to create one manually via {@link ActionGroupExecutor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionGroupExecutor.Builder#build()} is called immediately and
         * its result is passed to {@link #actionGroupExecutor(ActionGroupExecutor)}.
         * 
         * @param actionGroupExecutor
         *        a consumer that will call methods on {@link ActionGroupExecutor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroupExecutor(ActionGroupExecutor)
         */
        default Builder actionGroupExecutor(Consumer<ActionGroupExecutor.Builder> actionGroupExecutor) {
            return actionGroupExecutor(ActionGroupExecutor.builder().applyMutation(actionGroupExecutor).build());
        }

        /**
         * <p>
         * The name of the action group.
         * </p>
         * 
         * @param actionGroupName
         *        The name of the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupName(String actionGroupName);

        /**
         * <p>
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
         * YAML-formatted payload defining the schema. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
         * schemas</a>.
         * </p>
         * 
         * @param apiSchema
         *        Contains either details about the S3 object containing the OpenAPI schema for the action group or the
         *        JSON or YAML-formatted payload defining the schema. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group
         *        OpenAPI schemas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSchema(APISchema apiSchema);

        /**
         * <p>
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
         * YAML-formatted payload defining the schema. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
         * schemas</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link APISchema.Builder} avoiding the need to
         * create one manually via {@link APISchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APISchema.Builder#build()} is called immediately and its result
         * is passed to {@link #apiSchema(APISchema)}.
         * 
         * @param apiSchema
         *        a consumer that will call methods on {@link APISchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiSchema(APISchema)
         */
        default Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return apiSchema(APISchema.builder().applyMutation(apiSchema).build());
        }

        /**
         * <p>
         * A description of the action group.
         * </p>
         * 
         * @param description
         *        A description of the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains details about the function schema for the action group or the JSON or YAML-formatted payload
         * defining the schema.
         * </p>
         * 
         * @param functionSchema
         *        Contains details about the function schema for the action group or the JSON or YAML-formatted payload
         *        defining the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionSchema(FunctionSchema functionSchema);

        /**
         * <p>
         * Contains details about the function schema for the action group or the JSON or YAML-formatted payload
         * defining the schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionSchema.Builder} avoiding the need
         * to create one manually via {@link FunctionSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #functionSchema(FunctionSchema)}.
         * 
         * @param functionSchema
         *        a consumer that will call methods on {@link FunctionSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionSchema(FunctionSchema)
         */
        default Builder functionSchema(Consumer<FunctionSchema.Builder> functionSchema) {
            return functionSchema(FunctionSchema.builder().applyMutation(functionSchema).build());
        }

        /**
         * <p>
         * To allow your agent to request the user for additional information when trying to complete a task, set this
         * field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>, <code>apiSchema</code>,
         * and <code>actionGroupExecutor</code> fields blank for this action group.
         * </p>
         * <p>
         * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
         * <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and
         * <code>actionGroupExecutor</code> fields blank for this action group.
         * </p>
         * <p>
         * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
         * have enough information to complete the API request, it will invoke this action group instead and return an
         * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">
         * Observation</a> reprompting the user for more information.
         * </p>
         * 
         * @param parentActionGroupSignature
         *        To allow your agent to request the user for additional information when trying to complete a task, set
         *        this field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>,
         *        <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group. </p>
         *        <p>
         *        To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
         *        field to <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>,
         *        <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.
         *        </p>
         *        <p>
         *        During orchestration, if your agent determines that it needs to invoke an API in an action group, but
         *        doesn't have enough information to complete the API request, it will invoke this action group instead
         *        and return an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
         *        >Observation</a> reprompting the user for more information.
         * @see ActionGroupSignature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupSignature
         */
        Builder parentActionGroupSignature(String parentActionGroupSignature);

        /**
         * <p>
         * To allow your agent to request the user for additional information when trying to complete a task, set this
         * field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>, <code>apiSchema</code>,
         * and <code>actionGroupExecutor</code> fields blank for this action group.
         * </p>
         * <p>
         * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
         * <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>, <code>apiSchema</code>, and
         * <code>actionGroupExecutor</code> fields blank for this action group.
         * </p>
         * <p>
         * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
         * have enough information to complete the API request, it will invoke this action group instead and return an
         * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">
         * Observation</a> reprompting the user for more information.
         * </p>
         * 
         * @param parentActionGroupSignature
         *        To allow your agent to request the user for additional information when trying to complete a task, set
         *        this field to <code>AMAZON.UserInput</code>. You must leave the <code>description</code>,
         *        <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group. </p>
         *        <p>
         *        To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
         *        field to <code>AMAZON.CodeInterpreter</code>. You must leave the <code>description</code>,
         *        <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields blank for this action group.
         *        </p>
         *        <p>
         *        During orchestration, if your agent determines that it needs to invoke an API in an action group, but
         *        doesn't have enough information to complete the API request, it will invoke this action group instead
         *        and return an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
         *        >Observation</a> reprompting the user for more information.
         * @see ActionGroupSignature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupSignature
         */
        Builder parentActionGroupSignature(ActionGroupSignature parentActionGroupSignature);
    }

    static final class BuilderImpl implements Builder {
        private ActionGroupExecutor actionGroupExecutor;

        private String actionGroupName;

        private APISchema apiSchema;

        private String description;

        private FunctionSchema functionSchema;

        private String parentActionGroupSignature;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentActionGroup model) {
            actionGroupExecutor(model.actionGroupExecutor);
            actionGroupName(model.actionGroupName);
            apiSchema(model.apiSchema);
            description(model.description);
            functionSchema(model.functionSchema);
            parentActionGroupSignature(model.parentActionGroupSignature);
        }

        public final ActionGroupExecutor.Builder getActionGroupExecutor() {
            return actionGroupExecutor != null ? actionGroupExecutor.toBuilder() : null;
        }

        public final void setActionGroupExecutor(ActionGroupExecutor.BuilderImpl actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor != null ? actionGroupExecutor.build() : null;
        }

        @Override
        public final Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor;
            return this;
        }

        public final String getActionGroupName() {
            return actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return apiSchema != null ? apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FunctionSchema.Builder getFunctionSchema() {
            return functionSchema != null ? functionSchema.toBuilder() : null;
        }

        public final void setFunctionSchema(FunctionSchema.BuilderImpl functionSchema) {
            this.functionSchema = functionSchema != null ? functionSchema.build() : null;
        }

        @Override
        public final Builder functionSchema(FunctionSchema functionSchema) {
            this.functionSchema = functionSchema;
            return this;
        }

        public final String getParentActionGroupSignature() {
            return parentActionGroupSignature;
        }

        public final void setParentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
        }

        @Override
        public final Builder parentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
            return this;
        }

        @Override
        public final Builder parentActionGroupSignature(ActionGroupSignature parentActionGroupSignature) {
            this.parentActionGroupSignature(parentActionGroupSignature == null ? null : parentActionGroupSignature.toString());
            return this;
        }

        @Override
        public AgentActionGroup build() {
            return new AgentActionGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
