/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A citation event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CitationEvent implements SdkPojo, Serializable, ToCopyableBuilder<CitationEvent.Builder, CitationEvent>,
        RetrieveAndGenerateStreamResponseOutput {
    private static final SdkField<Citation> CITATION_FIELD = SdkField.<Citation> builder(MarshallingType.SDK_POJO)
            .memberName("citation").getter(getter(CitationEvent::citation)).setter(setter(Builder::citation))
            .constructor(Citation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Citation citation;

    protected CitationEvent(BuilderImpl builder) {
        this.citation = builder.citation;
    }

    /**
     * <p>
     * The citation.
     * </p>
     * 
     * @return The citation.
     */
    public final Citation citation() {
        return citation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(citation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationEvent)) {
            return false;
        }
        CitationEvent other = (CitationEvent) obj;
        return Objects.equals(citation(), other.citation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CitationEvent").add("Citation", citation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "citation":
            return Optional.ofNullable(clazz.cast(citation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final CitationEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("citation", CITATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationEvent, T> g) {
        return obj -> g.apply((CitationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link CitationEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(RetrieveAndGenerateStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CitationEvent> {
        /**
         * <p>
         * The citation.
         * </p>
         * 
         * @param citation
         *        The citation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citation(Citation citation);

        /**
         * <p>
         * The citation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Citation.Builder} avoiding the need to
         * create one manually via {@link Citation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Citation.Builder#build()} is called immediately and its result is
         * passed to {@link #citation(Citation)}.
         * 
         * @param citation
         *        a consumer that will call methods on {@link Citation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citation(Citation)
         */
        default Builder citation(Consumer<Citation.Builder> citation) {
            return citation(Citation.builder().applyMutation(citation).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private Citation citation;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CitationEvent model) {
            citation(model.citation);
        }

        public final Citation.Builder getCitation() {
            return citation != null ? citation.toBuilder() : null;
        }

        public final void setCitation(Citation.BuilderImpl citation) {
            this.citation = citation != null ? citation.build() : null;
        }

        @Override
        public final Builder citation(Citation citation) {
            this.citation = citation;
            return this;
        }

        @Override
        public CitationEvent build() {
            return new CitationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
