/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the function that the agent predicts should be called.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In the <code>returnControl</code> field of the <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionInvocationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionInvocationInput.Builder, FunctionInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroup").getter(getter(FunctionInvocationInput::actionGroup)).setter(setter(Builder::actionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroup").build()).build();

    private static final SdkField<String> ACTION_INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionInvocationType").getter(getter(FunctionInvocationInput::actionInvocationTypeAsString))
            .setter(setter(Builder::actionInvocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionInvocationType").build())
            .build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(FunctionInvocationInput::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorName").getter(getter(FunctionInvocationInput::collaboratorName))
            .setter(setter(Builder::collaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()).build();

    private static final SdkField<String> FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("function").getter(getter(FunctionInvocationInput::function)).setter(setter(Builder::function))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()).build();

    private static final SdkField<List<FunctionParameter>> PARAMETERS_FIELD = SdkField
            .<List<FunctionParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(FunctionInvocationInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FunctionParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD,
            ACTION_INVOCATION_TYPE_FIELD, AGENT_ID_FIELD, COLLABORATOR_NAME_FIELD, FUNCTION_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionGroup;

    private final String actionInvocationType;

    private final String agentId;

    private final String collaboratorName;

    private final String function;

    private final List<FunctionParameter> parameters;

    private FunctionInvocationInput(BuilderImpl builder) {
        this.actionGroup = builder.actionGroup;
        this.actionInvocationType = builder.actionInvocationType;
        this.agentId = builder.agentId;
        this.collaboratorName = builder.collaboratorName;
        this.function = builder.function;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The action group that the function belongs to.
     * </p>
     * 
     * @return The action group that the function belongs to.
     */
    public final String actionGroup() {
        return actionGroup;
    }

    /**
     * <p>
     * Contains information about the function to invoke,
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionInvocationType} will return {@link ActionInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionInvocationTypeAsString}.
     * </p>
     * 
     * @return Contains information about the function to invoke,
     * @see ActionInvocationType
     */
    public final ActionInvocationType actionInvocationType() {
        return ActionInvocationType.fromValue(actionInvocationType);
    }

    /**
     * <p>
     * Contains information about the function to invoke,
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionInvocationType} will return {@link ActionInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionInvocationTypeAsString}.
     * </p>
     * 
     * @return Contains information about the function to invoke,
     * @see ActionInvocationType
     */
    public final String actionInvocationTypeAsString() {
        return actionInvocationType;
    }

    /**
     * <p>
     * The agent's ID.
     * </p>
     * 
     * @return The agent's ID.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The collaborator's name.
     * </p>
     * 
     * @return The collaborator's name.
     */
    public final String collaboratorName() {
        return collaboratorName;
    }

    /**
     * <p>
     * The name of the function.
     * </p>
     * 
     * @return The name of the function.
     */
    public final String function() {
        return function;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters of the function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of parameters of the function.
     */
    public final List<FunctionParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(actionInvocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionInvocationInput)) {
            return false;
        }
        FunctionInvocationInput other = (FunctionInvocationInput) obj;
        return Objects.equals(actionGroup(), other.actionGroup())
                && Objects.equals(actionInvocationTypeAsString(), other.actionInvocationTypeAsString())
                && Objects.equals(agentId(), other.agentId()) && Objects.equals(collaboratorName(), other.collaboratorName())
                && Objects.equals(function(), other.function()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionInvocationInput").add("ActionGroup", actionGroup())
                .add("ActionInvocationType", actionInvocationTypeAsString()).add("AgentId", agentId())
                .add("CollaboratorName", collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Function", function()).add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroup":
            return Optional.ofNullable(clazz.cast(actionGroup()));
        case "actionInvocationType":
            return Optional.ofNullable(clazz.cast(actionInvocationTypeAsString()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "collaboratorName":
            return Optional.ofNullable(clazz.cast(collaboratorName()));
        case "function":
            return Optional.ofNullable(clazz.cast(function()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionGroup", ACTION_GROUP_FIELD);
        map.put("actionInvocationType", ACTION_INVOCATION_TYPE_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("function", FUNCTION_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionInvocationInput, T> g) {
        return obj -> g.apply((FunctionInvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionInvocationInput> {
        /**
         * <p>
         * The action group that the function belongs to.
         * </p>
         * 
         * @param actionGroup
         *        The action group that the function belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroup(String actionGroup);

        /**
         * <p>
         * Contains information about the function to invoke,
         * </p>
         * 
         * @param actionInvocationType
         *        Contains information about the function to invoke,
         * @see ActionInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionInvocationType
         */
        Builder actionInvocationType(String actionInvocationType);

        /**
         * <p>
         * Contains information about the function to invoke,
         * </p>
         * 
         * @param actionInvocationType
         *        Contains information about the function to invoke,
         * @see ActionInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionInvocationType
         */
        Builder actionInvocationType(ActionInvocationType actionInvocationType);

        /**
         * <p>
         * The agent's ID.
         * </p>
         * 
         * @param agentId
         *        The agent's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The collaborator's name.
         * </p>
         * 
         * @param collaboratorName
         *        The collaborator's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorName(String collaboratorName);

        /**
         * <p>
         * The name of the function.
         * </p>
         * 
         * @param function
         *        The name of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(String function);

        /**
         * <p>
         * A list of parameters of the function.
         * </p>
         * 
         * @param parameters
         *        A list of parameters of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<FunctionParameter> parameters);

        /**
         * <p>
         * A list of parameters of the function.
         * </p>
         * 
         * @param parameters
         *        A list of parameters of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(FunctionParameter... parameters);

        /**
         * <p>
         * A list of parameters of the function.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParameter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<FunctionParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FunctionParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<FunctionParameter>)
         */
        Builder parameters(Consumer<FunctionParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String actionGroup;

        private String actionInvocationType;

        private String agentId;

        private String collaboratorName;

        private String function;

        private List<FunctionParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionInvocationInput model) {
            actionGroup(model.actionGroup);
            actionInvocationType(model.actionInvocationType);
            agentId(model.agentId);
            collaboratorName(model.collaboratorName);
            function(model.function);
            parameters(model.parameters);
        }

        public final String getActionGroup() {
            return actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        public final String getActionInvocationType() {
            return actionInvocationType;
        }

        public final void setActionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
        }

        @Override
        public final Builder actionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
            return this;
        }

        @Override
        public final Builder actionInvocationType(ActionInvocationType actionInvocationType) {
            this.actionInvocationType(actionInvocationType == null ? null : actionInvocationType.toString());
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getCollaboratorName() {
            return collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getFunction() {
            return function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<FunctionParameter.Builder> getParameters() {
            List<FunctionParameter.Builder> result = FunctionParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<FunctionParameter.BuilderImpl> parameters) {
            this.parameters = FunctionParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<FunctionParameter> parameters) {
            this.parameters = FunctionParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(FunctionParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<FunctionParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> FunctionParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FunctionInvocationInput build() {
            return new FunctionInvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
