/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeFlowRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<InvokeFlowRequest.Builder, InvokeFlowRequest> {
    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrace").getter(getter(InvokeFlowRequest::enableTrace)).setter(setter(Builder::enableTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()).build();

    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowAliasIdentifier").getter(getter(InvokeFlowRequest::flowAliasIdentifier))
            .setter(setter(Builder::flowAliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowAliasIdentifier").build()).build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(InvokeFlowRequest::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()).build();

    private static final SdkField<List<FlowInput>> INPUTS_FIELD = SdkField
            .<List<FlowInput>> builder(MarshallingType.LIST)
            .memberName("inputs")
            .getter(getter(InvokeFlowRequest::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ModelPerformanceConfiguration> MODEL_PERFORMANCE_CONFIGURATION_FIELD = SdkField
            .<ModelPerformanceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("modelPerformanceConfiguration")
            .getter(getter(InvokeFlowRequest::modelPerformanceConfiguration))
            .setter(setter(Builder::modelPerformanceConfiguration))
            .constructor(ModelPerformanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformanceConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_TRACE_FIELD,
            FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD, INPUTS_FIELD, MODEL_PERFORMANCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean enableTrace;

    private final String flowAliasIdentifier;

    private final String flowIdentifier;

    private final List<FlowInput> inputs;

    private final ModelPerformanceConfiguration modelPerformanceConfiguration;

    private InvokeFlowRequest(BuilderImpl builder) {
        super(builder);
        this.enableTrace = builder.enableTrace;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.inputs = builder.inputs;
        this.modelPerformanceConfiguration = builder.modelPerformanceConfiguration;
    }

    /**
     * <p>
     * Specifies whether to return the trace for the flow or not. Traces track inputs and outputs for nodes in the flow.
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track
     * each step in your prompt flow by viewing its trace in Amazon Bedrock</a>.
     * </p>
     * 
     * @return Specifies whether to return the trace for the flow or not. Traces track inputs and outputs for nodes in
     *         the flow. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your
     *         prompt flow by viewing its trace in Amazon Bedrock</a>.
     */
    public final Boolean enableTrace() {
        return enableTrace;
    }

    /**
     * <p>
     * The unique identifier of the flow alias.
     * </p>
     * 
     * @return The unique identifier of the flow alias.
     */
    public final String flowAliasIdentifier() {
        return flowAliasIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each containing information about an input into the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return A list of objects, each containing information about an input into the flow.
     */
    public final List<FlowInput> inputs() {
        return inputs;
    }

    /**
     * <p>
     * Model performance settings for the request.
     * </p>
     * 
     * @return Model performance settings for the request.
     */
    public final ModelPerformanceConfiguration modelPerformanceConfiguration() {
        return modelPerformanceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelPerformanceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeFlowRequest)) {
            return false;
        }
        InvokeFlowRequest other = (InvokeFlowRequest) obj;
        return Objects.equals(enableTrace(), other.enableTrace())
                && Objects.equals(flowAliasIdentifier(), other.flowAliasIdentifier())
                && Objects.equals(flowIdentifier(), other.flowIdentifier()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs())
                && Objects.equals(modelPerformanceConfiguration(), other.modelPerformanceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeFlowRequest").add("EnableTrace", enableTrace())
                .add("FlowAliasIdentifier", flowAliasIdentifier()).add("FlowIdentifier", flowIdentifier())
                .add("Inputs", hasInputs() ? inputs() : null)
                .add("ModelPerformanceConfiguration", modelPerformanceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableTrace":
            return Optional.ofNullable(clazz.cast(enableTrace()));
        case "flowAliasIdentifier":
            return Optional.ofNullable(clazz.cast(flowAliasIdentifier()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "modelPerformanceConfiguration":
            return Optional.ofNullable(clazz.cast(modelPerformanceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("modelPerformanceConfiguration", MODEL_PERFORMANCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeFlowRequest, T> g) {
        return obj -> g.apply((InvokeFlowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeFlowRequest> {
        /**
         * <p>
         * Specifies whether to return the trace for the flow or not. Traces track inputs and outputs for nodes in the
         * flow. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt
         * flow by viewing its trace in Amazon Bedrock</a>.
         * </p>
         * 
         * @param enableTrace
         *        Specifies whether to return the trace for the flow or not. Traces track inputs and outputs for nodes
         *        in the flow. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your
         *        prompt flow by viewing its trace in Amazon Bedrock</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTrace(Boolean enableTrace);

        /**
         * <p>
         * The unique identifier of the flow alias.
         * </p>
         * 
         * @param flowAliasIdentifier
         *        The unique identifier of the flow alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowAliasIdentifier(String flowAliasIdentifier);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * A list of objects, each containing information about an input into the flow.
         * </p>
         * 
         * @param inputs
         *        A list of objects, each containing information about an input into the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<FlowInput> inputs);

        /**
         * <p>
         * A list of objects, each containing information about an input into the flow.
         * </p>
         * 
         * @param inputs
         *        A list of objects, each containing information about an input into the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(FlowInput... inputs);

        /**
         * <p>
         * A list of objects, each containing information about an input into the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput.Builder#build()} is called
         * immediately and its result is passed to {@link #inputs(List<FlowInput>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(java.util.Collection<FlowInput>)
         */
        Builder inputs(Consumer<FlowInput.Builder>... inputs);

        /**
         * <p>
         * Model performance settings for the request.
         * </p>
         * 
         * @param modelPerformanceConfiguration
         *        Model performance settings for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPerformanceConfiguration(ModelPerformanceConfiguration modelPerformanceConfiguration);

        /**
         * <p>
         * Model performance settings for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelPerformanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link ModelPerformanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelPerformanceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modelPerformanceConfiguration(ModelPerformanceConfiguration)}.
         * 
         * @param modelPerformanceConfiguration
         *        a consumer that will call methods on {@link ModelPerformanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPerformanceConfiguration(ModelPerformanceConfiguration)
         */
        default Builder modelPerformanceConfiguration(
                Consumer<ModelPerformanceConfiguration.Builder> modelPerformanceConfiguration) {
            return modelPerformanceConfiguration(ModelPerformanceConfiguration.builder()
                    .applyMutation(modelPerformanceConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private Boolean enableTrace;

        private String flowAliasIdentifier;

        private String flowIdentifier;

        private List<FlowInput> inputs = DefaultSdkAutoConstructList.getInstance();

        private ModelPerformanceConfiguration modelPerformanceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeFlowRequest model) {
            super(model);
            enableTrace(model.enableTrace);
            flowAliasIdentifier(model.flowAliasIdentifier);
            flowIdentifier(model.flowIdentifier);
            inputs(model.inputs);
            modelPerformanceConfiguration(model.modelPerformanceConfiguration);
        }

        public final Boolean getEnableTrace() {
            return enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final List<FlowInput.Builder> getInputs() {
            List<FlowInput.Builder> result = FlowInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<FlowInput.BuilderImpl> inputs) {
            this.inputs = FlowInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<FlowInput> inputs) {
            this.inputs = FlowInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(FlowInput... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<FlowInput.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> FlowInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ModelPerformanceConfiguration.Builder getModelPerformanceConfiguration() {
            return modelPerformanceConfiguration != null ? modelPerformanceConfiguration.toBuilder() : null;
        }

        public final void setModelPerformanceConfiguration(ModelPerformanceConfiguration.BuilderImpl modelPerformanceConfiguration) {
            this.modelPerformanceConfiguration = modelPerformanceConfiguration != null ? modelPerformanceConfiguration.build()
                    : null;
        }

        @Override
        public final Builder modelPerformanceConfiguration(ModelPerformanceConfiguration modelPerformanceConfiguration) {
            this.modelPerformanceConfiguration = modelPerformanceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeFlowRequest build() {
            return new InvokeFlowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
