/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RerankRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<RerankRequest.Builder, RerankRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(RerankRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RerankQuery>> QUERIES_FIELD = SdkField
            .<List<RerankQuery>> builder(MarshallingType.LIST)
            .memberName("queries")
            .getter(getter(RerankRequest::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RerankQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(RerankQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RerankingConfiguration> RERANKING_CONFIGURATION_FIELD = SdkField
            .<RerankingConfiguration> builder(MarshallingType.SDK_POJO).memberName("rerankingConfiguration")
            .getter(getter(RerankRequest::rerankingConfiguration)).setter(setter(Builder::rerankingConfiguration))
            .constructor(RerankingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rerankingConfiguration").build())
            .build();

    private static final SdkField<List<RerankSource>> SOURCES_FIELD = SdkField
            .<List<RerankSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(RerankRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RerankSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(RerankSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            QUERIES_FIELD, RERANKING_CONFIGURATION_FIELD, SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<RerankQuery> queries;

    private final RerankingConfiguration rerankingConfiguration;

    private final List<RerankSource> sources;

    private RerankRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.queries = builder.queries;
        this.rerankingConfiguration = builder.rerankingConfiguration;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * If the total number of results was greater than could fit in a response, a token is returned in the
     * <code>nextToken</code> field. You can enter that token in this field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results was greater than could fit in a response, a token is returned in the
     *         <code>nextToken</code> field. You can enter that token in this field to return the next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which contains information about a query to submit to the reranker model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return An array of objects, each of which contains information about a query to submit to the reranker model.
     */
    public final List<RerankQuery> queries() {
        return queries;
    }

    /**
     * <p>
     * Contains configurations for reranking.
     * </p>
     * 
     * @return Contains configurations for reranking.
     */
    public final RerankingConfiguration rerankingConfiguration() {
        return rerankingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which contains information about the sources to rerank.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return An array of objects, each of which contains information about the sources to rerank.
     */
    public final List<RerankSource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rerankingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankRequest)) {
            return false;
        }
        RerankRequest other = (RerankRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasQueries() == other.hasQueries()
                && Objects.equals(queries(), other.queries())
                && Objects.equals(rerankingConfiguration(), other.rerankingConfiguration()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RerankRequest").add("NextToken", nextToken())
                .add("Queries", queries() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RerankingConfiguration", rerankingConfiguration())
                .add("Sources", sources() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "queries":
            return Optional.ofNullable(clazz.cast(queries()));
        case "rerankingConfiguration":
            return Optional.ofNullable(clazz.cast(rerankingConfiguration()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("queries", QUERIES_FIELD);
        map.put("rerankingConfiguration", RERANKING_CONFIGURATION_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankRequest, T> g) {
        return obj -> g.apply((RerankRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, RerankRequest> {
        /**
         * <p>
         * If the total number of results was greater than could fit in a response, a token is returned in the
         * <code>nextToken</code> field. You can enter that token in this field to return the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results was greater than could fit in a response, a token is returned in the
         *        <code>nextToken</code> field. You can enter that token in this field to return the next batch of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects, each of which contains information about a query to submit to the reranker model.
         * </p>
         * 
         * @param queries
         *        An array of objects, each of which contains information about a query to submit to the reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<RerankQuery> queries);

        /**
         * <p>
         * An array of objects, each of which contains information about a query to submit to the reranker model.
         * </p>
         * 
         * @param queries
         *        An array of objects, each of which contains information about a query to submit to the reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(RerankQuery... queries);

        /**
         * <p>
         * An array of objects, each of which contains information about a query to submit to the reranker model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #queries(List<RerankQuery>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<RerankQuery>)
         */
        Builder queries(Consumer<RerankQuery.Builder>... queries);

        /**
         * <p>
         * Contains configurations for reranking.
         * </p>
         * 
         * @param rerankingConfiguration
         *        Contains configurations for reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rerankingConfiguration(RerankingConfiguration rerankingConfiguration);

        /**
         * <p>
         * Contains configurations for reranking.
         * </p>
         * This is a convenience method that creates an instance of the {@link RerankingConfiguration.Builder} avoiding
         * the need to create one manually via {@link RerankingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RerankingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rerankingConfiguration(RerankingConfiguration)}.
         * 
         * @param rerankingConfiguration
         *        a consumer that will call methods on {@link RerankingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rerankingConfiguration(RerankingConfiguration)
         */
        default Builder rerankingConfiguration(Consumer<RerankingConfiguration.Builder> rerankingConfiguration) {
            return rerankingConfiguration(RerankingConfiguration.builder().applyMutation(rerankingConfiguration).build());
        }

        /**
         * <p>
         * An array of objects, each of which contains information about the sources to rerank.
         * </p>
         * 
         * @param sources
         *        An array of objects, each of which contains information about the sources to rerank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<RerankSource> sources);

        /**
         * <p>
         * An array of objects, each of which contains information about the sources to rerank.
         * </p>
         * 
         * @param sources
         *        An array of objects, each of which contains information about the sources to rerank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(RerankSource... sources);

        /**
         * <p>
         * An array of objects, each of which contains information about the sources to rerank.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankSource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankSource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<RerankSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<RerankSource>)
         */
        Builder sources(Consumer<RerankSource.Builder>... sources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String nextToken;

        private List<RerankQuery> queries = DefaultSdkAutoConstructList.getInstance();

        private RerankingConfiguration rerankingConfiguration;

        private List<RerankSource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RerankRequest model) {
            super(model);
            nextToken(model.nextToken);
            queries(model.queries);
            rerankingConfiguration(model.rerankingConfiguration);
            sources(model.sources);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RerankQuery.Builder> getQueries() {
            List<RerankQuery.Builder> result = RerankQueriesListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<RerankQuery.BuilderImpl> queries) {
            this.queries = RerankQueriesListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<RerankQuery> queries) {
            this.queries = RerankQueriesListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(RerankQuery... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<RerankQuery.Builder>... queries) {
            queries(Stream.of(queries).map(c -> RerankQuery.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RerankingConfiguration.Builder getRerankingConfiguration() {
            return rerankingConfiguration != null ? rerankingConfiguration.toBuilder() : null;
        }

        public final void setRerankingConfiguration(RerankingConfiguration.BuilderImpl rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration != null ? rerankingConfiguration.build() : null;
        }

        @Override
        public final Builder rerankingConfiguration(RerankingConfiguration rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration;
            return this;
        }

        public final List<RerankSource.Builder> getSources() {
            List<RerankSource.Builder> result = RerankSourcesListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<RerankSource.BuilderImpl> sources) {
            this.sources = RerankSourcesListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<RerankSource> sources) {
            this.sources = RerankSourcesListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(RerankSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<RerankSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> RerankSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RerankRequest build() {
            return new RerankRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
