/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A trace for a routing classifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingClassifierTrace implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingClassifierTrace.Builder, RoutingClassifierTrace> {
    private static final SdkField<InvocationInput> INVOCATION_INPUT_FIELD = SdkField
            .<InvocationInput> builder(MarshallingType.SDK_POJO).memberName("invocationInput")
            .getter(getter(RoutingClassifierTrace::invocationInput)).setter(setter(Builder::invocationInput))
            .constructor(InvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationInput").build()).build();

    private static final SdkField<ModelInvocationInput> MODEL_INVOCATION_INPUT_FIELD = SdkField
            .<ModelInvocationInput> builder(MarshallingType.SDK_POJO).memberName("modelInvocationInput")
            .getter(getter(RoutingClassifierTrace::modelInvocationInput)).setter(setter(Builder::modelInvocationInput))
            .constructor(ModelInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationInput").build())
            .build();

    private static final SdkField<RoutingClassifierModelInvocationOutput> MODEL_INVOCATION_OUTPUT_FIELD = SdkField
            .<RoutingClassifierModelInvocationOutput> builder(MarshallingType.SDK_POJO).memberName("modelInvocationOutput")
            .getter(getter(RoutingClassifierTrace::modelInvocationOutput)).setter(setter(Builder::modelInvocationOutput))
            .constructor(RoutingClassifierModelInvocationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInvocationOutput").build())
            .build();

    private static final SdkField<Observation> OBSERVATION_FIELD = SdkField.<Observation> builder(MarshallingType.SDK_POJO)
            .memberName("observation").getter(getter(RoutingClassifierTrace::observation)).setter(setter(Builder::observation))
            .constructor(Observation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_INPUT_FIELD,
            MODEL_INVOCATION_INPUT_FIELD, MODEL_INVOCATION_OUTPUT_FIELD, OBSERVATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InvocationInput invocationInput;

    private final ModelInvocationInput modelInvocationInput;

    private final RoutingClassifierModelInvocationOutput modelInvocationOutput;

    private final Observation observation;

    private final Type type;

    private RoutingClassifierTrace(BuilderImpl builder) {
        this.invocationInput = builder.invocationInput;
        this.modelInvocationInput = builder.modelInvocationInput;
        this.modelInvocationOutput = builder.modelInvocationOutput;
        this.observation = builder.observation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The classifier's invocation input.
     * </p>
     * 
     * @return The classifier's invocation input.
     */
    public final InvocationInput invocationInput() {
        return invocationInput;
    }

    /**
     * <p>
     * The classifier's model invocation input.
     * </p>
     * 
     * @return The classifier's model invocation input.
     */
    public final ModelInvocationInput modelInvocationInput() {
        return modelInvocationInput;
    }

    /**
     * <p>
     * The classifier's model invocation output.
     * </p>
     * 
     * @return The classifier's model invocation output.
     */
    public final RoutingClassifierModelInvocationOutput modelInvocationOutput() {
        return modelInvocationOutput;
    }

    /**
     * <p>
     * The classifier's observation.
     * </p>
     * 
     * @return The classifier's observation.
     */
    public final Observation observation() {
        return observation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelInvocationOutput());
        hashCode = 31 * hashCode + Objects.hashCode(observation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingClassifierTrace)) {
            return false;
        }
        RoutingClassifierTrace other = (RoutingClassifierTrace) obj;
        return Objects.equals(invocationInput(), other.invocationInput())
                && Objects.equals(modelInvocationInput(), other.modelInvocationInput())
                && Objects.equals(modelInvocationOutput(), other.modelInvocationOutput())
                && Objects.equals(observation(), other.observation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingClassifierTrace")
                .add("InvocationInput", invocationInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelInvocationInput", modelInvocationInput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelInvocationOutput", modelInvocationOutput() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Observation", observation() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationInput":
            return Optional.ofNullable(clazz.cast(invocationInput()));
        case "modelInvocationInput":
            return Optional.ofNullable(clazz.cast(modelInvocationInput()));
        case "modelInvocationOutput":
            return Optional.ofNullable(clazz.cast(modelInvocationOutput()));
        case "observation":
            return Optional.ofNullable(clazz.cast(observation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #invocationInput()} initialized to the given value.
     *
     * <p>
     * The classifier's invocation input.
     * </p>
     * 
     * @param invocationInput
     *        The classifier's invocation input.
     */
    public static RoutingClassifierTrace fromInvocationInput(InvocationInput invocationInput) {
        return builder().invocationInput(invocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #invocationInput()} initialized to the given value.
     *
     * <p>
     * The classifier's invocation input.
     * </p>
     * 
     * @param invocationInput
     *        The classifier's invocation input.
     */
    public static RoutingClassifierTrace fromInvocationInput(Consumer<InvocationInput.Builder> invocationInput) {
        InvocationInput.Builder builder = InvocationInput.builder();
        invocationInput.accept(builder);
        return fromInvocationInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #modelInvocationInput()} initialized to the given value.
     *
     * <p>
     * The classifier's model invocation input.
     * </p>
     * 
     * @param modelInvocationInput
     *        The classifier's model invocation input.
     */
    public static RoutingClassifierTrace fromModelInvocationInput(ModelInvocationInput modelInvocationInput) {
        return builder().modelInvocationInput(modelInvocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #modelInvocationInput()} initialized to the given value.
     *
     * <p>
     * The classifier's model invocation input.
     * </p>
     * 
     * @param modelInvocationInput
     *        The classifier's model invocation input.
     */
    public static RoutingClassifierTrace fromModelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
        ModelInvocationInput.Builder builder = ModelInvocationInput.builder();
        modelInvocationInput.accept(builder);
        return fromModelInvocationInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #modelInvocationOutput()} initialized to the given value.
     *
     * <p>
     * The classifier's model invocation output.
     * </p>
     * 
     * @param modelInvocationOutput
     *        The classifier's model invocation output.
     */
    public static RoutingClassifierTrace fromModelInvocationOutput(RoutingClassifierModelInvocationOutput modelInvocationOutput) {
        return builder().modelInvocationOutput(modelInvocationOutput).build();
    }

    /**
     * Create an instance of this class with {@link #modelInvocationOutput()} initialized to the given value.
     *
     * <p>
     * The classifier's model invocation output.
     * </p>
     * 
     * @param modelInvocationOutput
     *        The classifier's model invocation output.
     */
    public static RoutingClassifierTrace fromModelInvocationOutput(
            Consumer<RoutingClassifierModelInvocationOutput.Builder> modelInvocationOutput) {
        RoutingClassifierModelInvocationOutput.Builder builder = RoutingClassifierModelInvocationOutput.builder();
        modelInvocationOutput.accept(builder);
        return fromModelInvocationOutput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #observation()} initialized to the given value.
     *
     * <p>
     * The classifier's observation.
     * </p>
     * 
     * @param observation
     *        The classifier's observation.
     */
    public static RoutingClassifierTrace fromObservation(Observation observation) {
        return builder().observation(observation).build();
    }

    /**
     * Create an instance of this class with {@link #observation()} initialized to the given value.
     *
     * <p>
     * The classifier's observation.
     * </p>
     * 
     * @param observation
     *        The classifier's observation.
     */
    public static RoutingClassifierTrace fromObservation(Consumer<Observation.Builder> observation) {
        Observation.Builder builder = Observation.builder();
        observation.accept(builder);
        return fromObservation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationInput", INVOCATION_INPUT_FIELD);
        map.put("modelInvocationInput", MODEL_INVOCATION_INPUT_FIELD);
        map.put("modelInvocationOutput", MODEL_INVOCATION_OUTPUT_FIELD);
        map.put("observation", OBSERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingClassifierTrace, T> g) {
        return obj -> g.apply((RoutingClassifierTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingClassifierTrace> {
        /**
         * <p>
         * The classifier's invocation input.
         * </p>
         * 
         * @param invocationInput
         *        The classifier's invocation input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationInput(InvocationInput invocationInput);

        /**
         * <p>
         * The classifier's invocation input.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvocationInput.Builder} avoiding the
         * need to create one manually via {@link InvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvocationInput.Builder#build()} is called immediately and its
         * result is passed to {@link #invocationInput(InvocationInput)}.
         * 
         * @param invocationInput
         *        a consumer that will call methods on {@link InvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationInput(InvocationInput)
         */
        default Builder invocationInput(Consumer<InvocationInput.Builder> invocationInput) {
            return invocationInput(InvocationInput.builder().applyMutation(invocationInput).build());
        }

        /**
         * <p>
         * The classifier's model invocation input.
         * </p>
         * 
         * @param modelInvocationInput
         *        The classifier's model invocation input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInvocationInput(ModelInvocationInput modelInvocationInput);

        /**
         * <p>
         * The classifier's model invocation input.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelInvocationInput.Builder} avoiding
         * the need to create one manually via {@link ModelInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInvocationInput.Builder#build()} is called immediately and
         * its result is passed to {@link #modelInvocationInput(ModelInvocationInput)}.
         * 
         * @param modelInvocationInput
         *        a consumer that will call methods on {@link ModelInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInvocationInput(ModelInvocationInput)
         */
        default Builder modelInvocationInput(Consumer<ModelInvocationInput.Builder> modelInvocationInput) {
            return modelInvocationInput(ModelInvocationInput.builder().applyMutation(modelInvocationInput).build());
        }

        /**
         * <p>
         * The classifier's model invocation output.
         * </p>
         * 
         * @param modelInvocationOutput
         *        The classifier's model invocation output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelInvocationOutput(RoutingClassifierModelInvocationOutput modelInvocationOutput);

        /**
         * <p>
         * The classifier's model invocation output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RoutingClassifierModelInvocationOutput.Builder} avoiding the need to create one manually via
         * {@link RoutingClassifierModelInvocationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingClassifierModelInvocationOutput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #modelInvocationOutput(RoutingClassifierModelInvocationOutput)}.
         * 
         * @param modelInvocationOutput
         *        a consumer that will call methods on {@link RoutingClassifierModelInvocationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelInvocationOutput(RoutingClassifierModelInvocationOutput)
         */
        default Builder modelInvocationOutput(Consumer<RoutingClassifierModelInvocationOutput.Builder> modelInvocationOutput) {
            return modelInvocationOutput(RoutingClassifierModelInvocationOutput.builder().applyMutation(modelInvocationOutput)
                    .build());
        }

        /**
         * <p>
         * The classifier's observation.
         * </p>
         * 
         * @param observation
         *        The classifier's observation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observation(Observation observation);

        /**
         * <p>
         * The classifier's observation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Observation.Builder} avoiding the need to
         * create one manually via {@link Observation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Observation.Builder#build()} is called immediately and its result
         * is passed to {@link #observation(Observation)}.
         * 
         * @param observation
         *        a consumer that will call methods on {@link Observation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observation(Observation)
         */
        default Builder observation(Consumer<Observation.Builder> observation) {
            return observation(Observation.builder().applyMutation(observation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InvocationInput invocationInput;

        private ModelInvocationInput modelInvocationInput;

        private RoutingClassifierModelInvocationOutput modelInvocationOutput;

        private Observation observation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingClassifierTrace model) {
            invocationInput(model.invocationInput);
            modelInvocationInput(model.modelInvocationInput);
            modelInvocationOutput(model.modelInvocationOutput);
            observation(model.observation);
        }

        public final InvocationInput.Builder getInvocationInput() {
            return invocationInput != null ? invocationInput.toBuilder() : null;
        }

        public final void setInvocationInput(InvocationInput.BuilderImpl invocationInput) {
            Object oldValue = this.invocationInput;
            this.invocationInput = invocationInput != null ? invocationInput.build() : null;
            handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
        }

        @Override
        public final Builder invocationInput(InvocationInput invocationInput) {
            Object oldValue = this.invocationInput;
            this.invocationInput = invocationInput;
            handleUnionValueChange(Type.INVOCATION_INPUT, oldValue, this.invocationInput);
            return this;
        }

        public final ModelInvocationInput.Builder getModelInvocationInput() {
            return modelInvocationInput != null ? modelInvocationInput.toBuilder() : null;
        }

        public final void setModelInvocationInput(ModelInvocationInput.BuilderImpl modelInvocationInput) {
            Object oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput != null ? modelInvocationInput.build() : null;
            handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
        }

        @Override
        public final Builder modelInvocationInput(ModelInvocationInput modelInvocationInput) {
            Object oldValue = this.modelInvocationInput;
            this.modelInvocationInput = modelInvocationInput;
            handleUnionValueChange(Type.MODEL_INVOCATION_INPUT, oldValue, this.modelInvocationInput);
            return this;
        }

        public final RoutingClassifierModelInvocationOutput.Builder getModelInvocationOutput() {
            return modelInvocationOutput != null ? modelInvocationOutput.toBuilder() : null;
        }

        public final void setModelInvocationOutput(RoutingClassifierModelInvocationOutput.BuilderImpl modelInvocationOutput) {
            Object oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput != null ? modelInvocationOutput.build() : null;
            handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
        }

        @Override
        public final Builder modelInvocationOutput(RoutingClassifierModelInvocationOutput modelInvocationOutput) {
            Object oldValue = this.modelInvocationOutput;
            this.modelInvocationOutput = modelInvocationOutput;
            handleUnionValueChange(Type.MODEL_INVOCATION_OUTPUT, oldValue, this.modelInvocationOutput);
            return this;
        }

        public final Observation.Builder getObservation() {
            return observation != null ? observation.toBuilder() : null;
        }

        public final void setObservation(Observation.BuilderImpl observation) {
            Object oldValue = this.observation;
            this.observation = observation != null ? observation.build() : null;
            handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
        }

        @Override
        public final Builder observation(Observation observation) {
            Object oldValue = this.observation;
            this.observation = observation;
            handleUnionValueChange(Type.OBSERVATION, oldValue, this.observation);
            return this;
        }

        @Override
        public RoutingClassifierTrace build() {
            return new RoutingClassifierTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RoutingClassifierTrace#type()
     */
    public enum Type {
        INVOCATION_INPUT,

        MODEL_INVOCATION_INPUT,

        MODEL_INVOCATION_OUTPUT,

        OBSERVATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
