/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains parameters that specify various attributes that persist across a session or prompt. You can define session
 * state attributes as key-value pairs when writing a <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-lambda.html">Lambda function</a> for an action
 * group or pass them when making an <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
 * request. Use session state attributes to control and provide conversational context for your agent and to help
 * customize your agent's behavior. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session context</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionState implements SdkPojo, Serializable, ToCopyableBuilder<SessionState.Builder, SessionState> {
    private static final SdkField<ConversationHistory> CONVERSATION_HISTORY_FIELD = SdkField
            .<ConversationHistory> builder(MarshallingType.SDK_POJO).memberName("conversationHistory")
            .getter(getter(SessionState::conversationHistory)).setter(setter(Builder::conversationHistory))
            .constructor(ConversationHistory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationHistory").build())
            .build();

    private static final SdkField<List<InputFile>> FILES_FIELD = SdkField
            .<List<InputFile>> builder(MarshallingType.LIST)
            .memberName("files")
            .getter(getter(SessionState::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationId").getter(getter(SessionState::invocationId)).setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()).build();

    private static final SdkField<List<KnowledgeBaseConfiguration>> KNOWLEDGE_BASE_CONFIGURATIONS_FIELD = SdkField
            .<List<KnowledgeBaseConfiguration>> builder(MarshallingType.LIST)
            .memberName("knowledgeBaseConfigurations")
            .getter(getter(SessionState::knowledgeBaseConfigurations))
            .setter(setter(Builder::knowledgeBaseConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KnowledgeBaseConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(KnowledgeBaseConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PROMPT_SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("promptSessionAttributes")
            .getter(getter(SessionState::promptSessionAttributes))
            .setter(setter(Builder::promptSessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<InvocationResultMember>> RETURN_CONTROL_INVOCATION_RESULTS_FIELD = SdkField
            .<List<InvocationResultMember>> builder(MarshallingType.LIST)
            .memberName("returnControlInvocationResults")
            .getter(getter(SessionState::returnControlInvocationResults))
            .setter(setter(Builder::returnControlInvocationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlInvocationResults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvocationResultMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvocationResultMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionAttributes")
            .getter(getter(SessionState::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATION_HISTORY_FIELD,
            FILES_FIELD, INVOCATION_ID_FIELD, KNOWLEDGE_BASE_CONFIGURATIONS_FIELD, PROMPT_SESSION_ATTRIBUTES_FIELD,
            RETURN_CONTROL_INVOCATION_RESULTS_FIELD, SESSION_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConversationHistory conversationHistory;

    private final List<InputFile> files;

    private final String invocationId;

    private final List<KnowledgeBaseConfiguration> knowledgeBaseConfigurations;

    private final Map<String, String> promptSessionAttributes;

    private final List<InvocationResultMember> returnControlInvocationResults;

    private final Map<String, String> sessionAttributes;

    private SessionState(BuilderImpl builder) {
        this.conversationHistory = builder.conversationHistory;
        this.files = builder.files;
        this.invocationId = builder.invocationId;
        this.knowledgeBaseConfigurations = builder.knowledgeBaseConfigurations;
        this.promptSessionAttributes = builder.promptSessionAttributes;
        this.returnControlInvocationResults = builder.returnControlInvocationResults;
        this.sessionAttributes = builder.sessionAttributes;
    }

    /**
     * <p>
     * The state's conversation history.
     * </p>
     * 
     * @return The state's conversation history.
     */
    public final ConversationHistory conversationHistory() {
        return conversationHistory;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the files used by code interpreter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return Contains information about the files used by code interpreter.
     */
    public final List<InputFile> files() {
        return files;
    }

    /**
     * <p>
     * The identifier of the invocation of an action. This value must match the <code>invocationId</code> returned in
     * the <code>InvokeAgent</code> response for the action whose results are provided in the
     * <code>returnControlInvocationResults</code> field. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the agent
     * developer</a> and <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     * context</a>.
     * </p>
     * 
     * @return The identifier of the invocation of an action. This value must match the <code>invocationId</code>
     *         returned in the <code>InvokeAgent</code> response for the action whose results are provided in the
     *         <code>returnControlInvocationResults</code> field. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to
     *         the agent developer</a> and <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     *         context</a>.
     */
    public final String invocationId() {
        return invocationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the KnowledgeBaseConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasKnowledgeBaseConfigurations() {
        return knowledgeBaseConfigurations != null && !(knowledgeBaseConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of configurations, each of which applies to a knowledge base attached to the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKnowledgeBaseConfigurations} method.
     * </p>
     * 
     * @return An array of configurations, each of which applies to a knowledge base attached to the agent.
     */
    public final List<KnowledgeBaseConfiguration> knowledgeBaseConfigurations() {
        return knowledgeBaseConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the PromptSessionAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPromptSessionAttributes() {
        return promptSessionAttributes != null && !(promptSessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains attributes that persist across a prompt and the values of those attributes. These attributes replace the
     * $prompt_session_attributes$ placeholder variable in the orchestration prompt template. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template
     * placeholder variables</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPromptSessionAttributes} method.
     * </p>
     * 
     * @return Contains attributes that persist across a prompt and the values of those attributes. These attributes
     *         replace the $prompt_session_attributes$ placeholder variable in the orchestration prompt template. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template
     *         placeholder variables</a>.
     */
    public final Map<String, String> promptSessionAttributes() {
        return promptSessionAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReturnControlInvocationResults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReturnControlInvocationResults() {
        return returnControlInvocationResults != null && !(returnControlInvocationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the results from the action group invocation. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the agent
     * developer</a> and <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     * context</a>.
     * </p>
     * <note>
     * <p>
     * If you include this field, the <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReturnControlInvocationResults} method.
     * </p>
     * 
     * @return Contains information about the results from the action group invocation. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to
     *         the agent developer</a> and <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     *         context</a>.</p> <note>
     *         <p>
     *         If you include this field, the <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final List<InvocationResultMember> returnControlInvocationResults() {
        return returnControlInvocationResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains attributes that persist across a session and the values of those attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionAttributes} method.
     * </p>
     * 
     * @return Contains attributes that persist across a session and the values of those attributes.
     */
    public final Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversationHistory());
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasKnowledgeBaseConfigurations() ? knowledgeBaseConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPromptSessionAttributes() ? promptSessionAttributes() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReturnControlInvocationResults() ? returnControlInvocationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionAttributes() ? sessionAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionState)) {
            return false;
        }
        SessionState other = (SessionState) obj;
        return Objects.equals(conversationHistory(), other.conversationHistory()) && hasFiles() == other.hasFiles()
                && Objects.equals(files(), other.files()) && Objects.equals(invocationId(), other.invocationId())
                && hasKnowledgeBaseConfigurations() == other.hasKnowledgeBaseConfigurations()
                && Objects.equals(knowledgeBaseConfigurations(), other.knowledgeBaseConfigurations())
                && hasPromptSessionAttributes() == other.hasPromptSessionAttributes()
                && Objects.equals(promptSessionAttributes(), other.promptSessionAttributes())
                && hasReturnControlInvocationResults() == other.hasReturnControlInvocationResults()
                && Objects.equals(returnControlInvocationResults(), other.returnControlInvocationResults())
                && hasSessionAttributes() == other.hasSessionAttributes()
                && Objects.equals(sessionAttributes(), other.sessionAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SessionState")
                .add("ConversationHistory", conversationHistory())
                .add("Files", hasFiles() ? files() : null)
                .add("InvocationId", invocationId())
                .add("KnowledgeBaseConfigurations", hasKnowledgeBaseConfigurations() ? knowledgeBaseConfigurations() : null)
                .add("PromptSessionAttributes", hasPromptSessionAttributes() ? promptSessionAttributes() : null)
                .add("ReturnControlInvocationResults",
                        hasReturnControlInvocationResults() ? returnControlInvocationResults() : null)
                .add("SessionAttributes", hasSessionAttributes() ? sessionAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversationHistory":
            return Optional.ofNullable(clazz.cast(conversationHistory()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "invocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        case "knowledgeBaseConfigurations":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfigurations()));
        case "promptSessionAttributes":
            return Optional.ofNullable(clazz.cast(promptSessionAttributes()));
        case "returnControlInvocationResults":
            return Optional.ofNullable(clazz.cast(returnControlInvocationResults()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversationHistory", CONVERSATION_HISTORY_FIELD);
        map.put("files", FILES_FIELD);
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("knowledgeBaseConfigurations", KNOWLEDGE_BASE_CONFIGURATIONS_FIELD);
        map.put("promptSessionAttributes", PROMPT_SESSION_ATTRIBUTES_FIELD);
        map.put("returnControlInvocationResults", RETURN_CONTROL_INVOCATION_RESULTS_FIELD);
        map.put("sessionAttributes", SESSION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionState, T> g) {
        return obj -> g.apply((SessionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionState> {
        /**
         * <p>
         * The state's conversation history.
         * </p>
         * 
         * @param conversationHistory
         *        The state's conversation history.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationHistory(ConversationHistory conversationHistory);

        /**
         * <p>
         * The state's conversation history.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversationHistory.Builder} avoiding the
         * need to create one manually via {@link ConversationHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversationHistory.Builder#build()} is called immediately and
         * its result is passed to {@link #conversationHistory(ConversationHistory)}.
         * 
         * @param conversationHistory
         *        a consumer that will call methods on {@link ConversationHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversationHistory(ConversationHistory)
         */
        default Builder conversationHistory(Consumer<ConversationHistory.Builder> conversationHistory) {
            return conversationHistory(ConversationHistory.builder().applyMutation(conversationHistory).build());
        }

        /**
         * <p>
         * Contains information about the files used by code interpreter.
         * </p>
         * 
         * @param files
         *        Contains information about the files used by code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<InputFile> files);

        /**
         * <p>
         * Contains information about the files used by code interpreter.
         * </p>
         * 
         * @param files
         *        Contains information about the files used by code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(InputFile... files);

        /**
         * <p>
         * Contains information about the files used by code interpreter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InputFile.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrockagentruntime.model.InputFile#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InputFile.Builder#build()} is called
         * immediately and its result is passed to {@link #files(List<InputFile>)}.
         * 
         * @param files
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InputFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(java.util.Collection<InputFile>)
         */
        Builder files(Consumer<InputFile.Builder>... files);

        /**
         * <p>
         * The identifier of the invocation of an action. This value must match the <code>invocationId</code> returned
         * in the <code>InvokeAgent</code> response for the action whose results are provided in the
         * <code>returnControlInvocationResults</code> field. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the
         * agent developer</a> and <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * 
         * @param invocationId
         *        The identifier of the invocation of an action. This value must match the <code>invocationId</code>
         *        returned in the <code>InvokeAgent</code> response for the action whose results are provided in the
         *        <code>returnControlInvocationResults</code> field. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control
         *        to the agent developer</a> and <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         *        context</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        /**
         * <p>
         * An array of configurations, each of which applies to a knowledge base attached to the agent.
         * </p>
         * 
         * @param knowledgeBaseConfigurations
         *        An array of configurations, each of which applies to a knowledge base attached to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfigurations(Collection<KnowledgeBaseConfiguration> knowledgeBaseConfigurations);

        /**
         * <p>
         * An array of configurations, each of which applies to a knowledge base attached to the agent.
         * </p>
         * 
         * @param knowledgeBaseConfigurations
         *        An array of configurations, each of which applies to a knowledge base attached to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfigurations(KnowledgeBaseConfiguration... knowledgeBaseConfigurations);

        /**
         * <p>
         * An array of configurations, each of which applies to a knowledge base attached to the agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #knowledgeBaseConfigurations(List<KnowledgeBaseConfiguration>)}.
         * 
         * @param knowledgeBaseConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfigurations(java.util.Collection<KnowledgeBaseConfiguration>)
         */
        Builder knowledgeBaseConfigurations(Consumer<KnowledgeBaseConfiguration.Builder>... knowledgeBaseConfigurations);

        /**
         * <p>
         * Contains attributes that persist across a prompt and the values of those attributes. These attributes replace
         * the $prompt_session_attributes$ placeholder variable in the orchestration prompt template. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template
         * placeholder variables</a>.
         * </p>
         * 
         * @param promptSessionAttributes
         *        Contains attributes that persist across a prompt and the values of those attributes. These attributes
         *        replace the $prompt_session_attributes$ placeholder variable in the orchestration prompt template. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Prompt template
         *        placeholder variables</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSessionAttributes(Map<String, String> promptSessionAttributes);

        /**
         * <p>
         * Contains information about the results from the action group invocation. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the
         * agent developer</a> and <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include this field, the <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param returnControlInvocationResults
         *        Contains information about the results from the action group invocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control
         *        to the agent developer</a> and <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         *        context</a>.</p> <note>
         *        <p>
         *        If you include this field, the <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnControlInvocationResults(Collection<InvocationResultMember> returnControlInvocationResults);

        /**
         * <p>
         * Contains information about the results from the action group invocation. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the
         * agent developer</a> and <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include this field, the <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param returnControlInvocationResults
         *        Contains information about the results from the action group invocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control
         *        to the agent developer</a> and <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         *        context</a>.</p> <note>
         *        <p>
         *        If you include this field, the <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnControlInvocationResults(InvocationResultMember... returnControlInvocationResults);

        /**
         * <p>
         * Contains information about the results from the action group invocation. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html">Return control to the
         * agent developer</a> and <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include this field, the <code>inputText</code> field will be ignored.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #returnControlInvocationResults(List<InvocationResultMember>)}.
         * 
         * @param returnControlInvocationResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnControlInvocationResults(java.util.Collection<InvocationResultMember>)
         */
        Builder returnControlInvocationResults(Consumer<InvocationResultMember.Builder>... returnControlInvocationResults);

        /**
         * <p>
         * Contains attributes that persist across a session and the values of those attributes.
         * </p>
         * 
         * @param sessionAttributes
         *        Contains attributes that persist across a session and the values of those attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);
    }

    static final class BuilderImpl implements Builder {
        private ConversationHistory conversationHistory;

        private List<InputFile> files = DefaultSdkAutoConstructList.getInstance();

        private String invocationId;

        private List<KnowledgeBaseConfiguration> knowledgeBaseConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> promptSessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private List<InvocationResultMember> returnControlInvocationResults = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SessionState model) {
            conversationHistory(model.conversationHistory);
            files(model.files);
            invocationId(model.invocationId);
            knowledgeBaseConfigurations(model.knowledgeBaseConfigurations);
            promptSessionAttributes(model.promptSessionAttributes);
            returnControlInvocationResults(model.returnControlInvocationResults);
            sessionAttributes(model.sessionAttributes);
        }

        public final ConversationHistory.Builder getConversationHistory() {
            return conversationHistory != null ? conversationHistory.toBuilder() : null;
        }

        public final void setConversationHistory(ConversationHistory.BuilderImpl conversationHistory) {
            this.conversationHistory = conversationHistory != null ? conversationHistory.build() : null;
        }

        @Override
        public final Builder conversationHistory(ConversationHistory conversationHistory) {
            this.conversationHistory = conversationHistory;
            return this;
        }

        public final List<InputFile.Builder> getFiles() {
            List<InputFile.Builder> result = InputFilesCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<InputFile.BuilderImpl> files) {
            this.files = InputFilesCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<InputFile> files) {
            this.files = InputFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(InputFile... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<InputFile.Builder>... files) {
            files(Stream.of(files).map(c -> InputFile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final List<KnowledgeBaseConfiguration.Builder> getKnowledgeBaseConfigurations() {
            List<KnowledgeBaseConfiguration.Builder> result = KnowledgeBaseConfigurationsCopier
                    .copyToBuilder(this.knowledgeBaseConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKnowledgeBaseConfigurations(
                Collection<KnowledgeBaseConfiguration.BuilderImpl> knowledgeBaseConfigurations) {
            this.knowledgeBaseConfigurations = KnowledgeBaseConfigurationsCopier.copyFromBuilder(knowledgeBaseConfigurations);
        }

        @Override
        public final Builder knowledgeBaseConfigurations(Collection<KnowledgeBaseConfiguration> knowledgeBaseConfigurations) {
            this.knowledgeBaseConfigurations = KnowledgeBaseConfigurationsCopier.copy(knowledgeBaseConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBaseConfigurations(KnowledgeBaseConfiguration... knowledgeBaseConfigurations) {
            knowledgeBaseConfigurations(Arrays.asList(knowledgeBaseConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBaseConfigurations(
                Consumer<KnowledgeBaseConfiguration.Builder>... knowledgeBaseConfigurations) {
            knowledgeBaseConfigurations(Stream.of(knowledgeBaseConfigurations)
                    .map(c -> KnowledgeBaseConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getPromptSessionAttributes() {
            if (promptSessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return promptSessionAttributes;
        }

        public final void setPromptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
        }

        @Override
        public final Builder promptSessionAttributes(Map<String, String> promptSessionAttributes) {
            this.promptSessionAttributes = PromptSessionAttributesMapCopier.copy(promptSessionAttributes);
            return this;
        }

        public final List<InvocationResultMember.Builder> getReturnControlInvocationResults() {
            List<InvocationResultMember.Builder> result = ReturnControlInvocationResultsCopier
                    .copyToBuilder(this.returnControlInvocationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReturnControlInvocationResults(
                Collection<InvocationResultMember.BuilderImpl> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier
                    .copyFromBuilder(returnControlInvocationResults);
        }

        @Override
        public final Builder returnControlInvocationResults(Collection<InvocationResultMember> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier.copy(returnControlInvocationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(InvocationResultMember... returnControlInvocationResults) {
            returnControlInvocationResults(Arrays.asList(returnControlInvocationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(
                Consumer<InvocationResultMember.Builder>... returnControlInvocationResults) {
            returnControlInvocationResults(Stream.of(returnControlInvocationResults)
                    .map(c -> InvocationResultMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = SessionAttributesMapCopier.copy(sessionAttributes);
            return this;
        }

        @Override
        public SessionState build() {
            return new SessionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
