/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the agent and session, alongside the agent's reasoning process and results from calling
 * API actions and querying knowledge bases and metadata about the trace. You can use the trace to understand how the
 * agent arrived at the response it provided the customer. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace enablement</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TracePart implements SdkPojo, Serializable, ToCopyableBuilder<TracePart.Builder, TracePart>, ResponseStream {
    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(TracePart::agentAliasId)).setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasId").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(TracePart::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(TracePart::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<List<Caller>> CALLER_CHAIN_FIELD = SdkField
            .<List<Caller>> builder(MarshallingType.LIST)
            .memberName("callerChain")
            .getter(getter(TracePart::callerChain))
            .setter(setter(Builder::callerChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerChain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Caller> builder(MarshallingType.SDK_POJO)
                                            .constructor(Caller::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorName").getter(getter(TracePart::collaboratorName)).setter(setter(Builder::collaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(TracePart::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Trace> TRACE_FIELD = SdkField.<Trace> builder(MarshallingType.SDK_POJO).memberName("trace")
            .getter(getter(TracePart::trace)).setter(setter(Builder::trace)).constructor(Trace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_ID_FIELD,
            AGENT_ID_FIELD, AGENT_VERSION_FIELD, CALLER_CHAIN_FIELD, COLLABORATOR_NAME_FIELD, SESSION_ID_FIELD, TRACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentAliasId;

    private final String agentId;

    private final String agentVersion;

    private final List<Caller> callerChain;

    private final String collaboratorName;

    private final String sessionId;

    private final Trace trace;

    protected TracePart(BuilderImpl builder) {
        this.agentAliasId = builder.agentAliasId;
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.callerChain = builder.callerChain;
        this.collaboratorName = builder.collaboratorName;
        this.sessionId = builder.sessionId;
        this.trace = builder.trace;
    }

    /**
     * <p>
     * The unique identifier of the alias of the agent.
     * </p>
     * 
     * @return The unique identifier of the alias of the agent.
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * <p>
     * The unique identifier of the agent.
     * </p>
     * 
     * @return The unique identifier of the agent.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The version of the agent.
     * </p>
     * 
     * @return The version of the agent.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the CallerChain property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCallerChain() {
        return callerChain != null && !(callerChain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The part's caller chain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCallerChain} method.
     * </p>
     * 
     * @return The part's caller chain.
     */
    public final List<Caller> callerChain() {
        return callerChain;
    }

    /**
     * <p>
     * The part's collaborator name.
     * </p>
     * 
     * @return The part's collaborator name.
     */
    public final String collaboratorName() {
        return collaboratorName;
    }

    /**
     * <p>
     * The unique identifier of the session with the agent.
     * </p>
     * 
     * @return The unique identifier of the session with the agent.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Contains one part of the agent's reasoning process and results from calling API actions and querying knowledge
     * bases. You can use the trace to understand how the agent arrived at the response it provided the customer. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
     * enablement</a>.
     * </p>
     * 
     * @return Contains one part of the agent's reasoning process and results from calling API actions and querying
     *         knowledge bases. You can use the trace to understand how the agent arrived at the response it provided
     *         the customer. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
     *         enablement</a>.
     */
    public final Trace trace() {
        return trace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallerChain() ? callerChain() : null);
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(trace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracePart)) {
            return false;
        }
        TracePart other = (TracePart) obj;
        return Objects.equals(agentAliasId(), other.agentAliasId()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(agentVersion(), other.agentVersion()) && hasCallerChain() == other.hasCallerChain()
                && Objects.equals(callerChain(), other.callerChain())
                && Objects.equals(collaboratorName(), other.collaboratorName()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(trace(), other.trace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TracePart").add("AgentAliasId", agentAliasId()).add("AgentId", agentId())
                .add("AgentVersion", agentVersion()).add("CallerChain", hasCallerChain() ? callerChain() : null)
                .add("CollaboratorName", collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionId", sessionId()).add("Trace", trace() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "callerChain":
            return Optional.ofNullable(clazz.cast(callerChain()));
        case "collaboratorName":
            return Optional.ofNullable(clazz.cast(collaboratorName()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "trace":
            return Optional.ofNullable(clazz.cast(trace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final TracePart copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentAliasId", AGENT_ALIAS_ID_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("callerChain", CALLER_CHAIN_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("trace", TRACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TracePart, T> g) {
        return obj -> g.apply((TracePart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link TracePart}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeAgentResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TracePart> {
        /**
         * <p>
         * The unique identifier of the alias of the agent.
         * </p>
         * 
         * @param agentAliasId
         *        The unique identifier of the alias of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * <p>
         * The unique identifier of the agent.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The version of the agent.
         * </p>
         * 
         * @param agentVersion
         *        The version of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The part's caller chain.
         * </p>
         * 
         * @param callerChain
         *        The part's caller chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerChain(Collection<Caller> callerChain);

        /**
         * <p>
         * The part's caller chain.
         * </p>
         * 
         * @param callerChain
         *        The part's caller chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerChain(Caller... callerChain);

        /**
         * <p>
         * The part's caller chain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Caller.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagentruntime.model.Caller#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.Caller.Builder#build()} is called
         * immediately and its result is passed to {@link #callerChain(List<Caller>)}.
         * 
         * @param callerChain
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.Caller.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #callerChain(java.util.Collection<Caller>)
         */
        Builder callerChain(Consumer<Caller.Builder>... callerChain);

        /**
         * <p>
         * The part's collaborator name.
         * </p>
         * 
         * @param collaboratorName
         *        The part's collaborator name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorName(String collaboratorName);

        /**
         * <p>
         * The unique identifier of the session with the agent.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session with the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Contains one part of the agent's reasoning process and results from calling API actions and querying
         * knowledge bases. You can use the trace to understand how the agent arrived at the response it provided the
         * customer. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
         * enablement</a>.
         * </p>
         * 
         * @param trace
         *        Contains one part of the agent's reasoning process and results from calling API actions and querying
         *        knowledge bases. You can use the trace to understand how the agent arrived at the response it provided
         *        the customer. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
         *        enablement</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trace(Trace trace);

        /**
         * <p>
         * Contains one part of the agent's reasoning process and results from calling API actions and querying
         * knowledge bases. You can use the trace to understand how the agent arrived at the response it provided the
         * customer. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-enablement">Trace
         * enablement</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Trace.Builder} avoiding the need to
         * create one manually via {@link Trace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Trace.Builder#build()} is called immediately and its result is
         * passed to {@link #trace(Trace)}.
         * 
         * @param trace
         *        a consumer that will call methods on {@link Trace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trace(Trace)
         */
        default Builder trace(Consumer<Trace.Builder> trace) {
            return trace(Trace.builder().applyMutation(trace).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String agentAliasId;

        private String agentId;

        private String agentVersion;

        private List<Caller> callerChain = DefaultSdkAutoConstructList.getInstance();

        private String collaboratorName;

        private String sessionId;

        private Trace trace;

        protected BuilderImpl() {
        }

        protected BuilderImpl(TracePart model) {
            agentAliasId(model.agentAliasId);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            callerChain(model.callerChain);
            collaboratorName(model.collaboratorName);
            sessionId(model.sessionId);
            trace(model.trace);
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final List<Caller.Builder> getCallerChain() {
            List<Caller.Builder> result = CallerChainCopier.copyToBuilder(this.callerChain);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCallerChain(Collection<Caller.BuilderImpl> callerChain) {
            this.callerChain = CallerChainCopier.copyFromBuilder(callerChain);
        }

        @Override
        public final Builder callerChain(Collection<Caller> callerChain) {
            this.callerChain = CallerChainCopier.copy(callerChain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerChain(Caller... callerChain) {
            callerChain(Arrays.asList(callerChain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerChain(Consumer<Caller.Builder>... callerChain) {
            callerChain(Stream.of(callerChain).map(c -> Caller.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCollaboratorName() {
            return collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Trace.Builder getTrace() {
            return trace != null ? trace.toBuilder() : null;
        }

        public final void setTrace(Trace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public TracePart build() {
            return new TracePart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
