/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for reranking the retrieved results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorSearchRerankingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorSearchRerankingConfiguration.Builder, VectorSearchRerankingConfiguration> {
    private static final SdkField<VectorSearchBedrockRerankingConfiguration> BEDROCK_RERANKING_CONFIGURATION_FIELD = SdkField
            .<VectorSearchBedrockRerankingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockRerankingConfiguration")
            .getter(getter(VectorSearchRerankingConfiguration::bedrockRerankingConfiguration))
            .setter(setter(Builder::bedrockRerankingConfiguration))
            .constructor(VectorSearchBedrockRerankingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockRerankingConfiguration")
                    .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(VectorSearchRerankingConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_RERANKING_CONFIGURATION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VectorSearchBedrockRerankingConfiguration bedrockRerankingConfiguration;

    private final String type;

    private VectorSearchRerankingConfiguration(BuilderImpl builder) {
        this.bedrockRerankingConfiguration = builder.bedrockRerankingConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configurations for an Amazon Bedrock reranker model.
     * </p>
     * 
     * @return Contains configurations for an Amazon Bedrock reranker model.
     */
    public final VectorSearchBedrockRerankingConfiguration bedrockRerankingConfiguration() {
        return bedrockRerankingConfiguration;
    }

    /**
     * <p>
     * The type of reranker model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link VectorSearchRerankingConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of reranker model.
     * @see VectorSearchRerankingConfigurationType
     */
    public final VectorSearchRerankingConfigurationType type() {
        return VectorSearchRerankingConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of reranker model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link VectorSearchRerankingConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of reranker model.
     * @see VectorSearchRerankingConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockRerankingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorSearchRerankingConfiguration)) {
            return false;
        }
        VectorSearchRerankingConfiguration other = (VectorSearchRerankingConfiguration) obj;
        return Objects.equals(bedrockRerankingConfiguration(), other.bedrockRerankingConfiguration())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorSearchRerankingConfiguration")
                .add("BedrockRerankingConfiguration", bedrockRerankingConfiguration()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockRerankingConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockRerankingConfiguration()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockRerankingConfiguration", BEDROCK_RERANKING_CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorSearchRerankingConfiguration, T> g) {
        return obj -> g.apply((VectorSearchRerankingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorSearchRerankingConfiguration> {
        /**
         * <p>
         * Contains configurations for an Amazon Bedrock reranker model.
         * </p>
         * 
         * @param bedrockRerankingConfiguration
         *        Contains configurations for an Amazon Bedrock reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfiguration bedrockRerankingConfiguration);

        /**
         * <p>
         * Contains configurations for an Amazon Bedrock reranker model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VectorSearchBedrockRerankingConfiguration.Builder} avoiding the need to create one manually via
         * {@link VectorSearchBedrockRerankingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorSearchBedrockRerankingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfiguration)}.
         * 
         * @param bedrockRerankingConfiguration
         *        a consumer that will call methods on {@link VectorSearchBedrockRerankingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfiguration)
         */
        default Builder bedrockRerankingConfiguration(
                Consumer<VectorSearchBedrockRerankingConfiguration.Builder> bedrockRerankingConfiguration) {
            return bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfiguration.builder()
                    .applyMutation(bedrockRerankingConfiguration).build());
        }

        /**
         * <p>
         * The type of reranker model.
         * </p>
         * 
         * @param type
         *        The type of reranker model.
         * @see VectorSearchRerankingConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorSearchRerankingConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of reranker model.
         * </p>
         * 
         * @param type
         *        The type of reranker model.
         * @see VectorSearchRerankingConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VectorSearchRerankingConfigurationType
         */
        Builder type(VectorSearchRerankingConfigurationType type);
    }

    static final class BuilderImpl implements Builder {
        private VectorSearchBedrockRerankingConfiguration bedrockRerankingConfiguration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorSearchRerankingConfiguration model) {
            bedrockRerankingConfiguration(model.bedrockRerankingConfiguration);
            type(model.type);
        }

        public final VectorSearchBedrockRerankingConfiguration.Builder getBedrockRerankingConfiguration() {
            return bedrockRerankingConfiguration != null ? bedrockRerankingConfiguration.toBuilder() : null;
        }

        public final void setBedrockRerankingConfiguration(
                VectorSearchBedrockRerankingConfiguration.BuilderImpl bedrockRerankingConfiguration) {
            this.bedrockRerankingConfiguration = bedrockRerankingConfiguration != null ? bedrockRerankingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfiguration bedrockRerankingConfiguration) {
            this.bedrockRerankingConfiguration = bedrockRerankingConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(VectorSearchRerankingConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public VectorSearchRerankingConfiguration build() {
            return new VectorSearchRerankingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
