/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRetrieveAndGenerateStreamVisitorBuilder implements RetrieveAndGenerateStreamResponseHandler.Visitor.Builder {
    private Consumer<RetrieveAndGenerateStreamResponseOutput> onDefault;

    private Consumer<CitationEvent> onCitation;

    private Consumer<GuardrailEvent> onGuardrail;

    private Consumer<RetrieveAndGenerateOutputEvent> onOutput;

    @Override
    public RetrieveAndGenerateStreamResponseHandler.Visitor.Builder onDefault(Consumer<RetrieveAndGenerateStreamResponseOutput> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public RetrieveAndGenerateStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public RetrieveAndGenerateStreamResponseHandler.Visitor.Builder onCitation(Consumer<CitationEvent> c) {
        this.onCitation = c;
        return this;
    }

    @Override
    public RetrieveAndGenerateStreamResponseHandler.Visitor.Builder onGuardrail(Consumer<GuardrailEvent> c) {
        this.onGuardrail = c;
        return this;
    }

    @Override
    public RetrieveAndGenerateStreamResponseHandler.Visitor.Builder onOutput(Consumer<RetrieveAndGenerateOutputEvent> c) {
        this.onOutput = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements RetrieveAndGenerateStreamResponseHandler.Visitor {
        private final Consumer<RetrieveAndGenerateStreamResponseOutput> onDefault;

        private final Consumer<CitationEvent> onCitation;

        private final Consumer<GuardrailEvent> onGuardrail;

        private final Consumer<RetrieveAndGenerateOutputEvent> onOutput;

        VisitorFromBuilder(DefaultRetrieveAndGenerateStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : RetrieveAndGenerateStreamResponseHandler.Visitor.super::visitDefault;
            this.onCitation = builder.onCitation != null ? builder.onCitation
                    : RetrieveAndGenerateStreamResponseHandler.Visitor.super::visitCitation;
            this.onGuardrail = builder.onGuardrail != null ? builder.onGuardrail
                    : RetrieveAndGenerateStreamResponseHandler.Visitor.super::visitGuardrail;
            this.onOutput = builder.onOutput != null ? builder.onOutput
                    : RetrieveAndGenerateStreamResponseHandler.Visitor.super::visitOutput;
        }

        @Override
        public void visitDefault(RetrieveAndGenerateStreamResponseOutput event) {
            onDefault.accept(event);
        }

        @Override
        public void visitCitation(CitationEvent event) {
            onCitation.accept(event);
        }

        @Override
        public void visitGuardrail(GuardrailEvent event) {
            onGuardrail.accept(event);
        }

        @Override
        public void visitOutput(RetrieveAndGenerateOutputEvent event) {
            onOutput.accept(event);
        }
    }
}
