/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifications about the inference parameters that were provided alongside the prompt. These are specified in the <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html">
 * PromptOverrideConfiguration</a> object that was set when the agent was created or updated. For more information, see
 * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for
 * foundation models</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceConfiguration.Builder, InferenceConfiguration> {
    private static final SdkField<Integer> MAXIMUM_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumLength").getter(getter(InferenceConfiguration::maximumLength))
            .setter(setter(Builder::maximumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumLength").build()).build();

    private static final SdkField<List<String>> STOP_SEQUENCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stopSequences")
            .getter(getter(InferenceConfiguration::stopSequences))
            .setter(setter(Builder::stopSequences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopSequences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("temperature").getter(getter(InferenceConfiguration::temperature)).setter(setter(Builder::temperature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()).build();

    private static final SdkField<Integer> TOPK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("topK")
            .getter(getter(InferenceConfiguration::topK)).setter(setter(Builder::topK))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topK").build()).build();

    private static final SdkField<Float> TOPP_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("topP")
            .getter(getter(InferenceConfiguration::topP)).setter(setter(Builder::topP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_LENGTH_FIELD,
            STOP_SEQUENCES_FIELD, TEMPERATURE_FIELD, TOPK_FIELD, TOPP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximumLength;

    private final List<String> stopSequences;

    private final Float temperature;

    private final Integer topK;

    private final Float topP;

    private InferenceConfiguration(BuilderImpl builder) {
        this.maximumLength = builder.maximumLength;
        this.stopSequences = builder.stopSequences;
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.topP = builder.topP;
    }

    /**
     * <p>
     * The maximum number of tokens allowed in the generated response.
     * </p>
     * 
     * @return The maximum number of tokens allowed in the generated response.
     */
    public final Integer maximumLength() {
        return maximumLength;
    }

    /**
     * For responses, this returns true if the service returned a value for the StopSequences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStopSequences() {
        return stopSequences != null && !(stopSequences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating
     * the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStopSequences} method.
     * </p>
     * 
     * @return A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop
     *         generating the response.
     */
    public final List<String> stopSequences() {
        return stopSequences;
    }

    /**
     * <p>
     * The likelihood of the model selecting higher-probability options while generating a response. A lower value makes
     * the model more likely to choose higher-probability options, while a higher value makes the model more likely to
     * choose lower-probability options.
     * </p>
     * 
     * @return The likelihood of the model selecting higher-probability options while generating a response. A lower
     *         value makes the model more likely to choose higher-probability options, while a higher value makes the
     *         model more likely to choose lower-probability options.
     */
    public final Float temperature() {
        return temperature;
    }

    /**
     * <p>
     * While generating a response, the model determines the probability of the following token at each point of
     * generation. The value that you set for <code>topK</code> is the number of most-likely candidates from which the
     * model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50, the model selects
     * the next token from among the top 50 most likely choices.
     * </p>
     * 
     * @return While generating a response, the model determines the probability of the following token at each point of
     *         generation. The value that you set for <code>topK</code> is the number of most-likely candidates from
     *         which the model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50,
     *         the model selects the next token from among the top 50 most likely choices.
     */
    public final Integer topK() {
        return topK;
    }

    /**
     * <p>
     * While generating a response, the model determines the probability of the following token at each point of
     * generation. The value that you set for <code>Top P</code> determines the number of most-likely candidates from
     * which the model chooses the next token in the sequence. For example, if you set <code>topP</code> to 0.8, the
     * model only selects the next token from the top 80% of the probability distribution of next tokens.
     * </p>
     * 
     * @return While generating a response, the model determines the probability of the following token at each point of
     *         generation. The value that you set for <code>Top P</code> determines the number of most-likely candidates
     *         from which the model chooses the next token in the sequence. For example, if you set <code>topP</code> to
     *         0.8, the model only selects the next token from the top 80% of the probability distribution of next
     *         tokens.
     */
    public final Float topP() {
        return topP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumLength());
        hashCode = 31 * hashCode + Objects.hashCode(hasStopSequences() ? stopSequences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(temperature());
        hashCode = 31 * hashCode + Objects.hashCode(topK());
        hashCode = 31 * hashCode + Objects.hashCode(topP());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceConfiguration)) {
            return false;
        }
        InferenceConfiguration other = (InferenceConfiguration) obj;
        return Objects.equals(maximumLength(), other.maximumLength()) && hasStopSequences() == other.hasStopSequences()
                && Objects.equals(stopSequences(), other.stopSequences()) && Objects.equals(temperature(), other.temperature())
                && Objects.equals(topK(), other.topK()) && Objects.equals(topP(), other.topP());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceConfiguration").add("MaximumLength", maximumLength())
                .add("StopSequences", hasStopSequences() ? stopSequences() : null).add("Temperature", temperature())
                .add("TopK", topK()).add("TopP", topP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumLength":
            return Optional.ofNullable(clazz.cast(maximumLength()));
        case "stopSequences":
            return Optional.ofNullable(clazz.cast(stopSequences()));
        case "temperature":
            return Optional.ofNullable(clazz.cast(temperature()));
        case "topK":
            return Optional.ofNullable(clazz.cast(topK()));
        case "topP":
            return Optional.ofNullable(clazz.cast(topP()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maximumLength", MAXIMUM_LENGTH_FIELD);
        map.put("stopSequences", STOP_SEQUENCES_FIELD);
        map.put("temperature", TEMPERATURE_FIELD);
        map.put("topK", TOPK_FIELD);
        map.put("topP", TOPP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceConfiguration, T> g) {
        return obj -> g.apply((InferenceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceConfiguration> {
        /**
         * <p>
         * The maximum number of tokens allowed in the generated response.
         * </p>
         * 
         * @param maximumLength
         *        The maximum number of tokens allowed in the generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumLength(Integer maximumLength);

        /**
         * <p>
         * A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop
         * generating the response.
         * </p>
         * 
         * @param stopSequences
         *        A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop
         *        generating the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopSequences(Collection<String> stopSequences);

        /**
         * <p>
         * A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop
         * generating the response.
         * </p>
         * 
         * @param stopSequences
         *        A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop
         *        generating the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopSequences(String... stopSequences);

        /**
         * <p>
         * The likelihood of the model selecting higher-probability options while generating a response. A lower value
         * makes the model more likely to choose higher-probability options, while a higher value makes the model more
         * likely to choose lower-probability options.
         * </p>
         * 
         * @param temperature
         *        The likelihood of the model selecting higher-probability options while generating a response. A lower
         *        value makes the model more likely to choose higher-probability options, while a higher value makes the
         *        model more likely to choose lower-probability options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temperature(Float temperature);

        /**
         * <p>
         * While generating a response, the model determines the probability of the following token at each point of
         * generation. The value that you set for <code>topK</code> is the number of most-likely candidates from which
         * the model chooses the next token in the sequence. For example, if you set <code>topK</code> to 50, the model
         * selects the next token from among the top 50 most likely choices.
         * </p>
         * 
         * @param topK
         *        While generating a response, the model determines the probability of the following token at each point
         *        of generation. The value that you set for <code>topK</code> is the number of most-likely candidates
         *        from which the model chooses the next token in the sequence. For example, if you set <code>topK</code>
         *        to 50, the model selects the next token from among the top 50 most likely choices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topK(Integer topK);

        /**
         * <p>
         * While generating a response, the model determines the probability of the following token at each point of
         * generation. The value that you set for <code>Top P</code> determines the number of most-likely candidates
         * from which the model chooses the next token in the sequence. For example, if you set <code>topP</code> to
         * 0.8, the model only selects the next token from the top 80% of the probability distribution of next tokens.
         * </p>
         * 
         * @param topP
         *        While generating a response, the model determines the probability of the following token at each point
         *        of generation. The value that you set for <code>Top P</code> determines the number of most-likely
         *        candidates from which the model chooses the next token in the sequence. For example, if you set
         *        <code>topP</code> to 0.8, the model only selects the next token from the top 80% of the probability
         *        distribution of next tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topP(Float topP);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumLength;

        private List<String> stopSequences = DefaultSdkAutoConstructList.getInstance();

        private Float temperature;

        private Integer topK;

        private Float topP;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceConfiguration model) {
            maximumLength(model.maximumLength);
            stopSequences(model.stopSequences);
            temperature(model.temperature);
            topK(model.topK);
            topP(model.topP);
        }

        public final Integer getMaximumLength() {
            return maximumLength;
        }

        public final void setMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public final Collection<String> getStopSequences() {
            if (stopSequences instanceof SdkAutoConstructList) {
                return null;
            }
            return stopSequences;
        }

        public final void setStopSequences(Collection<String> stopSequences) {
            this.stopSequences = StopSequencesCopier.copy(stopSequences);
        }

        @Override
        public final Builder stopSequences(Collection<String> stopSequences) {
            this.stopSequences = StopSequencesCopier.copy(stopSequences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopSequences(String... stopSequences) {
            stopSequences(Arrays.asList(stopSequences));
            return this;
        }

        public final Float getTemperature() {
            return temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Integer getTopK() {
            return topK;
        }

        public final void setTopK(Integer topK) {
            this.topK = topK;
        }

        @Override
        public final Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public final Float getTopP() {
            return topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        @Override
        public InferenceConfiguration build() {
            return new InferenceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
