/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeInlineAgentRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<InvokeInlineAgentRequest.Builder, InvokeInlineAgentRequest> {
    private static final SdkField<List<AgentActionGroup>> ACTION_GROUPS_FIELD = SdkField
            .<List<AgentActionGroup>> builder(MarshallingType.LIST)
            .memberName("actionGroups")
            .getter(getter(InvokeInlineAgentRequest::actionGroups))
            .setter(setter(Builder::actionGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentActionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentActionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InlineBedrockModelConfigurations> BEDROCK_MODEL_CONFIGURATIONS_FIELD = SdkField
            .<InlineBedrockModelConfigurations> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockModelConfigurations")
            .getter(getter(InvokeInlineAgentRequest::bedrockModelConfigurations))
            .setter(setter(Builder::bedrockModelConfigurations))
            .constructor(InlineBedrockModelConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockModelConfigurations").build())
            .build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(InvokeInlineAgentRequest::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrace").getter(getter(InvokeInlineAgentRequest::enableTrace)).setter(setter(Builder::enableTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()).build();

    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endSession").getter(getter(InvokeInlineAgentRequest::endSession)).setter(setter(Builder::endSession))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()).build();

    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("foundationModel").getter(getter(InvokeInlineAgentRequest::foundationModel))
            .setter(setter(Builder::foundationModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()).build();

    private static final SdkField<GuardrailConfigurationWithArn> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfigurationWithArn> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(InvokeInlineAgentRequest::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfigurationWithArn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(InvokeInlineAgentRequest::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<InlineSessionState> INLINE_SESSION_STATE_FIELD = SdkField
            .<InlineSessionState> builder(MarshallingType.SDK_POJO).memberName("inlineSessionState")
            .getter(getter(InvokeInlineAgentRequest::inlineSessionState)).setter(setter(Builder::inlineSessionState))
            .constructor(InlineSessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineSessionState").build())
            .build();

    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputText").getter(getter(InvokeInlineAgentRequest::inputText)).setter(setter(Builder::inputText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()).build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instruction").getter(getter(InvokeInlineAgentRequest::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<List<KnowledgeBase>> KNOWLEDGE_BASES_FIELD = SdkField
            .<List<KnowledgeBase>> builder(MarshallingType.LIST)
            .memberName("knowledgeBases")
            .getter(getter(InvokeInlineAgentRequest::knowledgeBases))
            .setter(setter(Builder::knowledgeBases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KnowledgeBase> builder(MarshallingType.SDK_POJO)
                                            .constructor(KnowledgeBase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<PromptOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("promptOverrideConfiguration")
            .getter(getter(InvokeInlineAgentRequest::promptOverrideConfiguration))
            .setter(setter(Builder::promptOverrideConfiguration))
            .constructor(PromptOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration")
                    .build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(InvokeInlineAgentRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<StreamingConfigurations> STREAMING_CONFIGURATIONS_FIELD = SdkField
            .<StreamingConfigurations> builder(MarshallingType.SDK_POJO).memberName("streamingConfigurations")
            .getter(getter(InvokeInlineAgentRequest::streamingConfigurations)).setter(setter(Builder::streamingConfigurations))
            .constructor(StreamingConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamingConfigurations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUPS_FIELD,
            BEDROCK_MODEL_CONFIGURATIONS_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, ENABLE_TRACE_FIELD, END_SESSION_FIELD,
            FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, INLINE_SESSION_STATE_FIELD,
            INPUT_TEXT_FIELD, INSTRUCTION_FIELD, KNOWLEDGE_BASES_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD, SESSION_ID_FIELD,
            STREAMING_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AgentActionGroup> actionGroups;

    private final InlineBedrockModelConfigurations bedrockModelConfigurations;

    private final String customerEncryptionKeyArn;

    private final Boolean enableTrace;

    private final Boolean endSession;

    private final String foundationModel;

    private final GuardrailConfigurationWithArn guardrailConfiguration;

    private final Integer idleSessionTTLInSeconds;

    private final InlineSessionState inlineSessionState;

    private final String inputText;

    private final String instruction;

    private final List<KnowledgeBase> knowledgeBases;

    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private final String sessionId;

    private final StreamingConfigurations streamingConfigurations;

    private InvokeInlineAgentRequest(BuilderImpl builder) {
        super(builder);
        this.actionGroups = builder.actionGroups;
        this.bedrockModelConfigurations = builder.bedrockModelConfigurations;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.enableTrace = builder.enableTrace;
        this.endSession = builder.endSession;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.inlineSessionState = builder.inlineSessionState;
        this.inputText = builder.inputText;
        this.instruction = builder.instruction;
        this.knowledgeBases = builder.knowledgeBases;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
        this.sessionId = builder.sessionId;
        this.streamingConfigurations = builder.streamingConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionGroups() {
        return actionGroups != null && !(actionGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of action groups with each action group defining the action the inline agent needs to carry out.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionGroups} method.
     * </p>
     * 
     * @return A list of action groups with each action group defining the action the inline agent needs to carry out.
     */
    public final List<AgentActionGroup> actionGroups() {
        return actionGroups;
    }

    /**
     * <p>
     * Model settings for the request.
     * </p>
     * 
     * @return Model settings for the request.
     */
    public final InlineBedrockModelConfigurations bedrockModelConfigurations() {
        return bedrockModelConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * Specifies whether to turn on the trace or not to track the agent's reasoning process. For more information, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using trace</a>.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @return Specifies whether to turn on the trace or not to track the agent's reasoning process. For more
     *         information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using
     *         trace</a>.
     * 
     *         <pre>
     * 
     *         <code> &lt;/p&gt; </code>
     */
    public final Boolean enableTrace() {
        return enableTrace;
    }

    /**
     * <p>
     * Specifies whether to end the session with the inline agent or not.
     * </p>
     * 
     * @return Specifies whether to end the session with the inline agent or not.
     */
    public final Boolean endSession() {
        return endSession;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model identifier
     * (ID)</a> of the model to use for orchestration by the inline agent. For example,
     * <code>meta.llama3-1-70b-instruct-v1:0</code>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model
     *         identifier (ID)</a> of the model to use for orchestration by the inline agent. For example,
     *         <code>meta.llama3-1-70b-instruct-v1:0</code>.
     */
    public final String foundationModel() {
        return foundationModel;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to assign to
     * the inline agent.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to
     *         assign to the inline agent.
     */
    public final GuardrailConfigurationWithArn guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * The number of seconds for which the inline agent should maintain session information. After this time expires,
     * the subsequent <code>InvokeInlineAgent</code> request begins a new session.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and the data provided before the timeout is deleted.
     * </p>
     * 
     * @return The number of seconds for which the inline agent should maintain session information. After this time
     *         expires, the subsequent <code>InvokeInlineAgent</code> request begins a new session. </p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and the data provided before the timeout is deleted.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * Parameters that specify the various attributes of a sessions. You can include attributes for the session or
     * prompt or, if you configured an action group to return control, results from invocation of the action group. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     * context</a>.
     * </p>
     * <note>
     * <p>
     * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     * <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * 
     * @return Parameters that specify the various attributes of a sessions. You can include attributes for the session
     *         or prompt or, if you configured an action group to return control, results from invocation of the action
     *         group. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
     *         context</a>. </p> <note>
     *         <p>
     *         If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     *         <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final InlineSessionState inlineSessionState() {
        return inlineSessionState;
    }

    /**
     * <p>
     * The prompt text to send to the agent.
     * </p>
     * <note>
     * <p>
     * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     * <code>inputText</code> field will be ignored.
     * </p>
     * </note>
     * 
     * @return The prompt text to send to the agent. </p> <note>
     *         <p>
     *         If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
     *         <code>inputText</code> field will be ignored.
     *         </p>
     */
    public final String inputText() {
        return inputText;
    }

    /**
     * <p>
     * The instructions that tell the inline agent what it should do and how it should interact with users.
     * </p>
     * 
     * @return The instructions that tell the inline agent what it should do and how it should interact with users.
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * For responses, this returns true if the service returned a value for the KnowledgeBases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKnowledgeBases() {
        return knowledgeBases != null && !(knowledgeBases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information of the knowledge bases to associate with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKnowledgeBases} method.
     * </p>
     * 
     * @return Contains information of the knowledge bases to associate with.
     */
    public final List<KnowledgeBase> knowledgeBases() {
        return knowledgeBases;
    }

    /**
     * <p>
     * Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the inline
     * agent.
     * </p>
     * 
     * @return Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the
     *         inline agent.
     */
    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return promptOverrideConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the session. Use the same value across requests to continue the same conversation.
     * </p>
     * 
     * @return The unique identifier of the session. Use the same value across requests to continue the same
     *         conversation.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Specifies the configurations for streaming.
     * </p>
     * <note>
     * <p>
     * To use agent streaming, you need permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code>
     * action.
     * </p>
     * </note>
     * 
     * @return Specifies the configurations for streaming. </p> <note>
     *         <p>
     *         To use agent streaming, you need permissions to perform the
     *         <code>bedrock:InvokeModelWithResponseStream</code> action.
     *         </p>
     */
    public final StreamingConfigurations streamingConfigurations() {
        return streamingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasActionGroups() ? actionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bedrockModelConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(endSession());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(inlineSessionState());
        hashCode = 31 * hashCode + Objects.hashCode(inputText());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(hasKnowledgeBases() ? knowledgeBases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(promptOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(streamingConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeInlineAgentRequest)) {
            return false;
        }
        InvokeInlineAgentRequest other = (InvokeInlineAgentRequest) obj;
        return hasActionGroups() == other.hasActionGroups() && Objects.equals(actionGroups(), other.actionGroups())
                && Objects.equals(bedrockModelConfigurations(), other.bedrockModelConfigurations())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(enableTrace(), other.enableTrace()) && Objects.equals(endSession(), other.endSession())
                && Objects.equals(foundationModel(), other.foundationModel())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(inlineSessionState(), other.inlineSessionState())
                && Objects.equals(inputText(), other.inputText()) && Objects.equals(instruction(), other.instruction())
                && hasKnowledgeBases() == other.hasKnowledgeBases() && Objects.equals(knowledgeBases(), other.knowledgeBases())
                && Objects.equals(promptOverrideConfiguration(), other.promptOverrideConfiguration())
                && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(streamingConfigurations(), other.streamingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("InvokeInlineAgentRequest")
                .add("ActionGroups", hasActionGroups() ? actionGroups() : null)
                .add("BedrockModelConfigurations", bedrockModelConfigurations())
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn())
                .add("EnableTrace", enableTrace())
                .add("EndSession", endSession())
                .add("FoundationModel", foundationModel())
                .add("GuardrailConfiguration", guardrailConfiguration())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("InlineSessionState", inlineSessionState())
                .add("InputText", inputText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Instruction", instruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KnowledgeBases", hasKnowledgeBases() ? knowledgeBases() : null)
                .add("PromptOverrideConfiguration",
                        promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionId", sessionId()).add("StreamingConfigurations", streamingConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroups":
            return Optional.ofNullable(clazz.cast(actionGroups()));
        case "bedrockModelConfigurations":
            return Optional.ofNullable(clazz.cast(bedrockModelConfigurations()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "enableTrace":
            return Optional.ofNullable(clazz.cast(enableTrace()));
        case "endSession":
            return Optional.ofNullable(clazz.cast(endSession()));
        case "foundationModel":
            return Optional.ofNullable(clazz.cast(foundationModel()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "inlineSessionState":
            return Optional.ofNullable(clazz.cast(inlineSessionState()));
        case "inputText":
            return Optional.ofNullable(clazz.cast(inputText()));
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "knowledgeBases":
            return Optional.ofNullable(clazz.cast(knowledgeBases()));
        case "promptOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(promptOverrideConfiguration()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "streamingConfigurations":
            return Optional.ofNullable(clazz.cast(streamingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionGroups", ACTION_GROUPS_FIELD);
        map.put("bedrockModelConfigurations", BEDROCK_MODEL_CONFIGURATIONS_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("enableTrace", ENABLE_TRACE_FIELD);
        map.put("endSession", END_SESSION_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("inlineSessionState", INLINE_SESSION_STATE_FIELD);
        map.put("inputText", INPUT_TEXT_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("knowledgeBases", KNOWLEDGE_BASES_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("streamingConfigurations", STREAMING_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeInlineAgentRequest, T> g) {
        return obj -> g.apply((InvokeInlineAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeInlineAgentRequest> {
        /**
         * <p>
         * A list of action groups with each action group defining the action the inline agent needs to carry out.
         * </p>
         * 
         * @param actionGroups
         *        A list of action groups with each action group defining the action the inline agent needs to carry
         *        out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroups(Collection<AgentActionGroup> actionGroups);

        /**
         * <p>
         * A list of action groups with each action group defining the action the inline agent needs to carry out.
         * </p>
         * 
         * @param actionGroups
         *        A list of action groups with each action group defining the action the inline agent needs to carry
         *        out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroups(AgentActionGroup... actionGroups);

        /**
         * <p>
         * A list of action groups with each action group defining the action the inline agent needs to carry out.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #actionGroups(List<AgentActionGroup>)}.
         * 
         * @param actionGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroups(java.util.Collection<AgentActionGroup>)
         */
        Builder actionGroups(Consumer<AgentActionGroup.Builder>... actionGroups);

        /**
         * <p>
         * Model settings for the request.
         * </p>
         * 
         * @param bedrockModelConfigurations
         *        Model settings for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockModelConfigurations(InlineBedrockModelConfigurations bedrockModelConfigurations);

        /**
         * <p>
         * Model settings for the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link InlineBedrockModelConfigurations.Builder}
         * avoiding the need to create one manually via {@link InlineBedrockModelConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineBedrockModelConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #bedrockModelConfigurations(InlineBedrockModelConfigurations)}.
         * 
         * @param bedrockModelConfigurations
         *        a consumer that will call methods on {@link InlineBedrockModelConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockModelConfigurations(InlineBedrockModelConfigurations)
         */
        default Builder bedrockModelConfigurations(Consumer<InlineBedrockModelConfigurations.Builder> bedrockModelConfigurations) {
            return bedrockModelConfigurations(InlineBedrockModelConfigurations.builder()
                    .applyMutation(bedrockModelConfigurations).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use to encrypt your inline agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * Specifies whether to turn on the trace or not to track the agent's reasoning process. For more information,
         * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using trace</a>.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param enableTrace
         *        Specifies whether to turn on the trace or not to track the agent's reasoning process. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html">Using trace</a>.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder enableTrace(Boolean enableTrace);

        /**
         * <p>
         * Specifies whether to end the session with the inline agent or not.
         * </p>
         * 
         * @param endSession
         *        Specifies whether to end the session with the inline agent or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endSession(Boolean endSession);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model
         * identifier (ID)</a> of the model to use for orchestration by the inline agent. For example,
         * <code>meta.llama3-1-70b-instruct-v1:0</code>.
         * </p>
         * 
         * @param foundationModel
         *        The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">model
         *        identifier (ID)</a> of the model to use for orchestration by the inline agent. For example,
         *        <code>meta.llama3-1-70b-instruct-v1:0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModel(String foundationModel);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to assign
         * to the inline agent.
         * </p>
         * 
         * @param guardrailConfiguration
         *        The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to
         *        assign to the inline agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">guardrails</a> to assign
         * to the inline agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfigurationWithArn.Builder}
         * avoiding the need to create one manually via {@link GuardrailConfigurationWithArn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfigurationWithArn.Builder#build()} is called
         * immediately and its result is passed to {@link #guardrailConfiguration(GuardrailConfigurationWithArn)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfigurationWithArn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfigurationWithArn)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfigurationWithArn.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfigurationWithArn.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * The number of seconds for which the inline agent should maintain session information. After this time
         * expires, the subsequent <code>InvokeInlineAgent</code> request begins a new session.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and the data provided before the timeout is deleted.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The number of seconds for which the inline agent should maintain session information. After this time
         *        expires, the subsequent <code>InvokeInlineAgent</code> request begins a new session. </p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and the data provided before the timeout is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * Parameters that specify the various attributes of a sessions. You can include attributes for the session or
         * prompt or, if you configured an action group to return control, results from invocation of the action group.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param inlineSessionState
         *        Parameters that specify the various attributes of a sessions. You can include attributes for the
         *        session or prompt or, if you configured an action group to return control, results from invocation of
         *        the action group. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         *        context</a>. </p> <note>
         *        <p>
         *        If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         *        <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineSessionState(InlineSessionState inlineSessionState);

        /**
         * <p>
         * Parameters that specify the various attributes of a sessions. You can include attributes for the session or
         * prompt or, if you configured an action group to return control, results from invocation of the action group.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html">Control session
         * context</a>.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link InlineSessionState.Builder}
         * avoiding the need to create one manually via {@link InlineSessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineSessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #inlineSessionState(InlineSessionState)}.
         * 
         * @param inlineSessionState
         *        a consumer that will call methods on {@link InlineSessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineSessionState(InlineSessionState)
         */
        default Builder inlineSessionState(Consumer<InlineSessionState.Builder> inlineSessionState) {
            return inlineSessionState(InlineSessionState.builder().applyMutation(inlineSessionState).build());
        }

        /**
         * <p>
         * The prompt text to send to the agent.
         * </p>
         * <note>
         * <p>
         * If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         * <code>inputText</code> field will be ignored.
         * </p>
         * </note>
         * 
         * @param inputText
         *        The prompt text to send to the agent. </p> <note>
         *        <p>
         *        If you include <code>returnControlInvocationResults</code> in the <code>sessionState</code> field, the
         *        <code>inputText</code> field will be ignored.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputText(String inputText);

        /**
         * <p>
         * The instructions that tell the inline agent what it should do and how it should interact with users.
         * </p>
         * 
         * @param instruction
         *        The instructions that tell the inline agent what it should do and how it should interact with users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * Contains information of the knowledge bases to associate with.
         * </p>
         * 
         * @param knowledgeBases
         *        Contains information of the knowledge bases to associate with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases);

        /**
         * <p>
         * Contains information of the knowledge bases to associate with.
         * </p>
         * 
         * @param knowledgeBases
         *        Contains information of the knowledge bases to associate with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBases(KnowledgeBase... knowledgeBases);

        /**
         * <p>
         * Contains information of the knowledge bases to associate with.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBases(List<KnowledgeBase>)}.
         * 
         * @param knowledgeBases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBases(java.util.Collection<KnowledgeBase>)
         */
        Builder knowledgeBases(Consumer<KnowledgeBase.Builder>... knowledgeBases);

        /**
         * <p>
         * Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the
         * inline agent.
         * </p>
         * 
         * @param promptOverrideConfiguration
         *        Configurations for advanced prompts used to override the default prompts to enhance the accuracy of
         *        the inline agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration);

        /**
         * <p>
         * Configurations for advanced prompts used to override the default prompts to enhance the accuracy of the
         * inline agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #promptOverrideConfiguration(PromptOverrideConfiguration)}.
         * 
         * @param promptOverrideConfiguration
         *        a consumer that will call methods on {@link PromptOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptOverrideConfiguration(PromptOverrideConfiguration)
         */
        default Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return promptOverrideConfiguration(PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)
                    .build());
        }

        /**
         * <p>
         * The unique identifier of the session. Use the same value across requests to continue the same conversation.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the session. Use the same value across requests to continue the same
         *        conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Specifies the configurations for streaming.
         * </p>
         * <note>
         * <p>
         * To use agent streaming, you need permissions to perform the
         * <code>bedrock:InvokeModelWithResponseStream</code> action.
         * </p>
         * </note>
         * 
         * @param streamingConfigurations
         *        Specifies the configurations for streaming. </p> <note>
         *        <p>
         *        To use agent streaming, you need permissions to perform the
         *        <code>bedrock:InvokeModelWithResponseStream</code> action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingConfigurations(StreamingConfigurations streamingConfigurations);

        /**
         * <p>
         * Specifies the configurations for streaming.
         * </p>
         * <note>
         * <p>
         * To use agent streaming, you need permissions to perform the
         * <code>bedrock:InvokeModelWithResponseStream</code> action.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StreamingConfigurations.Builder}
         * avoiding the need to create one manually via {@link StreamingConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #streamingConfigurations(StreamingConfigurations)}.
         * 
         * @param streamingConfigurations
         *        a consumer that will call methods on {@link StreamingConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingConfigurations(StreamingConfigurations)
         */
        default Builder streamingConfigurations(Consumer<StreamingConfigurations.Builder> streamingConfigurations) {
            return streamingConfigurations(StreamingConfigurations.builder().applyMutation(streamingConfigurations).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private List<AgentActionGroup> actionGroups = DefaultSdkAutoConstructList.getInstance();

        private InlineBedrockModelConfigurations bedrockModelConfigurations;

        private String customerEncryptionKeyArn;

        private Boolean enableTrace;

        private Boolean endSession;

        private String foundationModel;

        private GuardrailConfigurationWithArn guardrailConfiguration;

        private Integer idleSessionTTLInSeconds;

        private InlineSessionState inlineSessionState;

        private String inputText;

        private String instruction;

        private List<KnowledgeBase> knowledgeBases = DefaultSdkAutoConstructList.getInstance();

        private PromptOverrideConfiguration promptOverrideConfiguration;

        private String sessionId;

        private StreamingConfigurations streamingConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeInlineAgentRequest model) {
            super(model);
            actionGroups(model.actionGroups);
            bedrockModelConfigurations(model.bedrockModelConfigurations);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            enableTrace(model.enableTrace);
            endSession(model.endSession);
            foundationModel(model.foundationModel);
            guardrailConfiguration(model.guardrailConfiguration);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            inlineSessionState(model.inlineSessionState);
            inputText(model.inputText);
            instruction(model.instruction);
            knowledgeBases(model.knowledgeBases);
            promptOverrideConfiguration(model.promptOverrideConfiguration);
            sessionId(model.sessionId);
            streamingConfigurations(model.streamingConfigurations);
        }

        public final List<AgentActionGroup.Builder> getActionGroups() {
            List<AgentActionGroup.Builder> result = AgentActionGroupsCopier.copyToBuilder(this.actionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionGroups(Collection<AgentActionGroup.BuilderImpl> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copyFromBuilder(actionGroups);
        }

        @Override
        public final Builder actionGroups(Collection<AgentActionGroup> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copy(actionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(AgentActionGroup... actionGroups) {
            actionGroups(Arrays.asList(actionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(Consumer<AgentActionGroup.Builder>... actionGroups) {
            actionGroups(Stream.of(actionGroups).map(c -> AgentActionGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InlineBedrockModelConfigurations.Builder getBedrockModelConfigurations() {
            return bedrockModelConfigurations != null ? bedrockModelConfigurations.toBuilder() : null;
        }

        public final void setBedrockModelConfigurations(InlineBedrockModelConfigurations.BuilderImpl bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations != null ? bedrockModelConfigurations.build() : null;
        }

        @Override
        public final Builder bedrockModelConfigurations(InlineBedrockModelConfigurations bedrockModelConfigurations) {
            this.bedrockModelConfigurations = bedrockModelConfigurations;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final Boolean getEnableTrace() {
            return enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final Boolean getEndSession() {
            return endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final String getFoundationModel() {
            return foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfigurationWithArn.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfigurationWithArn.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final InlineSessionState.Builder getInlineSessionState() {
            return inlineSessionState != null ? inlineSessionState.toBuilder() : null;
        }

        public final void setInlineSessionState(InlineSessionState.BuilderImpl inlineSessionState) {
            this.inlineSessionState = inlineSessionState != null ? inlineSessionState.build() : null;
        }

        @Override
        public final Builder inlineSessionState(InlineSessionState inlineSessionState) {
            this.inlineSessionState = inlineSessionState;
            return this;
        }

        public final String getInputText() {
            return inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<KnowledgeBase.Builder> getKnowledgeBases() {
            List<KnowledgeBase.Builder> result = KnowledgeBasesCopier.copyToBuilder(this.knowledgeBases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKnowledgeBases(Collection<KnowledgeBase.BuilderImpl> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copyFromBuilder(knowledgeBases);
        }

        @Override
        public final Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copy(knowledgeBases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(KnowledgeBase... knowledgeBases) {
            knowledgeBases(Arrays.asList(knowledgeBases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(Consumer<KnowledgeBase.Builder>... knowledgeBases) {
            knowledgeBases(Stream.of(knowledgeBases).map(c -> KnowledgeBase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return promptOverrideConfiguration != null ? promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final StreamingConfigurations.Builder getStreamingConfigurations() {
            return streamingConfigurations != null ? streamingConfigurations.toBuilder() : null;
        }

        public final void setStreamingConfigurations(StreamingConfigurations.BuilderImpl streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations != null ? streamingConfigurations.build() : null;
        }

        @Override
        public final Builder streamingConfigurations(StreamingConfigurations streamingConfigurations) {
            this.streamingConfigurations = streamingConfigurations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeInlineAgentRequest build() {
            return new InvokeInlineAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
