/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the response from the Lambda parsing of the output from the pre-processing step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PreProcessingParsedResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<PreProcessingParsedResponse.Builder, PreProcessingParsedResponse> {
    private static final SdkField<Boolean> IS_VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isValid").getter(getter(PreProcessingParsedResponse::isValid)).setter(setter(Builder::isValid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isValid").build()).build();

    private static final SdkField<String> RATIONALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rationale").getter(getter(PreProcessingParsedResponse::rationale)).setter(setter(Builder::rationale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rationale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_VALID_FIELD,
            RATIONALE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isValid;

    private final String rationale;

    private PreProcessingParsedResponse(BuilderImpl builder) {
        this.isValid = builder.isValid;
        this.rationale = builder.rationale;
    }

    /**
     * <p>
     * Whether the user input is valid or not. If <code>false</code>, the agent doesn't proceed to orchestration.
     * </p>
     * 
     * @return Whether the user input is valid or not. If <code>false</code>, the agent doesn't proceed to
     *         orchestration.
     */
    public final Boolean isValid() {
        return isValid;
    }

    /**
     * <p>
     * The text returned by the parsing of the pre-processing step, explaining the steps that the agent plans to take in
     * orchestration, if the user input is valid.
     * </p>
     * 
     * @return The text returned by the parsing of the pre-processing step, explaining the steps that the agent plans to
     *         take in orchestration, if the user input is valid.
     */
    public final String rationale() {
        return rationale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isValid());
        hashCode = 31 * hashCode + Objects.hashCode(rationale());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreProcessingParsedResponse)) {
            return false;
        }
        PreProcessingParsedResponse other = (PreProcessingParsedResponse) obj;
        return Objects.equals(isValid(), other.isValid()) && Objects.equals(rationale(), other.rationale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PreProcessingParsedResponse").add("IsValid", isValid())
                .add("Rationale", rationale() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isValid":
            return Optional.ofNullable(clazz.cast(isValid()));
        case "rationale":
            return Optional.ofNullable(clazz.cast(rationale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isValid", IS_VALID_FIELD);
        map.put("rationale", RATIONALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreProcessingParsedResponse, T> g) {
        return obj -> g.apply((PreProcessingParsedResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PreProcessingParsedResponse> {
        /**
         * <p>
         * Whether the user input is valid or not. If <code>false</code>, the agent doesn't proceed to orchestration.
         * </p>
         * 
         * @param isValid
         *        Whether the user input is valid or not. If <code>false</code>, the agent doesn't proceed to
         *        orchestration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isValid(Boolean isValid);

        /**
         * <p>
         * The text returned by the parsing of the pre-processing step, explaining the steps that the agent plans to
         * take in orchestration, if the user input is valid.
         * </p>
         * 
         * @param rationale
         *        The text returned by the parsing of the pre-processing step, explaining the steps that the agent plans
         *        to take in orchestration, if the user input is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rationale(String rationale);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isValid;

        private String rationale;

        private BuilderImpl() {
        }

        private BuilderImpl(PreProcessingParsedResponse model) {
            isValid(model.isValid);
            rationale(model.rationale);
        }

        public final Boolean getIsValid() {
            return isValid;
        }

        public final void setIsValid(Boolean isValid) {
            this.isValid = isValid;
        }

        @Override
        public final Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public final String getRationale() {
            return rationale;
        }

        public final void setRationale(String rationale) {
            this.rationale = rationale;
        }

        @Override
        public final Builder rationale(String rationale) {
            this.rationale = rationale;
            return this;
        }

        @Override
        public PreProcessingParsedResponse build() {
            return new PreProcessingParsedResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
