/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputField;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowTraceNodeOutputEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowTraceNodeOutputEvent> {
    private static final SdkField<List<FlowTraceNodeOutputField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(FlowTraceNodeOutputEvent.getter(FlowTraceNodeOutputEvent::fields)).setter(FlowTraceNodeOutputEvent.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowTraceNodeOutputField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(FlowTraceNodeOutputEvent.getter(FlowTraceNodeOutputEvent::nodeName)).setter(FlowTraceNodeOutputEvent.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(FlowTraceNodeOutputEvent.getter(FlowTraceNodeOutputEvent::timestamp)).setter(FlowTraceNodeOutputEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, NODE_NAME_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowTraceNodeOutputEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FlowTraceNodeOutputField> fields;
    private final String nodeName;
    private final Instant timestamp;

    private FlowTraceNodeOutputEvent(BuilderImpl builder) {
        this.fields = builder.fields;
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<FlowTraceNodeOutputField> fields() {
        return this.fields;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeOutputEvent)) {
            return false;
        }
        FlowTraceNodeOutputEvent other = (FlowTraceNodeOutputEvent)obj;
        return this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"FlowTraceNodeOutputEvent").add("Fields", (Object)(this.fields() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeName", (Object)this.nodeName()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fields", FIELDS_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeOutputEvent, T> g) {
        return obj -> g.apply((FlowTraceNodeOutputEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FlowTraceNodeOutputField> fields = DefaultSdkAutoConstructList.getInstance();
        private String nodeName;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeOutputEvent model) {
            this.fields(model.fields);
            this.nodeName(model.nodeName);
            this.timestamp(model.timestamp);
        }

        public final List<FlowTraceNodeOutputField.Builder> getFields() {
            List<FlowTraceNodeOutputField.Builder> result = FlowTraceNodeOutputFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FlowTraceNodeOutputField.BuilderImpl> fields) {
            this.fields = FlowTraceNodeOutputFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FlowTraceNodeOutputField> fields) {
            this.fields = FlowTraceNodeOutputFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FlowTraceNodeOutputField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FlowTraceNodeOutputField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (FlowTraceNodeOutputField)((FlowTraceNodeOutputField.Builder)FlowTraceNodeOutputField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public FlowTraceNodeOutputEvent build() {
            return new FlowTraceNodeOutputEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowTraceNodeOutputEvent> {
        public Builder fields(Collection<FlowTraceNodeOutputField> var1);

        public Builder fields(FlowTraceNodeOutputField ... var1);

        public Builder fields(Consumer<FlowTraceNodeOutputField.Builder> ... var1);

        public Builder nodeName(String var1);

        public Builder timestamp(Instant var1);
    }
}

