/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the input into a node. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeInputEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeInputEvent.Builder, FlowTraceNodeInputEvent> {
    private static final SdkField<List<FlowTraceNodeInputField>> FIELDS_FIELD = SdkField
            .<List<FlowTraceNodeInputField>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(FlowTraceNodeInputEvent::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowTraceNodeInputField> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowTraceNodeInputField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowTraceNodeInputEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(FlowTraceNodeInputEvent::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_FIELD, NODE_NAME_FIELD,
            TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FlowTraceNodeInputField> fields;

    private final String nodeName;

    private final Instant timestamp;

    private FlowTraceNodeInputEvent(BuilderImpl builder) {
        this.fields = builder.fields;
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects containing information about each field in the input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return An array of objects containing information about each field in the input.
     */
    public final List<FlowTraceNodeInputField> fields() {
        return fields;
    }

    /**
     * <p>
     * The name of the node that received the input.
     * </p>
     * 
     * @return The name of the node that received the input.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The date and time that the trace was returned.
     * </p>
     * 
     * @return The date and time that the trace was returned.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputEvent)) {
            return false;
        }
        FlowTraceNodeInputEvent other = (FlowTraceNodeInputEvent) obj;
        return hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(nodeName(), other.nodeName()) && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeInputEvent")
                .add("Fields", fields() == null ? null : "*** Sensitive Data Redacted ***").add("NodeName", nodeName())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fields", FIELDS_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputEvent, T> g) {
        return obj -> g.apply((FlowTraceNodeInputEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeInputEvent> {
        /**
         * <p>
         * An array of objects containing information about each field in the input.
         * </p>
         * 
         * @param fields
         *        An array of objects containing information about each field in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<FlowTraceNodeInputField> fields);

        /**
         * <p>
         * An array of objects containing information about each field in the input.
         * </p>
         * 
         * @param fields
         *        An array of objects containing information about each field in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(FlowTraceNodeInputField... fields);

        /**
         * <p>
         * An array of objects containing information about each field in the input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputField.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputField.Builder#build()} is
         * called immediately and its result is passed to {@link #fields(List<FlowTraceNodeInputField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<FlowTraceNodeInputField>)
         */
        Builder fields(Consumer<FlowTraceNodeInputField.Builder>... fields);

        /**
         * <p>
         * The name of the node that received the input.
         * </p>
         * 
         * @param nodeName
         *        The name of the node that received the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The date and time that the trace was returned.
         * </p>
         * 
         * @param timestamp
         *        The date and time that the trace was returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private List<FlowTraceNodeInputField> fields = DefaultSdkAutoConstructList.getInstance();

        private String nodeName;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputEvent model) {
            fields(model.fields);
            nodeName(model.nodeName);
            timestamp(model.timestamp);
        }

        public final List<FlowTraceNodeInputField.Builder> getFields() {
            List<FlowTraceNodeInputField.Builder> result = FlowTraceNodeInputFieldsCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<FlowTraceNodeInputField.BuilderImpl> fields) {
            this.fields = FlowTraceNodeInputFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<FlowTraceNodeInputField> fields) {
            this.fields = FlowTraceNodeInputFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(FlowTraceNodeInputField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<FlowTraceNodeInputField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> FlowTraceNodeInputField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public FlowTraceNodeInputEvent build() {
            return new FlowTraceNodeInputEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
