/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a field in the output from a node. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeOutputField implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeOutputField.Builder, FlowTraceNodeOutputField> {
    private static final SdkField<FlowTraceNodeOutputContent> CONTENT_FIELD = SdkField
            .<FlowTraceNodeOutputContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(FlowTraceNodeOutputField::content)).setter(setter(Builder::content))
            .constructor(FlowTraceNodeOutputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> NODE_OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeOutputName").getter(getter(FlowTraceNodeOutputField::nodeOutputName))
            .setter(setter(Builder::nodeOutputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            NODE_OUTPUT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowTraceNodeOutputContent content;

    private final String nodeOutputName;

    private FlowTraceNodeOutputField(BuilderImpl builder) {
        this.content = builder.content;
        this.nodeOutputName = builder.nodeOutputName;
    }

    /**
     * <p>
     * The content of the node output.
     * </p>
     * 
     * @return The content of the node output.
     */
    public final FlowTraceNodeOutputContent content() {
        return content;
    }

    /**
     * <p>
     * The name of the node output.
     * </p>
     * 
     * @return The name of the node output.
     */
    public final String nodeOutputName() {
        return nodeOutputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOutputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeOutputField)) {
            return false;
        }
        FlowTraceNodeOutputField other = (FlowTraceNodeOutputField) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(nodeOutputName(), other.nodeOutputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeOutputField").add("Content", content()).add("NodeOutputName", nodeOutputName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "nodeOutputName":
            return Optional.ofNullable(clazz.cast(nodeOutputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("nodeOutputName", NODE_OUTPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeOutputField, T> g) {
        return obj -> g.apply((FlowTraceNodeOutputField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeOutputField> {
        /**
         * <p>
         * The content of the node output.
         * </p>
         * 
         * @param content
         *        The content of the node output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowTraceNodeOutputContent content);

        /**
         * <p>
         * The content of the node output.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeOutputContent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeOutputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeOutputContent.Builder#build()} is called immediately
         * and its result is passed to {@link #content(FlowTraceNodeOutputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowTraceNodeOutputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowTraceNodeOutputContent)
         */
        default Builder content(Consumer<FlowTraceNodeOutputContent.Builder> content) {
            return content(FlowTraceNodeOutputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The name of the node output.
         * </p>
         * 
         * @param nodeOutputName
         *        The name of the node output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOutputName(String nodeOutputName);
    }

    static final class BuilderImpl implements Builder {
        private FlowTraceNodeOutputContent content;

        private String nodeOutputName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeOutputField model) {
            content(model.content);
            nodeOutputName(model.nodeOutputName);
        }

        public final FlowTraceNodeOutputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowTraceNodeOutputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowTraceNodeOutputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeOutputName() {
            return nodeOutputName;
        }

        public final void setNodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
        }

        @Override
        public final Builder nodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
            return this;
        }

        @Override
        public FlowTraceNodeOutputField build() {
            return new FlowTraceNodeOutputField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
