/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvocationsResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<ListInvocationsResponse.Builder, ListInvocationsResponse> {
    private static final SdkField<List<InvocationSummary>> INVOCATION_SUMMARIES_FIELD = SdkField
            .<List<InvocationSummary>> builder(MarshallingType.LIST)
            .memberName("invocationSummaries")
            .getter(getter(ListInvocationsResponse::invocationSummaries))
            .setter(setter(Builder::invocationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvocationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvocationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInvocationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InvocationSummary> invocationSummaries;

    private final String nextToken;

    private ListInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.invocationSummaries = builder.invocationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvocationSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvocationSummaries() {
        return invocationSummaries != null && !(invocationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of invocation summaries associated with the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvocationSummaries} method.
     * </p>
     * 
     * @return A list of invocation summaries associated with the session.
     */
    public final List<InvocationSummary> invocationSummaries() {
        return invocationSummaries;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
     * this token when making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         use this token when making another request in the <code>nextToken</code> field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInvocationSummaries() ? invocationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvocationsResponse)) {
            return false;
        }
        ListInvocationsResponse other = (ListInvocationsResponse) obj;
        return hasInvocationSummaries() == other.hasInvocationSummaries()
                && Objects.equals(invocationSummaries(), other.invocationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvocationsResponse")
                .add("InvocationSummaries", hasInvocationSummaries() ? invocationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationSummaries":
            return Optional.ofNullable(clazz.cast(invocationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationSummaries", INVOCATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvocationsResponse, T> g) {
        return obj -> g.apply((ListInvocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInvocationsResponse> {
        /**
         * <p>
         * A list of invocation summaries associated with the session.
         * </p>
         * 
         * @param invocationSummaries
         *        A list of invocation summaries associated with the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationSummaries(Collection<InvocationSummary> invocationSummaries);

        /**
         * <p>
         * A list of invocation summaries associated with the session.
         * </p>
         * 
         * @param invocationSummaries
         *        A list of invocation summaries associated with the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationSummaries(InvocationSummary... invocationSummaries);

        /**
         * <p>
         * A list of invocation summaries associated with the session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #invocationSummaries(List<InvocationSummary>)}.
         * 
         * @param invocationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationSummaries(java.util.Collection<InvocationSummary>)
         */
        Builder invocationSummaries(Consumer<InvocationSummary.Builder>... invocationSummaries);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
         * this token when making another request in the <code>nextToken</code> field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, use this token when making another request in the <code>nextToken</code> field to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private List<InvocationSummary> invocationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvocationsResponse model) {
            super(model);
            invocationSummaries(model.invocationSummaries);
            nextToken(model.nextToken);
        }

        public final List<InvocationSummary.Builder> getInvocationSummaries() {
            List<InvocationSummary.Builder> result = InvocationSummariesCopier.copyToBuilder(this.invocationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationSummaries(Collection<InvocationSummary.BuilderImpl> invocationSummaries) {
            this.invocationSummaries = InvocationSummariesCopier.copyFromBuilder(invocationSummaries);
        }

        @Override
        public final Builder invocationSummaries(Collection<InvocationSummary> invocationSummaries) {
            this.invocationSummaries = InvocationSummariesCopier.copy(invocationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationSummaries(InvocationSummary... invocationSummaries) {
            invocationSummaries(Arrays.asList(invocationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationSummaries(Consumer<InvocationSummary.Builder>... invocationSummaries) {
            invocationSummaries(Stream.of(invocationSummaries).map(c -> InvocationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvocationsResponse build() {
            return new ListInvocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
