/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInvocationStepResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<PutInvocationStepResponse.Builder, PutInvocationStepResponse> {
    private static final SdkField<String> INVOCATION_STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationStepId").getter(getter(PutInvocationStepResponse::invocationStepId))
            .setter(setter(Builder::invocationStepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStepId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_STEP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invocationStepId;

    private PutInvocationStepResponse(BuilderImpl builder) {
        super(builder);
        this.invocationStepId = builder.invocationStepId;
    }

    /**
     * <p>
     * The unique identifier of the invocation step in UUID format.
     * </p>
     * 
     * @return The unique identifier of the invocation step in UUID format.
     */
    public final String invocationStepId() {
        return invocationStepId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invocationStepId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInvocationStepResponse)) {
            return false;
        }
        PutInvocationStepResponse other = (PutInvocationStepResponse) obj;
        return Objects.equals(invocationStepId(), other.invocationStepId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutInvocationStepResponse").add("InvocationStepId", invocationStepId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationStepId":
            return Optional.ofNullable(clazz.cast(invocationStepId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationStepId", INVOCATION_STEP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInvocationStepResponse, T> g) {
        return obj -> g.apply((PutInvocationStepResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutInvocationStepResponse> {
        /**
         * <p>
         * The unique identifier of the invocation step in UUID format.
         * </p>
         * 
         * @param invocationStepId
         *        The unique identifier of the invocation step in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationStepId(String invocationStepId);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private String invocationStepId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInvocationStepResponse model) {
            super(model);
            invocationStepId(model.invocationStepId);
        }

        public final String getInvocationStepId() {
            return invocationStepId;
        }

        public final void setInvocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
        }

        @Override
        public final Builder invocationStepId(String invocationStepId) {
            this.invocationStepId = invocationStepId;
            return this;
        }

        @Override
        public PutInvocationStepResponse build() {
            return new PutInvocationStepResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
