/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateInvocationRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateInvocationResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.CreateSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.DeleteSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.EndSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.EndSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetInvocationStepRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetInvocationStepResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.GetSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.PutInvocationStepRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.PutInvocationStepResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.TagResourceRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.TagResourceResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.UntagResourceRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.UntagResourceResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.UpdateSessionRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.UpdateSessionResponse;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher;
import software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher;

/**
 * Service client for accessing Agents for Amazon Bedrock Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Contains APIs related to model invocation and querying of knowledge bases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BedrockAgentRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "bedrock";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bedrock-agent-runtime";

    /**
     * <p>
     * Creates a new invocation within a session. An invocation groups the related invocation steps that store the
     * content from a conversation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createInvocationRequest
     * @return A Java Future containing the result of the CreateInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.CreateInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInvocationResponse> createInvocation(CreateInvocationRequest createInvocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new invocation within a session. An invocation groups the related invocation steps that store the
     * content from a conversation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvocationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateInvocationRequest#builder()}
     * </p>
     *
     * @param createInvocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.CreateInvocationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.CreateInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInvocationResponse> createInvocation(
            Consumer<CreateInvocationRequest.Builder> createInvocationRequest) {
        return createInvocation(CreateInvocationRequest.builder().applyMutation(createInvocationRequest).build());
    }

    /**
     * <p>
     * Creates a session to temporarily store conversations for generative AI (GenAI) applications built with
     * open-source frameworks such as LangGraph and LlamaIndex. Sessions enable you to save the state of conversations
     * at checkpoints, with the added security and infrastructure of Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * By default, Amazon Bedrock uses Amazon Web Services-managed keys for session encryption, including session
     * metadata, or you can use your own KMS key. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/session-encryption.html">Amazon Bedrock session
     * encryption</a>.
     * </p>
     * <note>
     * <p>
     * You use a session to store state and conversation history for generative AI applications built with open-source
     * frameworks. For Amazon Bedrock Agents, the service automatically manages conversation context and associates them
     * with the agent-specific sessionId you specify in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * API operation.
     * </p>
     * </note>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteSession.html">
     * DeleteSession</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createSessionRequest
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSessionResponse> createSession(CreateSessionRequest createSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a session to temporarily store conversations for generative AI (GenAI) applications built with
     * open-source frameworks such as LangGraph and LlamaIndex. Sessions enable you to save the state of conversations
     * at checkpoints, with the added security and infrastructure of Amazon Web Services. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * By default, Amazon Bedrock uses Amazon Web Services-managed keys for session encryption, including session
     * metadata, or you can use your own KMS key. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/session-encryption.html">Amazon Bedrock session
     * encryption</a>.
     * </p>
     * <note>
     * <p>
     * You use a session to store state and conversation history for generative AI applications built with open-source
     * frameworks. For Amazon Bedrock Agents, the service automatically manages conversation context and associates them
     * with the agent-specific sessionId you specify in the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * API operation.
     * </p>
     * </note>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListSessions.html">ListSessions
     * </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetSession.html">GetSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_DeleteSession.html">
     * DeleteSession</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSessionRequest#builder()}
     * </p>
     *
     * @param createSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.CreateSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.CreateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/CreateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSessionResponse> createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest) {
        return createSession(CreateSessionRequest.builder().applyMutation(createSessionRequest).build());
    }

    /**
     * <p>
     * Deletes memory from the specified memory identifier.
     * </p>
     *
     * @param deleteAgentMemoryRequest
     * @return A Java Future containing the result of the DeleteAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.DeleteAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentMemoryResponse> deleteAgentMemory(DeleteAgentMemoryRequest deleteAgentMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes memory from the specified memory identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgentMemoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAgentMemoryRequest#builder()}
     * </p>
     *
     * @param deleteAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.DeleteAgentMemoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.DeleteAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAgentMemoryResponse> deleteAgentMemory(
            Consumer<DeleteAgentMemoryRequest.Builder> deleteAgentMemoryRequest) {
        return deleteAgentMemory(DeleteAgentMemoryRequest.builder().applyMutation(deleteAgentMemoryRequest).build());
    }

    /**
     * <p>
     * Deletes a session that you ended. You can't delete a session with an <code>ACTIVE</code> status. To delete an
     * active session, you must first end it with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * API operation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param deleteSessionRequest
     * @return A Java Future containing the result of the DeleteSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.DeleteSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSessionResponse> deleteSession(DeleteSessionRequest deleteSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a session that you ended. You can't delete a session with an <code>ACTIVE</code> status. To delete an
     * active session, you must first end it with the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_EndSession.html">EndSession</a>
     * API operation. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSessionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSessionRequest#builder()}
     * </p>
     *
     * @param deleteSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.DeleteSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.DeleteSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/DeleteSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSessionResponse> deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest) {
        return deleteSession(DeleteSessionRequest.builder().applyMutation(deleteSessionRequest).build());
    }

    /**
     * <p>
     * Ends the session. After you end a session, you can still access its content but you can’t add to it. To delete
     * the session and it's content, you use the DeleteSession API operation. For more information about sessions, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation
     * history and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param endSessionRequest
     * @return A Java Future containing the result of the EndSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.EndSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/EndSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EndSessionResponse> endSession(EndSessionRequest endSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ends the session. After you end a session, you can still access its content but you can’t add to it. To delete
     * the session and it's content, you use the DeleteSession API operation. For more information about sessions, see
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation
     * history and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EndSessionRequest.Builder} avoiding the need to
     * create one manually via {@link EndSessionRequest#builder()}
     * </p>
     *
     * @param endSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.EndSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EndSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.EndSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/EndSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EndSessionResponse> endSession(Consumer<EndSessionRequest.Builder> endSessionRequest) {
        return endSession(EndSessionRequest.builder().applyMutation(endSessionRequest).build());
    }

    /**
     * <p>
     * Generates an SQL query from a natural language query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html">Generate a query
     * for structured data</a> in the Amazon Bedrock User Guide.
     * </p>
     *
     * @param generateQueryRequest
     * @return A Java Future containing the result of the GenerateQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GenerateQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateQueryResponse> generateQuery(GenerateQueryRequest generateQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an SQL query from a natural language query. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html">Generate a query
     * for structured data</a> in the Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GenerateQueryRequest#builder()}
     * </p>
     *
     * @param generateQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GenerateQueryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GenerateQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GenerateQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateQueryResponse> generateQuery(Consumer<GenerateQueryRequest.Builder> generateQueryRequest) {
        return generateQuery(GenerateQueryRequest.builder().applyMutation(generateQueryRequest).build());
    }

    /**
     * <p>
     * Gets the sessions stored in the memory of the agent.
     * </p>
     *
     * @param getAgentMemoryRequest
     * @return A Java Future containing the result of the GetAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentMemoryResponse> getAgentMemory(GetAgentMemoryRequest getAgentMemoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the sessions stored in the memory of the agent.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentMemoryRequest#builder()}
     * </p>
     *
     * @param getAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAgentMemory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAgentMemoryResponse> getAgentMemory(Consumer<GetAgentMemoryRequest.Builder> getAgentMemoryRequest) {
        return getAgentMemory(GetAgentMemoryRequest.builder().applyMutation(getAgentMemoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAgentMemoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryPublisher getAgentMemoryPaginator(GetAgentMemoryRequest getAgentMemoryRequest) {
        return new GetAgentMemoryPublisher(this, getAgentMemoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.GetAgentMemoryPublisher publisher = client.getAgentMemoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAgentMemory(software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAgentMemoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetAgentMemoryRequest#builder()}
     * </p>
     *
     * @param getAgentMemoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetAgentMemoryRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetAgentMemory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetAgentMemory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAgentMemoryPublisher getAgentMemoryPaginator(Consumer<GetAgentMemoryRequest.Builder> getAgentMemoryRequest) {
        return getAgentMemoryPaginator(GetAgentMemoryRequest.builder().applyMutation(getAgentMemoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a specific invocation step within an invocation in a session. For more information about
     * sessions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve
     * conversation history and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param getInvocationStepRequest
     * @return A Java Future containing the result of the GetInvocationStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvocationStepResponse> getInvocationStep(GetInvocationStepRequest getInvocationStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a specific invocation step within an invocation in a session. For more information about
     * sessions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve
     * conversation history and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvocationStepRequest.Builder} avoiding the need
     * to create one manually via {@link GetInvocationStepRequest#builder()}
     * </p>
     *
     * @param getInvocationStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetInvocationStepRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetInvocationStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvocationStepResponse> getInvocationStep(
            Consumer<GetInvocationStepRequest.Builder> getInvocationStepRequest) {
        return getInvocationStep(GetInvocationStepRequest.builder().applyMutation(getInvocationStepRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param getSessionRequest
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetSessionRequest#builder()}
     * </p>
     *
     * @param getSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GetSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.GetSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/GetSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return getSession(GetSessionRequest.builder().applyMutation(getSessionRequest).build());
    }

    /**
     * <note> </note>
     * <p>
     * Sends a prompt for the agent to process and respond to. Note the following fields for the request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you
     * follow the agent's reasoning process that led it to the information it processed, the actions it took, and the
     * final result it yielded. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * End a conversation by setting <code>endSession</code> to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the <code>sessionState</code> object, you can include attributes for the session or prompt or, if you
     * configured an action group to return control, results from invocation of the action group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The response contains both <b>chunk</b> and <b>trace</b> attributes.
     * </p>
     * <p>
     * The final response is returned in the <code>bytes</code> field of the <code>chunk</code> object. The
     * <code>InvokeAgent</code> returns one chunk for the entire interaction.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>attribution</code> object contains citations for parts of the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent's steps and
     * reasoning process that led it to the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the action predicted was configured to return control, the response returns parameters for the action,
     * elicited from the user, in the <code>returnControl</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors are also surfaced in the response.
     * </p>
     * </li>
     * </ul>
     *
     * @param invokeAgentRequest
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(InvokeAgentRequest invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note> </note>
     * <p>
     * Sends a prompt for the agent to process and respond to. Note the following fields for the request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To continue the same conversation with an agent, use the same <code>sessionId</code> value in the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * To activate trace enablement, turn <code>enableTrace</code> to <code>true</code>. Trace enablement helps you
     * follow the agent's reasoning process that led it to the information it processed, the actions it took, and the
     * final result it yielded. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events">Trace enablement</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * End a conversation by setting <code>endSession</code> to <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * In the <code>sessionState</code> object, you can include attributes for the session or prompt or, if you
     * configured an action group to return control, results from invocation of the action group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The response contains both <b>chunk</b> and <b>trace</b> attributes.
     * </p>
     * <p>
     * The final response is returned in the <code>bytes</code> field of the <code>chunk</code> object. The
     * <code>InvokeAgent</code> returns one chunk for the entire interaction.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>attribution</code> object contains citations for parts of the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set <code>enableTrace</code> to <code>true</code> in the request, you can trace the agent's steps and
     * reasoning process that led it to the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the action predicted was configured to return control, the response returns parameters for the action,
     * elicited from the user, in the <code>returnControl</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * Errors are also surfaced in the response.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeAgentRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeAgentRequest#builder()}
     * </p>
     *
     * @param invokeAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeAgentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ModelNotReadyException The model specified in the request is not ready to serve inference requests.
     *         The AWS SDK will automatically retry the operation up to 5 times. For information about configuring
     *         automatic retries, see <a
     *         href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in
     *         the <i>AWS SDKs and Tools</i> reference guide.</li>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeAgent(Consumer<InvokeAgentRequest.Builder> invokeAgentRequest,
            InvokeAgentResponseHandler asyncResponseHandler) {
        return invokeAgent(InvokeAgentRequest.builder().applyMutation(invokeAgentRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If
     * there's an error, the error is returned. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html">Test a flow in Amazon Bedrock</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including <code>InvokeFlow</code>.
     * </p>
     * </note>
     *
     * @param invokeFlowRequest
     * @return A Java Future containing the result of the InvokeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeFlow(InvokeFlowRequest invokeFlowRequest, InvokeFlowResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If
     * there's an error, the error is returned. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html">Test a flow in Amazon Bedrock</a> in
     * the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including <code>InvokeFlow</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeFlowRequest.Builder} avoiding the need to
     * create one manually via {@link InvokeFlowRequest#builder()}
     * </p>
     *
     * @param invokeFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeFlowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeFlow(Consumer<InvokeFlowRequest.Builder> invokeFlowRequest,
            InvokeFlowResponseHandler asyncResponseHandler) {
        return invokeFlow(InvokeFlowRequest.builder().applyMutation(invokeFlowRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Invokes an inline Amazon Bedrock agent using the configurations you provide with the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the following fields for security purposes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * (Optional) <code>customerEncryptionKeyArn</code> – The Amazon Resource Name (ARN) of a KMS key to encrypt the
     * creation of the agent.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <code>idleSessionTTLinSeconds</code> – Specify the number of seconds for which the agent should
     * maintain session information. After this time expires, the subsequent <code>InvokeInlineAgent</code> request
     * begins a new session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To override the default prompt behavior for agent orchestration and to use advanced prompts, include a
     * <code>promptOverrideConfiguration</code> object. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The agent instructions will not be honored if your agent has only one knowledge base, uses default prompts, has
     * no action group, and user input is disabled.
     * </p>
     * </li>
     * </ul>
     * <note> </note>
     *
     * @param invokeInlineAgentRequest
     * @return A Java Future containing the result of the InvokeInlineAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeInlineAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeInlineAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeInlineAgent(InvokeInlineAgentRequest invokeInlineAgentRequest,
            InvokeInlineAgentResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes an inline Amazon Bedrock agent using the configurations you provide with the request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the following fields for security purposes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * (Optional) <code>customerEncryptionKeyArn</code> – The Amazon Resource Name (ARN) of a KMS key to encrypt the
     * creation of the agent.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <code>idleSessionTTLinSeconds</code> – Specify the number of seconds for which the agent should
     * maintain session information. After this time expires, the subsequent <code>InvokeInlineAgent</code> request
     * begins a new session.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To override the default prompt behavior for agent orchestration and to use advanced prompts, include a
     * <code>promptOverrideConfiguration</code> object. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The agent instructions will not be honored if your agent has only one knowledge base, uses default prompts, has
     * no action group, and user input is disabled.
     * </p>
     * </li>
     * </ul>
     * <note> </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeInlineAgentRequest.Builder} avoiding the need
     * to create one manually via {@link InvokeInlineAgentRequest#builder()}
     * </p>
     *
     * @param invokeInlineAgentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the InvokeInlineAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.InvokeInlineAgent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/InvokeInlineAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeInlineAgent(Consumer<InvokeInlineAgentRequest.Builder> invokeInlineAgentRequest,
            InvokeInlineAgentResponseHandler asyncResponseHandler) {
        return invokeInlineAgent(InvokeInlineAgentRequest.builder().applyMutation(invokeInlineAgentRequest).build(),
                asyncResponseHandler);
    }

    /**
     * <p>
     * Lists all invocation steps associated with a session and optionally, an invocation within the session. For more
     * information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param listInvocationStepsRequest
     * @return A Java Future containing the result of the ListInvocationSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvocationStepsResponse> listInvocationSteps(
            ListInvocationStepsRequest listInvocationStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all invocation steps associated with a session and optionally, an invocation within the session. For more
     * information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationStepsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvocationStepsRequest#builder()}
     * </p>
     *
     * @param listInvocationStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListInvocationSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvocationStepsResponse> listInvocationSteps(
            Consumer<ListInvocationStepsRequest.Builder> listInvocationStepsRequest) {
        return listInvocationSteps(ListInvocationStepsRequest.builder().applyMutation(listInvocationStepsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsPublisher publisher = client.listInvocationStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsPublisher publisher = client.listInvocationStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvocationStepsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationStepsPublisher listInvocationStepsPaginator(ListInvocationStepsRequest listInvocationStepsRequest) {
        return new ListInvocationStepsPublisher(this, listInvocationStepsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsPublisher publisher = client.listInvocationStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationStepsPublisher publisher = client.listInvocationStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocationSteps(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationStepsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInvocationStepsRequest#builder()}
     * </p>
     *
     * @param listInvocationStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationStepsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocationSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocationSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationStepsPublisher listInvocationStepsPaginator(
            Consumer<ListInvocationStepsRequest.Builder> listInvocationStepsRequest) {
        return listInvocationStepsPaginator(ListInvocationStepsRequest.builder().applyMutation(listInvocationStepsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all invocations associated with a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param listInvocationsRequest
     * @return A Java Future containing the result of the ListInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvocationsResponse> listInvocations(ListInvocationsRequest listInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all invocations associated with a specific session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvocationsRequest#builder()}
     * </p>
     *
     * @param listInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvocationsResponse> listInvocations(
            Consumer<ListInvocationsRequest.Builder> listInvocationsRequest) {
        return listInvocations(ListInvocationsRequest.builder().applyMutation(listInvocationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsPublisher publisher = client.listInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsPublisher publisher = client.listInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationsPublisher listInvocationsPaginator(ListInvocationsRequest listInvocationsRequest) {
        return new ListInvocationsPublisher(this, listInvocationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsPublisher publisher = client.listInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListInvocationsPublisher publisher = client.listInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvocations(software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvocationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvocationsRequest#builder()}
     * </p>
     *
     * @param listInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListInvocationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvocationsPublisher listInvocationsPaginator(Consumer<ListInvocationsRequest.Builder> listInvocationsRequest) {
        return listInvocationsPaginator(ListInvocationsRequest.builder().applyMutation(listInvocationsRequest).build());
    }

    /**
     * <p>
     * Lists all sessions in your Amazon Web Services account. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param listSessionsRequest
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(ListSessionsRequest listSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all sessions in your Amazon Web Services account. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSessionsResponse> listSessions(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessions(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(ListSessionsRequest listSessionsRequest) {
        return new ListSessionsPublisher(this, listSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.ListSessionsPublisher publisher = client.listSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSessions(software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSessionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSessionsRequest#builder()}
     * </p>
     *
     * @param listSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSessionsPublisher listSessionsPaginator(Consumer<ListSessionsRequest.Builder> listSessionsRequest) {
        return listSessionsPaginator(ListSessionsRequest.builder().applyMutation(listSessionsRequest).build());
    }

    /**
     * <p>
     * List all the tags for the resource you specify.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the tags for the resource you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Optimizes a prompt for the task that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-optimize.html">Optimize a prompt</a>
     * in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     *
     * @param optimizePromptRequest
     * @return A Java Future containing the result of the OptimizePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.OptimizePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/OptimizePrompt"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> optimizePrompt(OptimizePromptRequest optimizePromptRequest,
            OptimizePromptResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Optimizes a prompt for the task that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-optimize.html">Optimize a prompt</a>
     * in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User
     * Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OptimizePromptRequest.Builder} avoiding the need to
     * create one manually via {@link OptimizePromptRequest#builder()}
     * </p>
     *
     * @param optimizePromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the OptimizePrompt operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.OptimizePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/OptimizePrompt"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> optimizePrompt(Consumer<OptimizePromptRequest.Builder> optimizePromptRequest,
            OptimizePromptResponseHandler asyncResponseHandler) {
        return optimizePrompt(OptimizePromptRequest.builder().applyMutation(optimizePromptRequest).build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Add an invocation step to an invocation in a session. An invocation step stores fine-grained state checkpoints,
     * including text and images, for each interaction. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html">
     * GetInvocationStep</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocationSteps.html">
     * ListInvocationSteps</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListSessions</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param putInvocationStepRequest
     * @return A Java Future containing the result of the PutInvocationStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.PutInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/PutInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInvocationStepResponse> putInvocationStep(PutInvocationStepRequest putInvocationStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add an invocation step to an invocation in a session. An invocation step stores fine-grained state checkpoints,
     * including text and images, for each interaction. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <p>
     * Related APIs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_GetInvocationStep.html">
     * GetInvocationStep</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocationSteps.html">
     * ListInvocationSteps</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListInvocations</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_ListInvocations.html">
     * ListSessions</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInvocationStepRequest.Builder} avoiding the need
     * to create one manually via {@link PutInvocationStepRequest#builder()}
     * </p>
     *
     * @param putInvocationStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.PutInvocationStepRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutInvocationStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.PutInvocationStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/PutInvocationStep"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInvocationStepResponse> putInvocationStep(
            Consumer<PutInvocationStepRequest.Builder> putInvocationStepRequest) {
        return putInvocationStep(PutInvocationStepRequest.builder().applyMutation(putInvocationStepRequest).build());
    }

    /**
     * <p>
     * Reranks the relevance of sources based on queries. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html">Improve the relevance of query responses
     * with a reranker model</a>.
     * </p>
     *
     * @param rerankRequest
     * @return A Java Future containing the result of the Rerank operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RerankResponse> rerank(RerankRequest rerankRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reranks the relevance of sources based on queries. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html">Improve the relevance of query responses
     * with a reranker model</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RerankRequest.Builder} avoiding the need to create
     * one manually via {@link RerankRequest#builder()}
     * </p>
     *
     * @param rerankRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the Rerank operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RerankResponse> rerank(Consumer<RerankRequest.Builder> rerankRequest) {
        return rerank(RerankRequest.builder().applyMutation(rerankRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)} operation.</b>
     * </p>
     *
     * @param rerankRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankPublisher rerankPaginator(RerankRequest rerankRequest) {
        return new RerankPublisher(this, rerankRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RerankPublisher publisher = client.rerankPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RerankResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #rerank(software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RerankRequest.Builder} avoiding the need to create
     * one manually via {@link RerankRequest#builder()}
     * </p>
     *
     * @param rerankRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RerankRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Rerank
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Rerank" target="_top">AWS
     *      API Documentation</a>
     */
    default RerankPublisher rerankPaginator(Consumer<RerankRequest.Builder> rerankRequest) {
        return rerankPaginator(RerankRequest.builder().applyMutation(rerankRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     *
     * @param retrieveRequest
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(RetrieveRequest retrieveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and retrieves information from it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the Retrieve operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveResponse> retrieve(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrieve(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results and using the specified
     * foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>.
     * The response only cites sources that are relevant to the query.
     * </p>
     *
     * @param retrieveAndGenerateRequest
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            RetrieveAndGenerateRequest retrieveAndGenerateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results and using the specified
     * foundation model or <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a>.
     * The response only cites sources that are relevant to the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateRequest.Builder} avoiding the
     * need to create one manually via {@link RetrieveAndGenerateRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RetrieveAndGenerate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RetrieveAndGenerateResponse> retrieveAndGenerate(
            Consumer<RetrieveAndGenerateRequest.Builder> retrieveAndGenerateRequest) {
        return retrieveAndGenerate(RetrieveAndGenerateRequest.builder().applyMutation(retrieveAndGenerateRequest).build());
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results, with output in streaming format.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including
     * <code>InvokeModelWithResponseStream</code>.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code> bedrock:RetrieveAndGenerate</code> action.
     * </p>
     *
     * @param retrieveAndGenerateStreamRequest
     * @return A Java Future containing the result of the RetrieveAndGenerateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> retrieveAndGenerateStream(RetrieveAndGenerateStreamRequest retrieveAndGenerateStreamRequest,
            RetrieveAndGenerateStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Queries a knowledge base and generates responses based on the retrieved results, with output in streaming format.
     * </p>
     * <note>
     * <p>
     * The CLI doesn't support streaming operations in Amazon Bedrock, including
     * <code>InvokeModelWithResponseStream</code>.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code> bedrock:RetrieveAndGenerate</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveAndGenerateStreamRequest.Builder} avoiding
     * the need to create one manually via {@link RetrieveAndGenerateStreamRequest#builder()}
     * </p>
     *
     * @param retrieveAndGenerateStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveAndGenerateStreamRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RetrieveAndGenerateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.RetrieveAndGenerateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RetrieveAndGenerateStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> retrieveAndGenerateStream(
            Consumer<RetrieveAndGenerateStreamRequest.Builder> retrieveAndGenerateStreamRequest,
            RetrieveAndGenerateStreamResponseHandler asyncResponseHandler) {
        return retrieveAndGenerateStream(
                RetrieveAndGenerateStreamRequest.builder().applyMutation(retrieveAndGenerateStreamRequest).build(),
                asyncResponseHandler);
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     *
     * @param retrieveRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(RetrieveRequest retrieveRequest) {
        return new RetrievePublisher(this, retrieveRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bedrockagentruntime.paginators.RetrievePublisher publisher = client.retrievePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #retrieve(software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetrieveRequest.Builder} avoiding the need to
     * create one manually via {@link RetrieveRequest#builder()}
     * </p>
     *
     * @param retrieveRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>DependencyFailedException There was an issue with a dependency. Check the resource configurations and
     *         retry the request.</li>
     *         <li>BadGatewayException There was an issue with a dependency due to a server issue. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.Retrieve
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/Retrieve"
     *      target="_top">AWS API Documentation</a>
     */
    default RetrievePublisher retrievePaginator(Consumer<RetrieveRequest.Builder> retrieveRequest) {
        return retrievePaginator(RetrieveRequest.builder().applyMutation(retrieveRequest).build());
    }

    /**
     * <p>
     * Associate tags with a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the
     * Amazon Bedrock User Guide.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate tags with a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Tagging resources</a> in the
     * Amazon Bedrock User Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>ServiceQuotaExceededException The number of requests exceeds the service quota. Resubmit your request
     *         later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the metadata or encryption settings of a session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     *
     * @param updateSessionRequest
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UpdateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSessionResponse> updateSession(UpdateSessionRequest updateSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata or encryption settings of a session. For more information about sessions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/sessions.html">Store and retrieve conversation history
     * and context with Amazon Bedrock sessions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSessionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSessionRequest#builder()}
     * </p>
     *
     * @param updateSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.UpdateSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict performing an operation. Resolve the conflict and retry your
     *         request.</li>
     *         <li>ResourceNotFoundException The specified resource Amazon Resource Name (ARN) was not found. Check the
     *         Amazon Resource Name (ARN) and try your request again.</li>
     *         <li>ValidationException Input validation failed. Check your request parameters and retry the request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>AccessDeniedException The request is denied because of missing access permissions. Check your
     *         permissions and retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BedrockAgentRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample BedrockAgentRuntimeAsyncClient.UpdateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/UpdateSession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSessionResponse> updateSession(Consumer<UpdateSessionRequest.Builder> updateSessionRequest) {
        return updateSession(UpdateSessionRequest.builder().applyMutation(updateSessionRequest).build());
    }

    @Override
    default BedrockAgentRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BedrockAgentRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BedrockAgentRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BedrockAgentRuntimeAsyncClient}.
     */
    static BedrockAgentRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockAgentRuntimeAsyncClientBuilder();
    }
}
