/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of inline collaborators.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Collaborator implements SdkPojo, Serializable, ToCopyableBuilder<Collaborator.Builder, Collaborator> {
    private static final SdkField<List<AgentActionGroup>> ACTION_GROUPS_FIELD = SdkField
            .<List<AgentActionGroup>> builder(MarshallingType.LIST)
            .memberName("actionGroups")
            .getter(getter(Collaborator::actionGroups))
            .setter(setter(Builder::actionGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentActionGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentActionGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGENT_COLLABORATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboration").getter(getter(Collaborator::agentCollaborationAsString))
            .setter(setter(Builder::agentCollaboration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboration").build())
            .build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentName").getter(getter(Collaborator::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()).build();

    private static final SdkField<List<CollaboratorConfiguration>> COLLABORATOR_CONFIGURATIONS_FIELD = SdkField
            .<List<CollaboratorConfiguration>> builder(MarshallingType.LIST)
            .memberName("collaboratorConfigurations")
            .getter(getter(Collaborator::collaboratorConfigurations))
            .setter(setter(Builder::collaboratorConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaboratorConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaboratorConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyArn").getter(getter(Collaborator::customerEncryptionKeyArn))
            .setter(setter(Builder::customerEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build())
            .build();

    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("foundationModel").getter(getter(Collaborator::foundationModel)).setter(setter(Builder::foundationModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()).build();

    private static final SdkField<GuardrailConfigurationWithArn> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfigurationWithArn> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(Collaborator::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfigurationWithArn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds")
            .getter(getter(Collaborator::idleSessionTTLInSeconds)).setter(setter(Builder::idleSessionTTLInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build())
            .build();

    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instruction").getter(getter(Collaborator::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<List<KnowledgeBase>> KNOWLEDGE_BASES_FIELD = SdkField
            .<List<KnowledgeBase>> builder(MarshallingType.LIST)
            .memberName("knowledgeBases")
            .getter(getter(Collaborator::knowledgeBases))
            .setter(setter(Builder::knowledgeBases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KnowledgeBase> builder(MarshallingType.SDK_POJO)
                                            .constructor(KnowledgeBase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField
            .<PromptOverrideConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("promptOverrideConfiguration")
            .getter(getter(Collaborator::promptOverrideConfiguration))
            .setter(setter(Builder::promptOverrideConfiguration))
            .constructor(PromptOverrideConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUPS_FIELD,
            AGENT_COLLABORATION_FIELD, AGENT_NAME_FIELD, COLLABORATOR_CONFIGURATIONS_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD,
            FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, INSTRUCTION_FIELD,
            KNOWLEDGE_BASES_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AgentActionGroup> actionGroups;

    private final String agentCollaboration;

    private final String agentName;

    private final List<CollaboratorConfiguration> collaboratorConfigurations;

    private final String customerEncryptionKeyArn;

    private final String foundationModel;

    private final GuardrailConfigurationWithArn guardrailConfiguration;

    private final Integer idleSessionTTLInSeconds;

    private final String instruction;

    private final List<KnowledgeBase> knowledgeBases;

    private final PromptOverrideConfiguration promptOverrideConfiguration;

    private Collaborator(BuilderImpl builder) {
        this.actionGroups = builder.actionGroups;
        this.agentCollaboration = builder.agentCollaboration;
        this.agentName = builder.agentName;
        this.collaboratorConfigurations = builder.collaboratorConfigurations;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.instruction = builder.instruction;
        this.knowledgeBases = builder.knowledgeBases;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionGroups() {
        return actionGroups != null && !(actionGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of action groups with each action group defining tasks the inline collaborator agent needs to carry out.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionGroups} method.
     * </p>
     * 
     * @return List of action groups with each action group defining tasks the inline collaborator agent needs to carry
     *         out.
     */
    public final List<AgentActionGroup> actionGroups() {
        return actionGroups;
    }

    /**
     * <p>
     * Defines how the inline supervisor agent handles information across multiple collaborator agents to coordinate a
     * final response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentCollaboration} will return {@link AgentCollaboration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #agentCollaborationAsString}.
     * </p>
     * 
     * @return Defines how the inline supervisor agent handles information across multiple collaborator agents to
     *         coordinate a final response.
     * @see AgentCollaboration
     */
    public final AgentCollaboration agentCollaboration() {
        return AgentCollaboration.fromValue(agentCollaboration);
    }

    /**
     * <p>
     * Defines how the inline supervisor agent handles information across multiple collaborator agents to coordinate a
     * final response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentCollaboration} will return {@link AgentCollaboration#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #agentCollaborationAsString}.
     * </p>
     * 
     * @return Defines how the inline supervisor agent handles information across multiple collaborator agents to
     *         coordinate a final response.
     * @see AgentCollaboration
     */
    public final String agentCollaborationAsString() {
        return agentCollaboration;
    }

    /**
     * <p>
     * Name of the inline collaborator agent which must be the same name as specified for <code>collaboratorName</code>.
     * </p>
     * 
     * @return Name of the inline collaborator agent which must be the same name as specified for
     *         <code>collaboratorName</code>.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaboratorConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCollaboratorConfigurations() {
        return collaboratorConfigurations != null && !(collaboratorConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Settings of the collaborator agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaboratorConfigurations} method.
     * </p>
     * 
     * @return Settings of the collaborator agent.
     */
    public final List<CollaboratorConfiguration> collaboratorConfigurations() {
        return collaboratorConfigurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the inline collaborator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the inline collaborator.
     */
    public final String customerEncryptionKeyArn() {
        return customerEncryptionKeyArn;
    }

    /**
     * <p>
     * The foundation model used by the inline collaborator agent.
     * </p>
     * 
     * @return The foundation model used by the inline collaborator agent.
     */
    public final String foundationModel() {
        return foundationModel;
    }

    /**
     * <p>
     * Details of the guardwrail associated with the inline collaborator.
     * </p>
     * 
     * @return Details of the guardwrail associated with the inline collaborator.
     */
    public final GuardrailConfigurationWithArn guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * The number of seconds for which the Amazon Bedrock keeps information about the user's conversation with the
     * inline collaborator agent.
     * </p>
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time,
     * the session expires and Amazon Bedrock deletes any data provided before the timeout.
     * </p>
     * 
     * @return The number of seconds for which the Amazon Bedrock keeps information about the user's conversation with
     *         the inline collaborator agent.</p>
     *         <p>
     *         A user interaction remains active for the amount of time specified. If no conversation occurs during this
     *         time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
     */
    public final Integer idleSessionTTLInSeconds() {
        return idleSessionTTLInSeconds;
    }

    /**
     * <p>
     * Instruction that tell the inline collaborator agent what it should do and how it should interact with users.
     * </p>
     * 
     * @return Instruction that tell the inline collaborator agent what it should do and how it should interact with
     *         users.
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * For responses, this returns true if the service returned a value for the KnowledgeBases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKnowledgeBases() {
        return knowledgeBases != null && !(knowledgeBases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Knowledge base associated with the inline collaborator agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKnowledgeBases} method.
     * </p>
     * 
     * @return Knowledge base associated with the inline collaborator agent.
     */
    public final List<KnowledgeBase> knowledgeBases() {
        return knowledgeBases;
    }

    /**
     * <p>
     * Contains configurations to override prompt templates in different parts of an inline collaborator sequence. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     * </p>
     * 
     * @return Contains configurations to override prompt templates in different parts of an inline collaborator
     *         sequence. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
     */
    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return promptOverrideConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActionGroups() ? actionGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaborationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCollaboratorConfigurations() ? collaboratorConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(hasKnowledgeBases() ? knowledgeBases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(promptOverrideConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Collaborator)) {
            return false;
        }
        Collaborator other = (Collaborator) obj;
        return hasActionGroups() == other.hasActionGroups() && Objects.equals(actionGroups(), other.actionGroups())
                && Objects.equals(agentCollaborationAsString(), other.agentCollaborationAsString())
                && Objects.equals(agentName(), other.agentName())
                && hasCollaboratorConfigurations() == other.hasCollaboratorConfigurations()
                && Objects.equals(collaboratorConfigurations(), other.collaboratorConfigurations())
                && Objects.equals(customerEncryptionKeyArn(), other.customerEncryptionKeyArn())
                && Objects.equals(foundationModel(), other.foundationModel())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds())
                && Objects.equals(instruction(), other.instruction()) && hasKnowledgeBases() == other.hasKnowledgeBases()
                && Objects.equals(knowledgeBases(), other.knowledgeBases())
                && Objects.equals(promptOverrideConfiguration(), other.promptOverrideConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Collaborator")
                .add("ActionGroups", hasActionGroups() ? actionGroups() : null)
                .add("AgentCollaboration", agentCollaborationAsString())
                .add("AgentName", agentName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CollaboratorConfigurations", hasCollaboratorConfigurations() ? collaboratorConfigurations() : null)
                .add("CustomerEncryptionKeyArn", customerEncryptionKeyArn())
                .add("FoundationModel", foundationModel())
                .add("GuardrailConfiguration", guardrailConfiguration())
                .add("IdleSessionTTLInSeconds", idleSessionTTLInSeconds())
                .add("Instruction", instruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("KnowledgeBases", hasKnowledgeBases() ? knowledgeBases() : null)
                .add("PromptOverrideConfiguration",
                        promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroups":
            return Optional.ofNullable(clazz.cast(actionGroups()));
        case "agentCollaboration":
            return Optional.ofNullable(clazz.cast(agentCollaborationAsString()));
        case "agentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "collaboratorConfigurations":
            return Optional.ofNullable(clazz.cast(collaboratorConfigurations()));
        case "customerEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyArn()));
        case "foundationModel":
            return Optional.ofNullable(clazz.cast(foundationModel()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "idleSessionTTLInSeconds":
            return Optional.ofNullable(clazz.cast(idleSessionTTLInSeconds()));
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "knowledgeBases":
            return Optional.ofNullable(clazz.cast(knowledgeBases()));
        case "promptOverrideConfiguration":
            return Optional.ofNullable(clazz.cast(promptOverrideConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionGroups", ACTION_GROUPS_FIELD);
        map.put("agentCollaboration", AGENT_COLLABORATION_FIELD);
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("collaboratorConfigurations", COLLABORATOR_CONFIGURATIONS_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("knowledgeBases", KNOWLEDGE_BASES_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Collaborator, T> g) {
        return obj -> g.apply((Collaborator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Collaborator> {
        /**
         * <p>
         * List of action groups with each action group defining tasks the inline collaborator agent needs to carry out.
         * </p>
         * 
         * @param actionGroups
         *        List of action groups with each action group defining tasks the inline collaborator agent needs to
         *        carry out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroups(Collection<AgentActionGroup> actionGroups);

        /**
         * <p>
         * List of action groups with each action group defining tasks the inline collaborator agent needs to carry out.
         * </p>
         * 
         * @param actionGroups
         *        List of action groups with each action group defining tasks the inline collaborator agent needs to
         *        carry out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroups(AgentActionGroup... actionGroups);

        /**
         * <p>
         * List of action groups with each action group defining tasks the inline collaborator agent needs to carry out.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #actionGroups(List<AgentActionGroup>)}.
         * 
         * @param actionGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.AgentActionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroups(java.util.Collection<AgentActionGroup>)
         */
        Builder actionGroups(Consumer<AgentActionGroup.Builder>... actionGroups);

        /**
         * <p>
         * Defines how the inline supervisor agent handles information across multiple collaborator agents to coordinate
         * a final response.
         * </p>
         * 
         * @param agentCollaboration
         *        Defines how the inline supervisor agent handles information across multiple collaborator agents to
         *        coordinate a final response.
         * @see AgentCollaboration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentCollaboration
         */
        Builder agentCollaboration(String agentCollaboration);

        /**
         * <p>
         * Defines how the inline supervisor agent handles information across multiple collaborator agents to coordinate
         * a final response.
         * </p>
         * 
         * @param agentCollaboration
         *        Defines how the inline supervisor agent handles information across multiple collaborator agents to
         *        coordinate a final response.
         * @see AgentCollaboration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentCollaboration
         */
        Builder agentCollaboration(AgentCollaboration agentCollaboration);

        /**
         * <p>
         * Name of the inline collaborator agent which must be the same name as specified for
         * <code>collaboratorName</code>.
         * </p>
         * 
         * @param agentName
         *        Name of the inline collaborator agent which must be the same name as specified for
         *        <code>collaboratorName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * <p>
         * Settings of the collaborator agent.
         * </p>
         * 
         * @param collaboratorConfigurations
         *        Settings of the collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorConfigurations(Collection<CollaboratorConfiguration> collaboratorConfigurations);

        /**
         * <p>
         * Settings of the collaborator agent.
         * </p>
         * 
         * @param collaboratorConfigurations
         *        Settings of the collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorConfigurations(CollaboratorConfiguration... collaboratorConfigurations);

        /**
         * <p>
         * Settings of the collaborator agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #collaboratorConfigurations(List<CollaboratorConfiguration>)}.
         * 
         * @param collaboratorConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.CollaboratorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaboratorConfigurations(java.util.Collection<CollaboratorConfiguration>)
         */
        Builder collaboratorConfigurations(Consumer<CollaboratorConfiguration.Builder>... collaboratorConfigurations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the inline collaborator.
         * </p>
         * 
         * @param customerEncryptionKeyArn
         *        The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the inline collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyArn(String customerEncryptionKeyArn);

        /**
         * <p>
         * The foundation model used by the inline collaborator agent.
         * </p>
         * 
         * @param foundationModel
         *        The foundation model used by the inline collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder foundationModel(String foundationModel);

        /**
         * <p>
         * Details of the guardwrail associated with the inline collaborator.
         * </p>
         * 
         * @param guardrailConfiguration
         *        Details of the guardwrail associated with the inline collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration);

        /**
         * <p>
         * Details of the guardwrail associated with the inline collaborator.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfigurationWithArn.Builder}
         * avoiding the need to create one manually via {@link GuardrailConfigurationWithArn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfigurationWithArn.Builder#build()} is called
         * immediately and its result is passed to {@link #guardrailConfiguration(GuardrailConfigurationWithArn)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfigurationWithArn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfigurationWithArn)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfigurationWithArn.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfigurationWithArn.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * The number of seconds for which the Amazon Bedrock keeps information about the user's conversation with the
         * inline collaborator agent.
         * </p>
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this
         * time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
         * </p>
         * 
         * @param idleSessionTTLInSeconds
         *        The number of seconds for which the Amazon Bedrock keeps information about the user's conversation
         *        with the inline collaborator agent.</p>
         *        <p>
         *        A user interaction remains active for the amount of time specified. If no conversation occurs during
         *        this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds);

        /**
         * <p>
         * Instruction that tell the inline collaborator agent what it should do and how it should interact with users.
         * </p>
         * 
         * @param instruction
         *        Instruction that tell the inline collaborator agent what it should do and how it should interact with
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * Knowledge base associated with the inline collaborator agent.
         * </p>
         * 
         * @param knowledgeBases
         *        Knowledge base associated with the inline collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases);

        /**
         * <p>
         * Knowledge base associated with the inline collaborator agent.
         * </p>
         * 
         * @param knowledgeBases
         *        Knowledge base associated with the inline collaborator agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBases(KnowledgeBase... knowledgeBases);

        /**
         * <p>
         * Knowledge base associated with the inline collaborator agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBases(List<KnowledgeBase>)}.
         * 
         * @param knowledgeBases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBases(java.util.Collection<KnowledgeBase>)
         */
        Builder knowledgeBases(Consumer<KnowledgeBase.Builder>... knowledgeBases);

        /**
         * <p>
         * Contains configurations to override prompt templates in different parts of an inline collaborator sequence.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
         * </p>
         * 
         * @param promptOverrideConfiguration
         *        Contains configurations to override prompt templates in different parts of an inline collaborator
         *        sequence. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced
         *        prompts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration);

        /**
         * <p>
         * Contains configurations to override prompt templates in different parts of an inline collaborator sequence.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptOverrideConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptOverrideConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptOverrideConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #promptOverrideConfiguration(PromptOverrideConfiguration)}.
         * 
         * @param promptOverrideConfiguration
         *        a consumer that will call methods on {@link PromptOverrideConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptOverrideConfiguration(PromptOverrideConfiguration)
         */
        default Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return promptOverrideConfiguration(PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AgentActionGroup> actionGroups = DefaultSdkAutoConstructList.getInstance();

        private String agentCollaboration;

        private String agentName;

        private List<CollaboratorConfiguration> collaboratorConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String customerEncryptionKeyArn;

        private String foundationModel;

        private GuardrailConfigurationWithArn guardrailConfiguration;

        private Integer idleSessionTTLInSeconds;

        private String instruction;

        private List<KnowledgeBase> knowledgeBases = DefaultSdkAutoConstructList.getInstance();

        private PromptOverrideConfiguration promptOverrideConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Collaborator model) {
            actionGroups(model.actionGroups);
            agentCollaboration(model.agentCollaboration);
            agentName(model.agentName);
            collaboratorConfigurations(model.collaboratorConfigurations);
            customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            foundationModel(model.foundationModel);
            guardrailConfiguration(model.guardrailConfiguration);
            idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            instruction(model.instruction);
            knowledgeBases(model.knowledgeBases);
            promptOverrideConfiguration(model.promptOverrideConfiguration);
        }

        public final List<AgentActionGroup.Builder> getActionGroups() {
            List<AgentActionGroup.Builder> result = AgentActionGroupsCopier.copyToBuilder(this.actionGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionGroups(Collection<AgentActionGroup.BuilderImpl> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copyFromBuilder(actionGroups);
        }

        @Override
        public final Builder actionGroups(Collection<AgentActionGroup> actionGroups) {
            this.actionGroups = AgentActionGroupsCopier.copy(actionGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(AgentActionGroup... actionGroups) {
            actionGroups(Arrays.asList(actionGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroups(Consumer<AgentActionGroup.Builder>... actionGroups) {
            actionGroups(Stream.of(actionGroups).map(c -> AgentActionGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAgentCollaboration() {
            return agentCollaboration;
        }

        public final void setAgentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
        }

        @Override
        public final Builder agentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
            return this;
        }

        @Override
        public final Builder agentCollaboration(AgentCollaboration agentCollaboration) {
            this.agentCollaboration(agentCollaboration == null ? null : agentCollaboration.toString());
            return this;
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final List<CollaboratorConfiguration.Builder> getCollaboratorConfigurations() {
            List<CollaboratorConfiguration.Builder> result = CollaboratorConfigurationsCopier
                    .copyToBuilder(this.collaboratorConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaboratorConfigurations(
                Collection<CollaboratorConfiguration.BuilderImpl> collaboratorConfigurations) {
            this.collaboratorConfigurations = CollaboratorConfigurationsCopier.copyFromBuilder(collaboratorConfigurations);
        }

        @Override
        public final Builder collaboratorConfigurations(Collection<CollaboratorConfiguration> collaboratorConfigurations) {
            this.collaboratorConfigurations = CollaboratorConfigurationsCopier.copy(collaboratorConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaboratorConfigurations(CollaboratorConfiguration... collaboratorConfigurations) {
            collaboratorConfigurations(Arrays.asList(collaboratorConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaboratorConfigurations(Consumer<CollaboratorConfiguration.Builder>... collaboratorConfigurations) {
            collaboratorConfigurations(Stream.of(collaboratorConfigurations)
                    .map(c -> CollaboratorConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getFoundationModel() {
            return foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfigurationWithArn.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfigurationWithArn.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfigurationWithArn guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final List<KnowledgeBase.Builder> getKnowledgeBases() {
            List<KnowledgeBase.Builder> result = KnowledgeBasesCopier.copyToBuilder(this.knowledgeBases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKnowledgeBases(Collection<KnowledgeBase.BuilderImpl> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copyFromBuilder(knowledgeBases);
        }

        @Override
        public final Builder knowledgeBases(Collection<KnowledgeBase> knowledgeBases) {
            this.knowledgeBases = KnowledgeBasesCopier.copy(knowledgeBases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(KnowledgeBase... knowledgeBases) {
            knowledgeBases(Arrays.asList(knowledgeBases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder knowledgeBases(Consumer<KnowledgeBase.Builder>... knowledgeBases) {
            knowledgeBases(Stream.of(knowledgeBases).map(c -> KnowledgeBase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return promptOverrideConfiguration != null ? promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        @Override
        public Collaborator build() {
            return new Collaborator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
