/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateQueryResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<GenerateQueryResponse.Builder, GenerateQueryResponse> {
    private static final SdkField<List<GeneratedQuery>> QUERIES_FIELD = SdkField
            .<List<GeneratedQuery>> builder(MarshallingType.LIST)
            .memberName("queries")
            .getter(getter(GenerateQueryResponse::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeneratedQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeneratedQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GeneratedQuery> queries;

    private GenerateQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queries = builder.queries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which defines a generated query that can correspond to the natural language queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return A list of objects, each of which defines a generated query that can correspond to the natural language
     *         queries.
     */
    public final List<GeneratedQuery> queries() {
        return queries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateQueryResponse)) {
            return false;
        }
        GenerateQueryResponse other = (GenerateQueryResponse) obj;
        return hasQueries() == other.hasQueries() && Objects.equals(queries(), other.queries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateQueryResponse")
                .add("Queries", queries() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queries":
            return Optional.ofNullable(clazz.cast(queries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queries", QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateQueryResponse, T> g) {
        return obj -> g.apply((GenerateQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateQueryResponse> {
        /**
         * <p>
         * A list of objects, each of which defines a generated query that can correspond to the natural language
         * queries.
         * </p>
         * 
         * @param queries
         *        A list of objects, each of which defines a generated query that can correspond to the natural language
         *        queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<GeneratedQuery> queries);

        /**
         * <p>
         * A list of objects, each of which defines a generated query that can correspond to the natural language
         * queries.
         * </p>
         * 
         * @param queries
         *        A list of objects, each of which defines a generated query that can correspond to the natural language
         *        queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(GeneratedQuery... queries);

        /**
         * <p>
         * A list of objects, each of which defines a generated query that can correspond to the natural language
         * queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GeneratedQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GeneratedQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.GeneratedQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #queries(List<GeneratedQuery>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.GeneratedQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<GeneratedQuery>)
         */
        Builder queries(Consumer<GeneratedQuery.Builder>... queries);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private List<GeneratedQuery> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateQueryResponse model) {
            super(model);
            queries(model.queries);
        }

        public final List<GeneratedQuery.Builder> getQueries() {
            List<GeneratedQuery.Builder> result = GeneratedQueriesCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<GeneratedQuery.BuilderImpl> queries) {
            this.queries = GeneratedQueriesCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<GeneratedQuery> queries) {
            this.queries = GeneratedQueriesCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(GeneratedQuery... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<GeneratedQuery.Builder>... queries) {
            queries(Stream.of(queries).map(c -> GeneratedQuery.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GenerateQueryResponse build() {
            return new GenerateQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
