/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvocationStepResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<GetInvocationStepResponse.Builder, GetInvocationStepResponse> {
    private static final SdkField<InvocationStep> INVOCATION_STEP_FIELD = SdkField
            .<InvocationStep> builder(MarshallingType.SDK_POJO).memberName("invocationStep")
            .getter(getter(GetInvocationStepResponse::invocationStep)).setter(setter(Builder::invocationStep))
            .constructor(InvocationStep::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationStep").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_STEP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InvocationStep invocationStep;

    private GetInvocationStepResponse(BuilderImpl builder) {
        super(builder);
        this.invocationStep = builder.invocationStep;
    }

    /**
     * <p>
     * The complete details of the requested invocation step.
     * </p>
     * 
     * @return The complete details of the requested invocation step.
     */
    public final InvocationStep invocationStep() {
        return invocationStep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invocationStep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvocationStepResponse)) {
            return false;
        }
        GetInvocationStepResponse other = (GetInvocationStepResponse) obj;
        return Objects.equals(invocationStep(), other.invocationStep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvocationStepResponse").add("InvocationStep", invocationStep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationStep":
            return Optional.ofNullable(clazz.cast(invocationStep()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationStep", INVOCATION_STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvocationStepResponse, T> g) {
        return obj -> g.apply((GetInvocationStepResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInvocationStepResponse> {
        /**
         * <p>
         * The complete details of the requested invocation step.
         * </p>
         * 
         * @param invocationStep
         *        The complete details of the requested invocation step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationStep(InvocationStep invocationStep);

        /**
         * <p>
         * The complete details of the requested invocation step.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvocationStep.Builder} avoiding the need
         * to create one manually via {@link InvocationStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvocationStep.Builder#build()} is called immediately and its
         * result is passed to {@link #invocationStep(InvocationStep)}.
         * 
         * @param invocationStep
         *        a consumer that will call methods on {@link InvocationStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invocationStep(InvocationStep)
         */
        default Builder invocationStep(Consumer<InvocationStep.Builder> invocationStep) {
            return invocationStep(InvocationStep.builder().applyMutation(invocationStep).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private InvocationStep invocationStep;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvocationStepResponse model) {
            super(model);
            invocationStep(model.invocationStep);
        }

        public final InvocationStep.Builder getInvocationStep() {
            return invocationStep != null ? invocationStep.toBuilder() : null;
        }

        public final void setInvocationStep(InvocationStep.BuilderImpl invocationStep) {
            this.invocationStep = invocationStep != null ? invocationStep.build() : null;
        }

        @Override
        public final Builder invocationStep(InvocationStep invocationStep) {
            this.invocationStep = invocationStep;
            return this;
        }

        @Override
        public GetInvocationStepResponse build() {
            return new GetInvocationStepResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
