/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for implicit filtering, where a model generates a metadata filter based on the prompt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImplicitFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImplicitFilterConfiguration.Builder, ImplicitFilterConfiguration> {
    private static final SdkField<List<MetadataAttributeSchema>> METADATA_ATTRIBUTES_FIELD = SdkField
            .<List<MetadataAttributeSchema>> builder(MarshallingType.LIST)
            .memberName("metadataAttributes")
            .getter(getter(ImplicitFilterConfiguration::metadataAttributes))
            .setter(setter(Builder::metadataAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataAttributeSchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataAttributeSchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(ImplicitFilterConfiguration::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_ATTRIBUTES_FIELD,
            MODEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MetadataAttributeSchema> metadataAttributes;

    private final String modelArn;

    private ImplicitFilterConfiguration(BuilderImpl builder) {
        this.metadataAttributes = builder.metadataAttributes;
        this.modelArn = builder.modelArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetadataAttributes() {
        return metadataAttributes != null && !(metadataAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used in a filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataAttributes} method.
     * </p>
     * 
     * @return Metadata that can be used in a filter.
     */
    public final List<MetadataAttributeSchema> metadataAttributes() {
        return metadataAttributes;
    }

    /**
     * <p>
     * The model that generates the filter.
     * </p>
     * 
     * @return The model that generates the filter.
     */
    public final String modelArn() {
        return modelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataAttributes() ? metadataAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImplicitFilterConfiguration)) {
            return false;
        }
        ImplicitFilterConfiguration other = (ImplicitFilterConfiguration) obj;
        return hasMetadataAttributes() == other.hasMetadataAttributes()
                && Objects.equals(metadataAttributes(), other.metadataAttributes())
                && Objects.equals(modelArn(), other.modelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImplicitFilterConfiguration")
                .add("MetadataAttributes", metadataAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelArn", modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataAttributes":
            return Optional.ofNullable(clazz.cast(metadataAttributes()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataAttributes", METADATA_ATTRIBUTES_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImplicitFilterConfiguration, T> g) {
        return obj -> g.apply((ImplicitFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImplicitFilterConfiguration> {
        /**
         * <p>
         * Metadata that can be used in a filter.
         * </p>
         * 
         * @param metadataAttributes
         *        Metadata that can be used in a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataAttributes(Collection<MetadataAttributeSchema> metadataAttributes);

        /**
         * <p>
         * Metadata that can be used in a filter.
         * </p>
         * 
         * @param metadataAttributes
         *        Metadata that can be used in a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataAttributes(MetadataAttributeSchema... metadataAttributes);

        /**
         * <p>
         * Metadata that can be used in a filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.MetadataAttributeSchema.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.MetadataAttributeSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.MetadataAttributeSchema.Builder#build()} is
         * called immediately and its result is passed to {@link #metadataAttributes(List<MetadataAttributeSchema>)}.
         * 
         * @param metadataAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.MetadataAttributeSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataAttributes(java.util.Collection<MetadataAttributeSchema>)
         */
        Builder metadataAttributes(Consumer<MetadataAttributeSchema.Builder>... metadataAttributes);

        /**
         * <p>
         * The model that generates the filter.
         * </p>
         * 
         * @param modelArn
         *        The model that generates the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);
    }

    static final class BuilderImpl implements Builder {
        private List<MetadataAttributeSchema> metadataAttributes = DefaultSdkAutoConstructList.getInstance();

        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ImplicitFilterConfiguration model) {
            metadataAttributes(model.metadataAttributes);
            modelArn(model.modelArn);
        }

        public final List<MetadataAttributeSchema.Builder> getMetadataAttributes() {
            List<MetadataAttributeSchema.Builder> result = MetadataAttributeSchemaListCopier
                    .copyToBuilder(this.metadataAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataAttributes(Collection<MetadataAttributeSchema.BuilderImpl> metadataAttributes) {
            this.metadataAttributes = MetadataAttributeSchemaListCopier.copyFromBuilder(metadataAttributes);
        }

        @Override
        public final Builder metadataAttributes(Collection<MetadataAttributeSchema> metadataAttributes) {
            this.metadataAttributes = MetadataAttributeSchemaListCopier.copy(metadataAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataAttributes(MetadataAttributeSchema... metadataAttributes) {
            metadataAttributes(Arrays.asList(metadataAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataAttributes(Consumer<MetadataAttributeSchema.Builder>... metadataAttributes) {
            metadataAttributes(Stream.of(metadataAttributes).map(c -> MetadataAttributeSchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        @Override
        public ImplicitFilterConfiguration build() {
            return new ImplicitFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
