/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for the metadata fields to include or exclude when considering reranking. If you include the
 * <code>fieldsToExclude</code> field, the reranker ignores all the metadata fields that you specify. If you include the
 * <code>fieldsToInclude</code> field, the reranker uses only the metadata fields that you specify and ignores all
 * others. You can include only one of these fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RerankingMetadataSelectiveModeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RerankingMetadataSelectiveModeConfiguration.Builder, RerankingMetadataSelectiveModeConfiguration> {
    private static final SdkField<List<FieldForReranking>> FIELDS_TO_EXCLUDE_FIELD = SdkField
            .<List<FieldForReranking>> builder(MarshallingType.LIST)
            .memberName("fieldsToExclude")
            .getter(getter(RerankingMetadataSelectiveModeConfiguration::fieldsToExclude))
            .setter(setter(Builder::fieldsToExclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldsToExclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldForReranking> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldForReranking::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FieldForReranking>> FIELDS_TO_INCLUDE_FIELD = SdkField
            .<List<FieldForReranking>> builder(MarshallingType.LIST)
            .memberName("fieldsToInclude")
            .getter(getter(RerankingMetadataSelectiveModeConfiguration::fieldsToInclude))
            .setter(setter(Builder::fieldsToInclude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldsToInclude").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldForReranking> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldForReranking::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELDS_TO_EXCLUDE_FIELD,
            FIELDS_TO_INCLUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FieldForReranking> fieldsToExclude;

    private final List<FieldForReranking> fieldsToInclude;

    private final Type type;

    private RerankingMetadataSelectiveModeConfiguration(BuilderImpl builder) {
        this.fieldsToExclude = builder.fieldsToExclude;
        this.fieldsToInclude = builder.fieldsToInclude;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldsToExclude property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldsToExclude() {
        return fieldsToExclude != null && !(fieldsToExclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which specifies a metadata field to exclude from consideration when reranking.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldsToExclude} method.
     * </p>
     * 
     * @return An array of objects, each of which specifies a metadata field to exclude from consideration when
     *         reranking.
     */
    public final List<FieldForReranking> fieldsToExclude() {
        return fieldsToExclude;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldsToInclude property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldsToInclude() {
        return fieldsToInclude != null && !(fieldsToInclude instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which specifies a metadata field to include in consideration when reranking. The
     * remaining metadata fields are ignored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldsToInclude} method.
     * </p>
     * 
     * @return An array of objects, each of which specifies a metadata field to include in consideration when reranking.
     *         The remaining metadata fields are ignored.
     */
    public final List<FieldForReranking> fieldsToInclude() {
        return fieldsToInclude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldsToExclude() ? fieldsToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldsToInclude() ? fieldsToInclude() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankingMetadataSelectiveModeConfiguration)) {
            return false;
        }
        RerankingMetadataSelectiveModeConfiguration other = (RerankingMetadataSelectiveModeConfiguration) obj;
        return hasFieldsToExclude() == other.hasFieldsToExclude() && Objects.equals(fieldsToExclude(), other.fieldsToExclude())
                && hasFieldsToInclude() == other.hasFieldsToInclude()
                && Objects.equals(fieldsToInclude(), other.fieldsToInclude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RerankingMetadataSelectiveModeConfiguration")
                .add("FieldsToExclude", fieldsToExclude() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FieldsToInclude", fieldsToInclude() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fieldsToExclude":
            return Optional.ofNullable(clazz.cast(fieldsToExclude()));
        case "fieldsToInclude":
            return Optional.ofNullable(clazz.cast(fieldsToInclude()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fieldsToExclude()} initialized to the given value.
     *
     * <p>
     * An array of objects, each of which specifies a metadata field to exclude from consideration when reranking.
     * </p>
     * 
     * @param fieldsToExclude
     *        An array of objects, each of which specifies a metadata field to exclude from consideration when
     *        reranking.
     */
    public static RerankingMetadataSelectiveModeConfiguration fromFieldsToExclude(List<FieldForReranking> fieldsToExclude) {
        return builder().fieldsToExclude(fieldsToExclude).build();
    }

    /**
     * Create an instance of this class with {@link #fieldsToInclude()} initialized to the given value.
     *
     * <p>
     * An array of objects, each of which specifies a metadata field to include in consideration when reranking. The
     * remaining metadata fields are ignored.
     * </p>
     * 
     * @param fieldsToInclude
     *        An array of objects, each of which specifies a metadata field to include in consideration when reranking.
     *        The remaining metadata fields are ignored.
     */
    public static RerankingMetadataSelectiveModeConfiguration fromFieldsToInclude(List<FieldForReranking> fieldsToInclude) {
        return builder().fieldsToInclude(fieldsToInclude).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fieldsToExclude", FIELDS_TO_EXCLUDE_FIELD);
        map.put("fieldsToInclude", FIELDS_TO_INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankingMetadataSelectiveModeConfiguration, T> g) {
        return obj -> g.apply((RerankingMetadataSelectiveModeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RerankingMetadataSelectiveModeConfiguration> {
        /**
         * <p>
         * An array of objects, each of which specifies a metadata field to exclude from consideration when reranking.
         * </p>
         * 
         * @param fieldsToExclude
         *        An array of objects, each of which specifies a metadata field to exclude from consideration when
         *        reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExclude(Collection<FieldForReranking> fieldsToExclude);

        /**
         * <p>
         * An array of objects, each of which specifies a metadata field to exclude from consideration when reranking.
         * </p>
         * 
         * @param fieldsToExclude
         *        An array of objects, each of which specifies a metadata field to exclude from consideration when
         *        reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExclude(FieldForReranking... fieldsToExclude);

        /**
         * <p>
         * An array of objects, each of which specifies a metadata field to exclude from consideration when reranking.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldsToExclude(List<FieldForReranking>)}.
         * 
         * @param fieldsToExclude
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldsToExclude(java.util.Collection<FieldForReranking>)
         */
        Builder fieldsToExclude(Consumer<FieldForReranking.Builder>... fieldsToExclude);

        /**
         * <p>
         * An array of objects, each of which specifies a metadata field to include in consideration when reranking. The
         * remaining metadata fields are ignored.
         * </p>
         * 
         * @param fieldsToInclude
         *        An array of objects, each of which specifies a metadata field to include in consideration when
         *        reranking. The remaining metadata fields are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToInclude(Collection<FieldForReranking> fieldsToInclude);

        /**
         * <p>
         * An array of objects, each of which specifies a metadata field to include in consideration when reranking. The
         * remaining metadata fields are ignored.
         * </p>
         * 
         * @param fieldsToInclude
         *        An array of objects, each of which specifies a metadata field to include in consideration when
         *        reranking. The remaining metadata fields are ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToInclude(FieldForReranking... fieldsToInclude);

        /**
         * <p>
         * An array of objects, each of which specifies a metadata field to include in consideration when reranking. The
         * remaining metadata fields are ignored.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldsToInclude(List<FieldForReranking>)}.
         * 
         * @param fieldsToInclude
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FieldForReranking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldsToInclude(java.util.Collection<FieldForReranking>)
         */
        Builder fieldsToInclude(Consumer<FieldForReranking.Builder>... fieldsToInclude);
    }

    static final class BuilderImpl implements Builder {
        private List<FieldForReranking> fieldsToExclude = DefaultSdkAutoConstructList.getInstance();

        private List<FieldForReranking> fieldsToInclude = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RerankingMetadataSelectiveModeConfiguration model) {
            fieldsToExclude(model.fieldsToExclude);
            fieldsToInclude(model.fieldsToInclude);
        }

        public final List<FieldForReranking.Builder> getFieldsToExclude() {
            List<FieldForReranking.Builder> result = FieldsForRerankingCopier.copyToBuilder(this.fieldsToExclude);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldsToExclude(Collection<FieldForReranking.BuilderImpl> fieldsToExclude) {
            Object oldValue = this.fieldsToExclude;
            this.fieldsToExclude = FieldsForRerankingCopier.copyFromBuilder(fieldsToExclude);
            handleUnionValueChange(Type.FIELDS_TO_EXCLUDE, oldValue, this.fieldsToExclude);
        }

        @Override
        public final Builder fieldsToExclude(Collection<FieldForReranking> fieldsToExclude) {
            Object oldValue = this.fieldsToExclude;
            this.fieldsToExclude = FieldsForRerankingCopier.copy(fieldsToExclude);
            handleUnionValueChange(Type.FIELDS_TO_EXCLUDE, oldValue, this.fieldsToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExclude(FieldForReranking... fieldsToExclude) {
            fieldsToExclude(Arrays.asList(fieldsToExclude));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExclude(Consumer<FieldForReranking.Builder>... fieldsToExclude) {
            fieldsToExclude(Stream.of(fieldsToExclude).map(c -> FieldForReranking.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FieldForReranking.Builder> getFieldsToInclude() {
            List<FieldForReranking.Builder> result = FieldsForRerankingCopier.copyToBuilder(this.fieldsToInclude);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldsToInclude(Collection<FieldForReranking.BuilderImpl> fieldsToInclude) {
            Object oldValue = this.fieldsToInclude;
            this.fieldsToInclude = FieldsForRerankingCopier.copyFromBuilder(fieldsToInclude);
            handleUnionValueChange(Type.FIELDS_TO_INCLUDE, oldValue, this.fieldsToInclude);
        }

        @Override
        public final Builder fieldsToInclude(Collection<FieldForReranking> fieldsToInclude) {
            Object oldValue = this.fieldsToInclude;
            this.fieldsToInclude = FieldsForRerankingCopier.copy(fieldsToInclude);
            handleUnionValueChange(Type.FIELDS_TO_INCLUDE, oldValue, this.fieldsToInclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToInclude(FieldForReranking... fieldsToInclude) {
            fieldsToInclude(Arrays.asList(fieldsToInclude));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToInclude(Consumer<FieldForReranking.Builder>... fieldsToInclude) {
            fieldsToInclude(Stream.of(fieldsToInclude).map(c -> FieldForReranking.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RerankingMetadataSelectiveModeConfiguration build() {
            return new RerankingMetadataSelectiveModeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RerankingMetadataSelectiveModeConfiguration#type()
     */
    public enum Type {
        FIELDS_TO_EXCLUDE,

        FIELDS_TO_INCLUDE,

        UNKNOWN_TO_SDK_VERSION
    }
}
