/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a column with a cell to return in retrieval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalResultContentColumn implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalResultContentColumn.Builder, RetrievalResultContentColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(RetrievalResultContentColumn::columnName))
            .setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<String> COLUMN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnValue").getter(getter(RetrievalResultContentColumn::columnValue))
            .setter(setter(Builder::columnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnValue").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RetrievalResultContentColumn::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_VALUE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String columnValue;

    private final String type;

    private RetrievalResultContentColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnValue = builder.columnValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the column.
     * </p>
     * 
     * @return The name of the column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The value in the column.
     * </p>
     * 
     * @return The value in the column.
     */
    public final String columnValue() {
        return columnValue;
    }

    /**
     * <p>
     * The data type of the value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultContentColumnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the value.
     * @see RetrievalResultContentColumnType
     */
    public final RetrievalResultContentColumnType type() {
        return RetrievalResultContentColumnType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RetrievalResultContentColumnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the value.
     * @see RetrievalResultContentColumnType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnValue());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalResultContentColumn)) {
            return false;
        }
        RetrievalResultContentColumn other = (RetrievalResultContentColumn) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(columnValue(), other.columnValue())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalResultContentColumn").add("ColumnName", columnName()).add("ColumnValue", columnValue())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "columnValue":
            return Optional.ofNullable(clazz.cast(columnValue()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columnName", COLUMN_NAME_FIELD);
        map.put("columnValue", COLUMN_VALUE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalResultContentColumn, T> g) {
        return obj -> g.apply((RetrievalResultContentColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalResultContentColumn> {
        /**
         * <p>
         * The name of the column.
         * </p>
         * 
         * @param columnName
         *        The name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The value in the column.
         * </p>
         * 
         * @param columnValue
         *        The value in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnValue(String columnValue);

        /**
         * <p>
         * The data type of the value.
         * </p>
         * 
         * @param type
         *        The data type of the value.
         * @see RetrievalResultContentColumnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultContentColumnType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the value.
         * </p>
         * 
         * @param type
         *        The data type of the value.
         * @see RetrievalResultContentColumnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalResultContentColumnType
         */
        Builder type(RetrievalResultContentColumnType type);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String columnValue;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalResultContentColumn model) {
            columnName(model.columnName);
            columnValue(model.columnValue);
            type(model.type);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnValue() {
            return columnValue;
        }

        public final void setColumnValue(String columnValue) {
            this.columnValue = columnValue;
        }

        @Override
        public final Builder columnValue(String columnValue) {
            this.columnValue = columnValue;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrievalResultContentColumnType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RetrievalResultContentColumn build() {
            return new RetrievalResultContentColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
